/* This software is Copyright 1995 by Karl-Johan Johnsson
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 */
#ifndef ArtTextP_h
#define ArtTextP_h

#include "ArtText.h"
#include "ShadowP.h"

typedef struct {
    XtPointer	extension;
} ArtTextClassPart;

typedef struct ArtTextClassRec {
    CoreClassPart       core_class;
    ShadowClassPart	shadow_class;
    ArtTextClassPart	arttext_class;
} ArtTextClassRec;

extern ArtTextClassRec artTextClassRec;

typedef enum {
    LineTypeString,
    LineTypeWString,
    LineTypeSeparator,
    LineTypeClickable
} LineType;

typedef struct {
    XtCallbackProc	callback;
    XtPointer		client_data;
} ClickData;

typedef struct TSNode {
    struct TSNode	*next;
    XFontStruct		*font;
    Pixel		pixel;
    unsigned char	type;
    union {
	struct {
	    char	*str;
	    long	len;
	} str;
	struct {
	    XChar2b	*str;
	    long	len;
	} wstr;
	struct {
	    char	*str;
	    ClickData	*data;
	} cli;
	struct {
	    Dimension	height;
	    Dimension	margin;
	} sep;
    } u;
} TSNode;

typedef struct {
    long	y;
    TSNode	*node;
    long	start;
    long	len;
} TSTable;

typedef struct {
    XFontStruct		*font;
    Pixel		highlight_pixel;
    XtCallbackList	resize_callback;
    XtCallbackList	url_callback;
    Dimension		separator_margin;
    Dimension		preferred_lines;
    Dimension		preferred_columns;
    /* private data */
    long		y0;
    long		first;
    long		lines;
    long		n_alloc;
    TSNode		*stream;
    TSNode		*last;
    TSTable		*table;
    GC			gc;
    Font		gc_fid;
    Pixel		gc_fg;
    Atom		curr_sel;
    Time		sel_time;
    long		sel_start_line;
    long		sel_stop_line;
    int			sel_start_offset;
    int			sel_stop_offset;
    Boolean		sel_ok;
    Boolean		extending;
    Boolean		extend_end;
} ArtTextPart;

typedef struct ArtTextRec {
    CorePart    core;
    ShadowPart	shadow;
    ArtTextPart	arttext;
} ArtTextRec;

#endif /* ArtTextP_h */
