#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/misc2.tcl,v $
# $Date: 1996/02/26 13:14:43 $
# $Revision: 1.16.1.12 $
#
#
proc net_doMisc2 {this chid win} {
    set line [$win get]
    $win delete 0 end
    if [regexp {^(/[a-zA-Z]+)( (.*))?$} $line dummy pr r1 rest] {
	set pr [string toupper $pr]
	if {[info procs $pr] != {}} {
	    $chid addText {} "!> $line"
	    $chid configure -hpos end
	    $pr $this $chid $rest
	    return
	} 
    }
    $chid send $line
}
#
proc /ADMIN {net chid args} { sillyPerson $chid }
#
proc /ALIAS {net chid args} { sillyPerson $chid }
#
proc /ASSIGN {net chid args} { sillyPerson $chid }
#
proc /AWAY {net chid args} { $net AWAY $args }
#
proc /BIND {net chid args} { sillyPerson $chid }
#
proc /BYE {net chid args} { $net doQuit [lindex $args 0]}
#
proc /CD {net chid args} { sillyPerson $chid }
#
proc /CHANNEL {net chid args} { sillyPerson $chid }
#
proc /CLEAR {net chid args} { sillyPerson $chid }
#
proc /COMMENT {net chid args} { sillyPerson $chid }
#
proc /CONNECT {net chid args} { sillyPerson $chid }
#
proc /CTCP {net chid args} { sillyPerson $chid }
#
proc /DATE {net chid args} { $net TIME [lindex $args 0] }
#
proc /DCC {net chid args} { sillyPerson $chid }
#
proc /DEOP {net chid args} { $net deIRCOp }
#
proc /DESCRIBE {net chid args} { sillyPerson $chid }
#
proc /DIE {net chid args} { sillyPerson $chid }
#
proc /DIGRAPH {net chid args} { sillyPerson $chid }
#
proc /DMSG {net chid args} { sillyPerson $chid }
#
proc /DQUERY {net chid args} { sillyPerson $chid }
#
proc /ECHO {net chid args} { net0 display "$chid $args" }
#
proc /ENCRYPT {net chid args} {
    sillyPerson $chid
}
#
proc /EVAL {net chid args} { sillyPerson $chid }
#
proc /EXEC {net chid args} { sillyPerson $chid }
#
proc /EXIT {net chid args} { $net doQuit [lindex $args 0]}
#
proc /FLUSH {net chid args} { sillyPerson $chid }
#
proc /FOREACH {net chid args} { sillyPerson $chid }
#
proc /HELP {net chid args} { sillyPerson $chid }
#
proc /HISTORY {net chid args} { sillyPerson $chid }
#
proc /HOOK {net chid args} { sillyPerson $chid }
#
proc /IF {net chid args} { sillyPerson $chid }
#
proc /IGNORE {net chid args} { sillyPerson $chid }
#
proc /INFO {net chid args} { $net INFO [lindex $args 0] }
#
proc /INPUT {net chid args} { sillyPerson $chid }
#
proc /INVITE {net chid args} { eval $net INVITE $args [$chid name] }
#
proc /JOIN {net chid args} { channelJoin $net [lindex $args 0] }
#
proc /KICK {net chid args} { eval $net KICK $args }
#
proc /KILL {net chid args} { eval $net KILL $args }
#
proc /LASTLOG {net chid args} { sillyPerson $chid }
#
proc /LEAVE {net chid args} { /PART $chid $args }
#
proc /LINKS {net chid args} { eval $net send LINKS $args }
#
proc /LIST {net chid args} { sillyPerson $chid }
#
proc /LOAD {net chid args} {  sillyPerson $chid }
#
proc /LUSERS {net chid args} {
    set args [lindex $args 0]
    $net send LUSERS [lindex $args 0] [lindex $args 1]
}
#
proc /ME {net chid args} { $chid action [lindex $args 0] }
#
proc /MLOAD {net chid args} { sillyPerson $chid }
#
proc /MODE {net chid args} { eval $net send MODE [lindex $args 0] }
#
proc /MOTD {net chid args} { $net send MOTD [lindex $args 0] }
#
proc /MSG {net chid args} {
    set args [lindex $args 0]
    $net send PRIVMSG [lindex $args 0] [join [lrange $args 1 end]]
}
#
proc /NAMES {net chid args} { $net NAMES $args }
#
proc /NICK {net chid args} { $net NICK [lindex $args 0] }
#
proc /NOTE {net chid args} { sillyPerson $chid }
#
proc /NOTICE {net chid args} {
    set args [lindex $args 0]
    $net NOTICE [lindex $args 0] [join [lrange $args 1 end]]
}
#
proc /NOTIFY {net chid args} { sillyPerson $chid }
#
proc /ON {net chid args} { sillyPerson $chid }
#
proc /OPER {net chid args} {
    set args [lindex $args 0]
    $net OPER [lindex $args 0] [lindex $args 1]
}
#
proc /PARSEKEY {net chid args} { sillyPerson $chid }
#
proc /PART {net chid args} {
    set args [lindex $args 0]
    if {$args == {}} { $chid leave } {
	if ![string match {nil} [set id [find [lindex $args 0]]]] { $id leave }
    }
}
#
proc /PING {net chid args} { foreach nk $args { doCtcp $net PING $nk } }
#
proc /QUERY {net chid args} {
    set msg [Message :: make [set usr [User :: make [lindex $args 0]]]]
    $msg show
    $msg addUser $usr 0 0
}
#
proc /QUIT {net chid args} { $net doQuit [lindex $args 0] }
#
proc /QUOTE {net chid args} {
    regsub -all {[][$\\"{}]} [lindex $args 0] {\\&} cmd
    eval $net send $cmd
}
#
proc /REDIRECT {net chid args} { sillyPerson $chid }
#
proc /REHASH {net chid args} { $net q1send REHASH }
#
proc /RESTART {net chid args} { $net send RESTART }
#
proc /SAVE {net chid args} { sillyPerson $chid }
#
proc /SAY {net chid args} { $chid send $args }
#
proc /SEND {net chid args} { $chid send $args }
#
proc /SENDLINE {net chid args} { sillyPerson $chid }
#
proc /SERVER {net chid args} {
    set args [lindex $args 0]
    set sv [Server :: make [lindex $args 0]]
    if {[set port [lindex $args 1]] != {}} { $sv configure -port $port }
    $net changeServer $sv
}
#
proc /SET {net chid args} { sillyPerson $chid }
#
proc /SIGNOFF {net chid args} { $net doQuit [lindex $args 0] }
#
proc /SLEEP {net chid args} { sillyPerson $chid }
#
proc /SQUIT {net chid args} { $net send SQUIT [lindex $args 0] }
#
proc /STATS {net chid args} {
    set args [lindex $args 0]
    $net send STATS [lindex $args 0] [lindex $args 1]
}
#
proc /SUMMON {net chid args} { $net send SUMMON [lindex $args 0] }
#
proc /TIME {net chid args} { $net send TIME [lindex $args 0] }
#
proc /TIMER {net chid args} { sillyPerson $chid }
#
proc /TOPIC {net chid args} { $chid configure -topic [lindex $args 0] }
#
proc /TRACE {net chid args} { sillyPerson $chid }
#
proc /TYPE {net chid args} { sillyPerson $chid }
#
proc /USERHOST {net chid args} { sillyPerson $chid }
#
proc /USERS {net chid args} { $net send USERS [lindex $args 0] }
#
proc /VERSION {net chid args} { $net send VERSION [lindex $args 0] }
#
proc /WAIT {net chid args} { sillyPerson $chid }
#
proc /WALLOPS {net chid args} { sillyPerson $chid }
#
proc /WHICH {net chid args} { sillyPerson $chid }
#
proc /WHILE {net chid args} { sillyPerson $chid }
#
proc /WHO {net chid args} { eval $net send WHO [lindex $args 0] }
#
proc /WHOIS {net chid args} { eval $net send WHOIS [lindex $args 0] }
#
proc /WHOWAS {net chid args} { eval $net send WHOWAS [lindex $args 0] }
#
proc /WINDOW {net chid args} { sillyPerson $net}
#
proc /XECHO {net chid args} { sillyPerson $net}
#
proc /XTYPE {net chid args} { sillyPerson $net}
#
proc sillyPerson {args} {
    bell
    mkDialog {} .@silly$net Silly {Don't be silly! This is Zircon!!} {} {OK {}}
    tkwait window .@silly
}
