# include <stdio.h>
# include <stdlib.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "glob.h"
# include "hdel.h"

/*
 * NAME:	hdel->main()
 * DESCRIPTION:	implement hdel command
 */
int hdel_main(int argc, char *argv[])
{
  mountent *ent;
  hfsvol *vol;
  int fargc;
  char **fargv;
  int i, result = 0;

  if (argc < 2)
    {
      fprintf(stderr, "Usage: %s hfs-path [...]\n", argv[0]);
      return 1;
    }

  vol = hfs_remount(argv[0], ent = hcwd_getvol(-1));
  if (vol == 0)
    return 1;

  fargv = hfs_glob(vol, argc - 1, &argv[1], &fargc);
  if (fargv == 0)
    {
      fprintf(stderr, "%s: out of memory\n", argv[0]);
      result = 1;
    }
  else
    {
      for (i = 0; i < fargc; ++i)
	{
	  if (hfs_delete(vol, fargv[i]) < 0)
	    {
	      hfs_perror(fargv[i]);
	      result = 1;
	    }
	}
    }

  if (hfs_umount(vol) < 0 && result == 0)
    {
      hfs_perror("Error closing HFS volume");
      result = 1;
    }

  if (fargv)
    free(fargv);

  return result;
}
