select_partition () {
	local message="$1"
	local type="$2"

	local partitions="`scan_partitions \"$type\"`"
	if [ $? -ne 0 -o -z "$partitions" ]; then
		msgBox \
"No $type disk partitions were detected. Please partition
the disks and return to this step." "Problem"
		return 1;
	fi
cat >$TempFile <<EOF
	menu \\
	 "$message" \\
	 "Select Disk Partition" \\
EOF
	local index=0
	for p in $partitions; do
		index=`math $index 1 add`
		echo -n " "$p" " >>$TempFile
		echo " \"\" \\" >>$TempFile
	done
	echo "">>$TempFile
	. $TempFile
	local status=$?
	rm -f $TempFile
	if [ $status -ne 0 ]; then return 1; fi
}
