#!	/bin/sh

first () {
	echo $1
}

second () {
	echo $2
}

last () {
	eval echo $"$#"
}

memory ()
{
	local line
	while true; do
		read line
		if [ "`first $line`" = "MemTotal:" ]; then
			echo "`second $line`"
			return 0
		fi
	done
}

find_swap_partitions ()
{
	local line
	while true; do
		read line
		if [ "$line" = "-EOF-" ]; then
			return 0
		fi
		if [ "`last $line`" = "swap" ]; then
			echo "`first $line`"
		fi
	done
}

low_memory ()
{
	local action drive line

	if [ `memory </proc/meminfo` -ge 3464 ]; then return 0; fi
	
	while true; do
		clear
		echo \
"This system has relatively little memory. For a system like this, it's
recommended to activate the swap disk partition before starting Debian's
graphical installation menu system, as there may not be enough RAM available
to run the graphical program without the virtual memory provided by the swap
partition. Thus, you should:

1. Run the disk partitioning program to add a \"Linux swap\" (type 82)
   partition. If you want to create a \"Linux native\" (type 83) partition
   or any other partitions on the same disk drive, you should do that at the
   same time. You will not be able to re-partition the drive once you have
   activated a swap partition on it.
2. Once you have created the swap partition, you should then initialize
   and activate that partition.
3. Once your swap partition has been activated, you should run the graphical
   installation menu system.

Please select an action from the menu below:

1. Run the disk partitioning program.
2. Initialize and activate the swap partition.
3. Start the graphical installation menu system.
"
		read action
		case "$action" in 
		1)
			clear
			echo "Please wait while disk drives are detected..."
			local drives="`tryopen -w /dev/hd[a-z] /dev/sd[a-z]`"
			clear
			if [ -z "$drives" ]; then
				echo \
"No hard disk drives could be found. Make sure they are cabled
correctly and are turned on before the system is started. You
may have to change driver settings when you start the system
with a command at the \"boot:\" prompt, or you may have to load
a driver that is in a loadable module to solve this problem."
			else
				echo \
"The following drives are available. Drives that are named /dev/hdX
are IDE, ATA, MFM, or RLL drives. Drives that are named /dev/sdX are
SCSI drives."
				for d in $drives; do
					echo "	"$d
				done
				echo -n "
Please type a drive name from the above list: "
				read drive
				if [ -n "$drive" ]; then
					cfdisk $drive
				fi
			fi
			;;
		2)
			clear
			echo "Please wait while swap partitions are detected..."
			fdisk -l > /tmp/$$ 2>/dev/null
			echo "-EOF-" >>/tmp/$$
			local partitions="`find_swap_partitions < /tmp/$$`"
			rm -f /tmp/$$
			clear
			if [ -z "$partitions" ]; then
				echo "
No swap partitions are available. You must select menu item 1 and create
one.

Please press enter when you are ready to continue."
				read line
			else
				echo "These swap partitions are available: "
				for p in $partitions; do
					echo "	"$p
				done
				echo -n "
Please type a partition name from the above list to use: "
				read drive
				if [ -z "$drive" ]; then
					continue
				fi
				echo -n "
This will permanently destroy all data on $drive. Type \"y\" to continue,
type \"n\" to cancel: "
				read line
				case "$line" in 
				y|Y)
					mkswap $drive
					if [ $? -eq 0 ]; then
						swapon $drive
						Swap=$drive
						export Swap
					fi
					echo \
"Please press enter when you are ready to continue."
					read line
					;;
				esac
			fi
			;;
		3)
			return 0
			;;
		esac
	done
	echo "Please wait while the graphical installation system starts..."
	return 0
}
low_memory
