// -*- C++ -*-
/*
 *  This file is part of LyX, the High Level Word Processor
 *
 *  GNU Copyleft (C) 1996   LyX Team. 
 *
 *  Created: 15/05/96 Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 * 
 *  Dependencies:  Only XFoms, but designed to be easyly used by LyX.
 * 
 *  Description:  A Menu class encapsulates standard text menus.
 *                You can use Menu to construct, modify, display and 
 *                query menu objects. A Menu can also include
 *                submenus, short cuts, binary items, etc.
 * 
 */ 

/* Change log:
 *  
 *  15/05/1996,   Alejandro Aguilar Sierra 
 *    Created and tested the class Menu. It can handle short cuts
 *    and submenus in a very easy way. Binary and disabled items not
 *    yet implemented, but this could be done externally on the
 *    tables using XForms syntax.
 * 
 */ 

#ifndef MENU_H
#define MENU_H

#include "forms.h"
#include <stdlib.h>

// Menu tags
#define MENU_SUBMENU    -1 
#define MENU_SEPARATOR  -2

// Return  values in case that anything else were selected.
// These could be used by a Menubar object.
#define MENU_NONE       -1
#define MENU_LEFT       -2 
#define MENU_RIGHT      -3


//  A Menu is initialized with a table of this struct.
struct menu_table_item {
   int action;        //  Value associated with the menu item.
   char* label;       //  Label to appear in the menu
   char* keyb;        //  Shortcut (XForms syntax)  
};


class Menu
{
 public:
   Menu(void); 
   
   // Table and number of items in the table
   Menu(menu_table_item*, int);
   ~Menu();
   
   // Table and number of items in the table
   void setTable(menu_table_item*, int);
   
   // These functions are only for main menus (not submenus)
   void setName(const char*);
   char* getName(void) { return title; }
   
   // A submenu is a Menu object previously created. 
   // Can contain other submenus.
   void addSubmenu(Menu*);
   void setSubmenu(Menu*, int);
   
   // Before to show a menu assign a parent window
   void setParent(Window);
   
   //  Open the menu and return the action selected
   int show(int, int);
   
   // Return the mode of the selected item
   int getMode(void)  { return mode; }

 protected:
   int getpup(void);
   void freepup(void);

 private:
   static void menu_cb(FL_OBJECT *, long);
   int nitems, nsm;
   int isbm;
   int popup;
   int mode;
   char *title;
   menu_table_item* table;
   Menu** submenu;  // array of submenus
   Window parent;   
};

typedef Menu* MenuPtr;

#endif

