/*Copyright (c) 1993-1994 Xerox Corporation.  All Rights Reserved.

  Permission to use, copy, modify  and  distribute  without  charge
  this  software,  documentation, images, etc. is granted, provided
  that this copyright and the author's name is retained.

  A fee may be charged for this program ONLY to recover  costs  for
  distribution  (i.e.  media costs).  No profit can be made on this
  program.

  The author assumes no responsibility for  disasters  (natural  or
  otherwise) as a consequence of use of this software.

  Adam Stein (adam@iset.scan.mc.xerox.com)
*/

#include <stdio.h>
#include <ctype.h>
#include "xtoolplaces.h"

/*This routine will fix a problem caused by xview.  This routine is needed
  since xview seems to screw up WM_COMMAND when a command is started using
  the -Wl option (window label) with a string of more than 23 characters.  It
  does this by putting some of the label string after the last number for the
  icon position.  For exmaple, if a WM_SAVE_YOURSELF is sent to xrolo,
  WM_COMMAND is set to:

xrolo -Wp 29 278 -Ws 592 309 -WP 1085 241 1)" -Wl "Rolo - .work  (Card 1 of 1)"

  The ' 1)"' after -WP 1085 241 shouldn't be there.  It seems to do this only
  with WM_COMMAND strings that are a single string (as opposed to xcalctool
  for example which breaks up the WM_COMMAND string where each word is it's
  own string).

  To fix the problem, the offending characters are replaces with spaces.

  Inputs:  string  - WM_COMMAND string
  Outputs: none
  Locals:  pointer - pointer to go through string
  Globals: NULL    - 0
*/
fix_command(string)
char *string;
{
        char *pointer;

        /*See if we have a string with the potential -WP problem*/
        if((pointer = strstr(string,"-WP")) != NULL) {
          /*Get to 2nd icon position*/
          pointer = strstr(pointer," ");
          pointer = strstr(++pointer," ");

          /*Skip over Y icon position, which can consist of numbers or
            the + or - signs*/
          while(isdigit(*(++pointer)) || (*pointer == '+') ||
                (*pointer == '-'))
            ;

          /*Change screwed up characters to spaces*/
          while(*pointer && *pointer != '-' && *pointer != '+')
            *(pointer++) = ' ';
        }
}

