#!/bin/sh
# 
# install.sh 
# Install AXENE software 1.3
# 
# Copyright (c)1995,1996 AXENE. All Rights reserved.
# EMail: <axene@axene.com>
# Web  : http://www.axene.com/
# 
# Started on  Fri Nov 17 17:34:10 1995 Nucleus
# Last update Fri Nov 15 19:30:33 1996 
#

ECHONL1="echo "
ECHONL2=

test_echo=`echo -n test`
if [ $test_echo = "-n test" ]; then
 test_echo=`echo "test\c"`
 if [ $test_echo = "test\c" ]; then
  test_echo=`echo -e "test\c"`
  if [ $test_echo = "test" ]; then
   ECHONL1="echo -e "
   ECHONL2="\c"
  fi
 else
  ECHONL1="echo "
  ECHONL2="\c"
 fi
else
  ECHONL1="echo -n "
fi

#--- Init global variables
SkipLine() { echo " "; }
Fatal() { echo "${progname}: error: ${1}" 1>&2 ; exit 1; }
#Debug() { echo "${progname}: debug: ${1}" 1>&2 ; }
Debug() { :; }

progname=`basename $0`
cmd_gunzip=
cmd_tar=
src_dir=`pwd`
archive_list=

is_common="no"
is_exec="no"
is_xcl="no"
is_xquad="no"
is_xmayday="no"

# ----------------------------------------------------------------- # 
# CheckDir - Check existence and authorizations on directory        #
#            <path>                                                 # 
# ----------------------------------------------------------------- #
CheckDir()
{
  if [ ! -d $1 ]; then
    echo "  creating dir $1"
    mkdir $1 || exit 1
    chmod 755 $1 || exit 1
  else
    Debug "  $1 already exists"
    if [ ! -w $1 -o ! -x $1 -o ! -r $1 ]; then
      Fatal "$1 not readable, not writable or not executable."
    fi
  fi
}

# ---------------------------------------------------------------------- # 
# AskOneFromList - Let the user choose an item among a list              # 
#                  <text> <default-index> <var > <choice-1>...<choice-n> #
# ---------------------------------------------------------------------- #
AskOneFromList()
{
  _ask_text=$1
  _ask_default=$2
  _ask_var=$3
  shift 3
  _arg_all=$@
  _arg_num=$#

  while :; do
    if [ "$force_flag" = "yes" ]; then
      return $_ask_default
    else
      echo $_ask_text
      _ask_count=0
      while [ $_ask_count -lt $_arg_num ]; do
        if [ $_ask_count -eq $_ask_default ]; then
          _ask_reply="(DEFAULT)"
        else
          _ask_reply=
        fi
        _ask_count=`expr $_ask_count + 1`
        eval "echo \"  \$_ask_count. \$1 $_ask_reply\""
	shift 1
      done

      $ECHONL1"Your choice: "$ECHONL2
      read _ask_reply

      if [ -z "$_ask_reply" ]; then
	_arg_cnt=0
        for _ask_phrase in $_arg_all; do
         if [ $_arg_cnt -eq $_ask_default ]; then
          eval "$_ask_var=\"\$_ask_phrase\""
          break
        fi
        _arg_cnt=`expr $_arg_cnt + 1`
        done        
	return $_ask_default
      fi
      if [ $_ask_reply -gt 0 -a $_ask_reply -le $_arg_num ]; then
        SkipLine
	_arg_cnt=1
        for _ask_phrase in $_arg_all; do
         if [ $_arg_cnt -eq $_ask_reply ]; then
          eval "$_ask_var=\"\$_ask_phrase\""
          break
         fi
         _arg_cnt=`expr $_arg_cnt + 1`
        done
        return `expr $_ask_reply - 1`
      fi
      echo "ERROR: You must enter a number between 1 and $_arg_num"
    fi
  done
}    

# ------------------------------------------------------------------ # 
# AskManyFromList - Let the user choose items among a list           # 
#                   <text> <variable> <choice-1> ... <choice-n>      #
# ------------------------------------------------------------------ #
AskManyFromList()
{
  _ask_text=$1
  _ask_var=$2

  shift 2
  _arg_all=$@
  _arg_num=$#

  echo "$_ask_text (ex: 1 2)"
  _ask_count=0
  while [ $_ask_count -lt $_arg_num ]; do
    _ask_count=`expr $_ask_count + 1`
    eval "echo \"  \$_ask_count. \$1\""
    shift 1
  done

  $ECHONL1"Your choice: "$ECHONL2
  read _ask_reply
 
  eval $_ask_var=
  for _ask_nb in $_ask_reply; do
    if [ $_ask_nb -ge 1 -a $_ask_nb -le $_arg_num ]; then
      _arg_cnt=1
      for _ask_phrase in $_arg_all; do
        if [ $_arg_cnt -eq $_ask_nb ]; then
          eval "$_ask_var=\"\$$_ask_var \$_ask_phrase\""
          break
        fi
        _arg_cnt=`expr $_arg_cnt + 1`
      done
    else
      eval $_ask_var= 
      echo "ERROR: Each number must be between 1 and $_arg_num"
      return 1
    fi
  done
  SkipLine
  return 0
}

# ------------------------------------------------------------------ # 
# AskYesNo - Let the user choose for y or n                          # 
#                   <text> <var>                                     #
# ------------------------------------------------------------------ #
AskYesNo()
{
  _message=$1
  _answer=$2

  $ECHONL1$_message" "$ECHONL2

  read _ask_proceed

  _answer=-1
  if [ "$_ask_proceed" = "n" -o "$_ask_proceed" = "no" ]; then
    _answer=0
  fi

  if [ "$_ask_proceed" = "y"  -o "$_ask_proceed" = "yes" ]; then
    _answer=1
  fi
  return 0
}
# ----------------------------------------------------------------- # 
# Main part                                                         # 
# ----------------------------------------------------------------- #

cat << __EOT__
==============================================================================
                Welcome to the AXENE Installation Script
==============================================================================

  BY INSTALLING THIS SOFTWARE, YOU ARE CONSENTING TO BE BOUND BY THE LICENSE
  AGREEMENT (check out the LICENSE file).  IF YOU DO NOT AGREE TO ALL OF THE 
       TERMS OF THE LICENSE AGREEMENT, CANCEL THE INSTALLATION PROCESS.

==============================================================================

__EOT__

_answer=-1
while [ "$_answer" = "-1" ]; do
 AskYesNo "Proceed installation ? [y/n]:" _answer
 if [ $_answer = 0 ]; then
   echo "Installation aborted."
   exit 0
 fi
done
SkipLine

#Does not work with linux
#test -r *.tar.gz || Fatal "No package found in current dir"

_file=*.tar.gz
if [ "`echo $_file`" = "*.tar.gz" ]; then
 Fatal "No package found in current dir"
fi

AskManyFromList "Please select packages to be installed" archive_list *.tar.gz
test -z "$archive_list" && Fatal "No package selected"

#--- Get basedir ---
prefix=`dirname ${AXENE_LIB:-${XCLAMATION_LIB:-${XQUAD_LIB:-${XMAYDAY_LIB:-/usr/Axene/install}}}}`
echo "Where do you want to install the software ?"
echo "(DEFAULT: $prefix)"
$ECHONL1"Your location: "$ECHONL2
read _ask
test -z "$_ask" || prefix=$_ask
CheckDir $prefix

#--- Get Gunzip and tar ---
Debug "Find Gunzip and tar"
old_ifs="$IFS"
IFS="$IFS:"
for mypath in $PATH; do
  if [ -n "$mypath" ]; then
    test -z "$cmd_gunzip" -a -x $mypath/gunzip && cmd_gunzip=$mypath/gunzip
    test -z "$cmd_tar" -a -x $mypath/gtar && cmd_tar=$mypath/gtar
    test -z "$cmd_tar" -a -x $mypath/tar && cmd_tar=$mypath/tar
  fi
done
IFS=$old_ifs

#--- Check Gunzip ---
if [ -z "$cmd_gunzip" ]; then
  echo "command \`gunzip' not found, please enter full path and name"
  echo "(RETURN: Abort installation)"
  cmd_gunzip="NoNe"
  while [ ! -x $cmd_gunzip -o -d $cmd_gunzip ]; do
   $ECHONL1"Your \`gunzip' location: "$ECHONL2
   read _ask
   test -n "$_ask" || Fatal "You can get gunzip for your machine at ftp.axene.com"
   cmd_gunzip="$_ask"
   if [ -d $cmd_gunzip ]; then
    echo "command '$cmd_gunzip' is a directory, try again (or RETURN to abort)"
    continue
   fi
   if [ ! -x $cmd_gunzip ]; then
    echo "command '$cmd_gunzip' not found, try again (or RETURN to abort)"
   fi
  done
else
  echo "Using $cmd_gunzip to decompress archives"
fi

#--- Check tar ---
if [ -z "$cmd_tar" ]; then
  echo "Command \`tar' not found, please enter location"
  echo "(RETURN: Abort installation)"
  cmd_tar="NoNe"
  while [ ! -x $cmd_tar -o -d $cmd_tar ]; do
   $ECHONL1"Your \`tar' location: "$ECHONL2
   read _ask
   test -n "$_ask" || Fatal "Installation aborted"
   cmd_tar="$_ask"
   if [ -d $cmd_tar ]; then
    echo "'$cmd_tar' is a directory, try again (or RETURN to abort)"
    continue
   fi
   if [ ! -x $cmd_tar ]; then
    echo "file '$cmd_tar' not found, try again (or RETURN to abort)"
   fi
  done
else
  echo "Using $cmd_tar to extract files from archives"
fi

for _package in $archive_list; do
  _tmp_str=`echo $_package | grep "^common"`
  if [ -n "$_tmp_str" ]; then is_common="yes"; fi
  _tmp_str=`echo $_package | grep "^Xclamation"`
  if [ -n "$_tmp_str" ]; then is_xcl="yes"; is_exec="yes" ; fi
  _tmp_str=`echo $_package | grep "^XQuad"`
  if [ -n "$_tmp_str" ]; then is_xquad="yes"; is_exec="yes" ; fi
  _tmp_str=`echo $_package | grep "^XMayday"`
  if [ -n "$_tmp_str" ]; then is_xmayday="yes"; is_exec="yes" ; fi
done

if [ $is_common = "yes" -o $is_xmayday = "yes" ]; then
 if [ -f $prefix/lib/X11/nls/nls.dir -a ! -w $prefix/lib/X11/nls/nls.dir ]; then
  rm -fr $prefix/lib/X11
 fi
fi

#--- Depack archives ---
cd $prefix
for archive in $archive_list; do
  SkipLine
  echo "=============================================================="
  echo "Depacking archive $archive:"
  echo "=============================================================="
  $cmd_gunzip -cd $src_dir/$archive | $cmd_tar xvpf - || Fatal "Installation aborted"
done


if [ $is_exec = "yes" ]; then
 #--- Get languages ---
 SkipLine
 languages=
 test -r lib/locale/languages || Fatal "The \`languages' file is missing!"
 exec 5<lib/locale/languages
 while read lang <&5 ; do
   languages="$languages $lang"
 done
 exec 5<&-
 AskOneFromList "Choose language" 0 lang $languages

 #--- Link ressources files ---
 if [ ! -d $prefix/app-defaults ]; then
  mkdir $prefix/app-defaults || exit 1
  chmod 755 $prefix/app-defaults || exit 1
 fi

 #--- Link config files ---
 cd $prefix/lib/locale/
 for file in *rc.$lang; do
   cd $prefix/lib
   file=`basename $file .$lang`
   if [ ! -f $file -o -w $file ]; then
    if [ -f $file ]; then
     echo deleting old $file
     rm $file
    fi
    ln -s locale/$file.$lang $file
   fi
 done

 cd $prefix/lib/locale/
 for file in X*.$lang; do
   cd $prefix/app-defaults
   file=`basename $file .$lang`
   if [ ! -f $file -o -w $file ]; then
    if [ -f $file ]; then
     echo deleting old $file
     rm $file
    fi
    ln -s ../lib/locale/$file.$lang $file
   fi
 done
fi 
 
if [ $is_xcl = "yes" ]; then

#--- Create Exec Script For Xcl ---
echo "Building script for Xclamation: Xcl"
cat << __EOT__ > $prefix/Xcl
#!/bin/sh
# 
# Xcl
# Xclamation script
# 
# Copyright (c)1996. All Rights reserved Axene.
# EMail: <xcalibur@axene.com>
# 
# Started on  Fri Nov 17 17:34:10 1995 Nucleus
# Last update Fri Feb  9 14:47:40 1996 Gudul
#

#--- Init global variables
SkipLine() { echo " "; }
Fatal() { echo "\${progname}: error: \${1}" 1>&2 ; exit 1; }

progname=\`basename \$0\`
bin_list=
name_base=Xclamation

# ---------------------------------------------------------------------- # 
# AskOneFromList - Let the user choose an item among a list              # 
#                  <text> <default-index> <var > <choice-1>...<choice-n> #
# ---------------------------------------------------------------------- #
AskOneFromList()
{
  _ask_text=\$1
  _ask_default=\$2
  _ask_var=\$3
  shift 3
  _arg_all=\$@
  _arg_num=\$#

  while :; do
    if [ "\$force_flag" = "yes" ]; then
      return \$_ask_default
    else
      echo \$_ask_text
      _ask_count=0
      while [ \$_ask_count -lt \$_arg_num ]; do
        if [ \$_ask_count -eq \$_ask_default ]; then
          _ask_reply="(DEFAULT)"
        else
          _ask_reply=
        fi
        _ask_count=\`expr \$_ask_count + 1\`
        eval "echo \"  \\\$_ask_count. \\\$1 \$_ask_reply\""
	shift 1
      done
      read _ask_reply
      if [ -z "\$_ask_reply" ]; then
	_arg_cnt=0
        for _ask_phrase in \$_arg_all; do
         if [ \$_arg_cnt -eq \$_ask_default ]; then
          eval "\$_ask_var=\"\\\$_ask_phrase\""
          break
        fi
        _arg_cnt=\`expr \$_arg_cnt + 1\`
        done        
	return \$_ask_default
      fi
      if [ \$_ask_reply -gt 0 -a \$_ask_reply -le \$_arg_num ]; then
        SkipLine
	_arg_cnt=1
        for _ask_phrase in \$_arg_all; do
         if [ \$_arg_cnt -eq \$_ask_reply ]; then
          eval "\$_ask_var=\"\\\$_ask_phrase\""
          break
         fi
         _arg_cnt=\`expr \$_arg_cnt + 1\`
        done
        return \`expr \$_ask_reply - 1\`
      fi
      echo "ERROR: You must enter a number between 1 and \$_arg_num"
      exit 1
    fi
  done
} 

Count()
{
 Glob_count=\$#
}

# ---------------------------------------------------------------------- # 
# ---------------------------------------------------------------------- #
TestInHostList()
{
 _Host=\`hostname\`
 echo testing for host \$_Host
  
 _count_exec=0
 for _file in \$ZHOME/bin/\${name_base}*; do
  if [ -x \$_file ]; then
   _count_exec=1
   break;
  fi
 done

 if [ "\$_count_exec" -eq "0" ]; then
   Fatal "No executable found in \$ZHOME/bin/"
 fi

 _No_Host=0
 _Bin_ok=0
 test -r \$ZHOME/lib/locale/xcl.hosts || _No_Host=1
 if [ "\$_No_Host" -eq "0" ]; then
  exec 5<\$ZHOME/lib/locale/xcl.hosts
  while read _v_host <&5 ; do
    if [ "\$_v_host" = "\$_Host" ]; then
     read bin_list <&5
     echo "host \$_Host is already associated " 
     echo "with program \$bin_list"
     _Bin_ok=1
     while read _v_host <&5 ; do
     echo flush > /dev/null
     done
    else
     read _v_burk <&5
     read _v_burk <&5
    fi
  done
  exec 5<&-
 else
  echo "No xcl.hosts defined."
  if [ -w \$ZHOME/lib/locale/ ]; then
   touch \$ZHOME/lib/locale/xcl.hosts
  else
   echo "Not authorized to write into directory \$ZHOME/lib/locale/"
  fi
 fi
	
 if [ "\$_Bin_ok" -eq "0" ]; then
  Count \$ZHOME/bin/\${name_base}*
  if [ \$Glob_count -eq "1" ]; then
   bin_list=\$ZHOME/bin/\${name_base}*
   echo \$bin_list "is the only executable in this directory"
   if [ -w \$ZHOME/lib/locale/xcl.hosts ]; then
    echo \$_Host >> \$ZHOME/lib/locale/xcl.hosts
    echo \$bin_list >> \$ZHOME/lib/locale/xcl.hosts
    echo ----- >> \$ZHOME/lib/locale/xcl.hosts
   fi
  else 
   AskOneFromList "Please select the program to execute on \$_Host" 0 bin_list \$ZHOME/bin/\${name_base}*
   if [ ! -w \$ZHOME/lib/locale/xcl.hosts ]; then
    echo "Could not add this entry to \$ZHOME/lib/locale/xcl.hosts"
   else
    echo "\$_Host is now associated with program \$bin_list"
    echo "(if error, edit or delete \$ZHOME/lib/locale/xcl.hosts)" 
    echo \$_Host >> \$ZHOME/lib/locale/xcl.hosts
    echo \$bin_list >> \$ZHOME/lib/locale/xcl.hosts
    echo ----- >> \$ZHOME/lib/locale/xcl.hosts
   fi
  fi
 fi
 echo "Execute \${bin_list}"
}

ZHOME=$prefix
AXENE_LIB=\$ZHOME/lib
XCLAMATION_LIB=\$ZHOME/lib
XAPPLRESDIR=\$ZHOME/app-defaults
export AXENE_LIB XCLAMATION_LIB XAPPLRESDIR

TestInHostList
\$bin_list \$@

__EOT__
chmod 755 $prefix/Xcl
fi

if [ $is_xquad = "yes" ]; then 
#--- Create Exec Script For XQuad ---
echo "Building script for XQuad: XQuad"
cat << __EOT__ > $prefix/XQuad
#!/bin/sh
# 
# XQuad
# XQuad script
# 
# Copyright (c)1996. All Rights reserved Axene.
# EMail: <xcalibur@axene.com>
# 
# Started on  Fri Nov 17 17:34:10 1995 Nucleus
# Last update Fri Feb  9 14:47:40 1996 Gudul
#

#--- Init global variables
SkipLine() { echo " "; }
Fatal() { echo "\${progname}: error: \${1}" 1>&2 ; exit 1; }

progname=\`basename \$0\`
bin_list=
name_base=XQuad

# ---------------------------------------------------------------------- # 
# AskOneFromList - Let the user choose an item among a list              # 
#                  <text> <default-index> <var > <choice-1>...<choice-n> #
# ---------------------------------------------------------------------- #
AskOneFromList()
{
  _ask_text=\$1
  _ask_default=\$2
  _ask_var=\$3
  shift 3
  _arg_all=\$@
  _arg_num=\$#

  while :; do
    if [ "\$force_flag" = "yes" ]; then
      return \$_ask_default
    else
      echo \$_ask_text
      _ask_count=0
      while [ \$_ask_count -lt \$_arg_num ]; do
        if [ \$_ask_count -eq \$_ask_default ]; then
          _ask_reply="(DEFAULT)"
        else
          _ask_reply=
        fi
        _ask_count=\`expr \$_ask_count + 1\`
        eval "echo \"  \\\$_ask_count. \\\$1 \$_ask_reply\""
	shift 1
      done
      read _ask_reply
      if [ -z "\$_ask_reply" ]; then
	_arg_cnt=0
        for _ask_phrase in \$_arg_all; do
         if [ \$_arg_cnt -eq \$_ask_default ]; then
          eval "\$_ask_var=\"\\\$_ask_phrase\""
          break
        fi
        _arg_cnt=\`expr \$_arg_cnt + 1\`
        done        
	return \$_ask_default
      fi
      if [ \$_ask_reply -gt 0 -a \$_ask_reply -le \$_arg_num ]; then
        SkipLine
	_arg_cnt=1
        for _ask_phrase in \$_arg_all; do
         if [ \$_arg_cnt -eq \$_ask_reply ]; then
          eval "\$_ask_var=\"\\\$_ask_phrase\""
          break
         fi
         _arg_cnt=\`expr \$_arg_cnt + 1\`
        done
        return \`expr \$_ask_reply - 1\`
      fi
      echo "ERROR: You must enter a number between 1 and \$_arg_num"
      exit 1
    fi
  done
} 

Count()
{
 Glob_count=\$#
}

# ---------------------------------------------------------------------- # 
# ---------------------------------------------------------------------- #
TestInHostList()
{
 _Host=\`hostname\`
 echo testing for host \$_Host
 _count_exec=0
 for _file in \$ZHOME/bin/\${name_base}*; do
  if [ -x \$_file ]; then
   _count_exec=1
   break;
  fi
 done

 if [ "\$_count_exec" -eq "0" ]; then
   Fatal "No executable found in \$ZHOME/bin/"
 fi

 _No_Host=0
 _Bin_ok=0
 test -r \$ZHOME/lib/locale/xquad.hosts || _No_Host=1
 if [ "\$_No_Host" -eq "0" ]; then
  exec 5<\$ZHOME/lib/locale/xquad.hosts
  while read _v_host <&5 ; do
    if [ "\$_v_host" = "\$_Host" ]; then
     read bin_list <&5
     echo "host \$_Host is already associated "
     echo "with program \$bin_list"
     _Bin_ok=1
     while read _v_host <&5 ; do
     echo flush > /dev/null
     done
    else
     read _v_burk <&5
     read _v_burk <&5
    fi
  done
  exec 5<&-
 else
  echo "No xquad.hosts defined."
  if [ -w \$ZHOME/lib/locale/ ]; then
   touch \$ZHOME/lib/locale/xquad.hosts
  else
   echo "Not authorized to write into directory \$ZHOME/lib/locale/"
  fi
 fi

 if [ "\$_Bin_ok" -eq "0" ]; then
  Count \$ZHOME/bin/\${name_base}*
  if [ \$Glob_count -eq "1" ]; then
   bin_list=\$ZHOME/bin/\${name_base}*
   echo \$bin_list "is the only executable in this directory"
   if [ -w \$ZHOME/lib/locale/xquad.hosts ]; then
    echo \$_Host >> \$ZHOME/lib/locale/xquad.hosts
    echo \$bin_list >> \$ZHOME/lib/locale/xquad.hosts
    echo ----- >> \$ZHOME/lib/locale/xquad.hosts
   fi
  else 
   AskOneFromList "Please select the program to execute on \$_Host" 0 bin_list \$ZHOME/bin/\${name_base}*
   if [ ! -w \$ZHOME/lib/locale/xquad.hosts ]; then
    echo "Could not add this entry to \$ZHOME/lib/locale/xquad.hosts"
   else
    echo "\$_Host is now associated with program \$bin_list"
    echo "(if error, edit or delete \$ZHOME/lib/locale/xquad.hosts)" 
    echo \$_Host >> \$ZHOME/lib/locale/xquad.hosts
    echo \$bin_list >> \$ZHOME/lib/locale/xquad.hosts
    echo ----- >> \$ZHOME/lib/locale/xquad.hosts
   fi
  fi
 fi
 echo "Execute \${bin_list}"
}

ZHOME=$prefix
AXENE_LIB=\$ZHOME/lib
XQUAD_LIB=\$ZHOME/lib
XAPPLRESDIR=\$ZHOME/app-defaults
export AXENE_LIB XQUAD_LIB XAPPLRESDIR

TestInHostList
\$bin_list \$@

__EOT__
chmod 755 $prefix/XQuad
fi

if [ $is_xmayday = "yes" ]; then 
#--- Create Exec Script For XMayday ---
echo "Building script for XMayday: XMayday"
cat << __EOT__ > $prefix/XMayday
#!/bin/sh
# 
# XMayday
# XMayday script
# 
# Copyright (c)1996. All Rights reserved Axene.
# EMail: <xcalibur@axene.com>
# 
# Started on  Fri Nov 17 17:34:10 1995 Nucleus
# Last update Fri Feb  9 14:47:40 1996 Gudul
#

#--- Init global variables
SkipLine() { echo " "; }
Fatal() { echo "\${progname}: error: \${1}" 1>&2 ; exit 1; }

progname=\`basename \$0\`
bin_list=
name_base=XMayday

# ---------------------------------------------------------------------- # 
# AskOneFromList - Let the user choose an item among a list              # 
#                  <text> <default-index> <var > <choice-1>...<choice-n> #
# ---------------------------------------------------------------------- #
AskOneFromList()
{
  _ask_text=\$1
  _ask_default=\$2
  _ask_var=\$3
  shift 3
  _arg_all=\$@
  _arg_num=\$#

  while :; do
    if [ "\$force_flag" = "yes" ]; then
      return \$_ask_default
    else
      echo \$_ask_text
      _ask_count=0
      while [ \$_ask_count -lt \$_arg_num ]; do
        if [ \$_ask_count -eq \$_ask_default ]; then
          _ask_reply="(DEFAULT)"
        else
          _ask_reply=
        fi
        _ask_count=\`expr \$_ask_count + 1\`
        eval "echo \"  \\\$_ask_count. \\\$1 \$_ask_reply\""
	shift 1
      done
      read _ask_reply
      if [ -z "\$_ask_reply" ]; then
	_arg_cnt=0
        for _ask_phrase in \$_arg_all; do
         if [ \$_arg_cnt -eq \$_ask_default ]; then
          eval "\$_ask_var=\"\\\$_ask_phrase\""
          break
        fi
        _arg_cnt=\`expr \$_arg_cnt + 1\`
        done        
	return \$_ask_default
      fi
      if [ \$_ask_reply -gt 0 -a \$_ask_reply -le \$_arg_num ]; then
        SkipLine
	_arg_cnt=1
        for _ask_phrase in \$_arg_all; do
         if [ \$_arg_cnt -eq \$_ask_reply ]; then
          eval "\$_ask_var=\"\\\$_ask_phrase\""
          break
         fi
         _arg_cnt=\`expr \$_arg_cnt + 1\`
        done
        return \`expr \$_ask_reply - 1\`
      fi
      echo "ERROR: You must enter a number between 1 and \$_arg_num"
      exit 1
    fi
  done
} 

Count()
{
 Glob_count=\$#
}

# ---------------------------------------------------------------------- # 
# ---------------------------------------------------------------------- #
TestInHostList()
{
 _Host=\`hostname\`
 echo testing for host \$_Host
 _count_exec=0
 for _file in \$ZHOME/bin/\${name_base}*; do
  if [ -x \$_file ]; then
   _count_exec=1
   break;
  fi
 done

 if [ "\$_count_exec" -eq "0" ]; then
   Fatal "No executable found in \$ZHOME/bin/"
 fi

 _No_Host=0
 _Bin_ok=0
 test -r \$ZHOME/lib/locale/xmayday.hosts || _No_Host=1
 if [ "\$_No_Host" -eq "0" ]; then
  exec 5<\$ZHOME/lib/locale/xmayday.hosts
  while read _v_host <&5 ; do
    if [ "\$_v_host" = "\$_Host" ]; then
     read bin_list <&5
     echo "host \$_Host is already associated "
     echo "with program \$bin_list"
     _Bin_ok=1
     while read _v_host <&5 ; do
     echo flush > /dev/null
     done
    else
     read _v_burk <&5
     read _v_burk <&5
    fi
  done
  exec 5<&-
 else
  echo "No xmayday.hosts defined."
  if [ -w \$ZHOME/lib/locale/ ]; then
   touch \$ZHOME/lib/locale/xmayday.hosts
  else
   echo "Not authorized to write into directory \$ZHOME/lib/locale/"
  fi
 fi

 if [ "\$_Bin_ok" -eq "0" ]; then
  Count \$ZHOME/bin/\${name_base}*
  if [ \$Glob_count -eq "1" ]; then
   bin_list=\$ZHOME/bin/\${name_base}*
   echo \$bin_list "is the only executable in this directory"
   if [ -w \$ZHOME/lib/locale/xmayday.hosts ]; then
    echo \$_Host >> \$ZHOME/lib/locale/xmayday.hosts
    echo \$bin_list >> \$ZHOME/lib/locale/xmayday.hosts
    echo ----- >> \$ZHOME/lib/locale/xmayday.hosts
   fi
  else 
   AskOneFromList "Please select the program to execute on \$_Host" 0 bin_list \$ZHOME/bin/\${name_base}*
   if [ ! -w \$ZHOME/lib/locale/xmayday.hosts ]; then
    echo "Could not add this entry to \$ZHOME/lib/locale/xmayday.hosts"
   else
    echo "\$_Host is now associated with program \$bin_list"
    echo "(if error, edit or delete \$ZHOME/lib/locale/xmayday.hosts)" 
    echo \$_Host >> \$ZHOME/lib/locale/xmayday.hosts
    echo \$bin_list >> \$ZHOME/lib/locale/xmayday.hosts
    echo ----- >> \$ZHOME/lib/locale/xmayday.hosts
   fi
  fi
 fi
 echo "Execute \${bin_list}"
}

ZHOME=$prefix
AXENE_LIB=\$ZHOME/lib
XMAYDAY_LIB=\$ZHOME/lib
XAPPLRESDIR=\$ZHOME/app-defaults
export AXENE_LIB XMAYDAY_LIB XAPPLRESDIR

TestInHostList
\$bin_list \$@

__EOT__
chmod 755 $prefix/XMayday
fi

if [ -w "/usr/local/bin" ]; then
 SkipLine

 if [ $is_xcl = "yes" ]; then
  _answer=-1
  while [ "$_answer" = "-1" ]; do
   AskYesNo "Make Xclamation available from /usr/local/bin ? [y/n]:" _answer
   if [ $_answer = 1 ]; then
     if [ -f /usr/local/bin/Xcl ]; then
      _answer=-1
      while [ "$_answer" = "-1" ]; do
       AskYesNo "\ File /usr/local/bin/Xcl exists ! Delete it ? [y/n]:" \
		_answer
       if [ $_answer = 1 ]; then
        echo "\ Removing file /usr/local/bin/Xcl."
	rm -f "/usr/local/bin/Xcl"
        echo "Linking "$prefix"/Xcl to /usr/local/bin/Xcl."
        ln -s $prefix/Xcl /usr/local/bin/Xcl
       fi 
      done
     else
      echo "Linking "$prefix"/Xcl to /usr/local/bin/Xcl."
      ln -s $prefix/Xcl /usr/local/bin/Xcl
     fi
   fi 
  done
 fi

 if [ $is_xquad = "yes" ]; then
  _answer=-1
  while [ "$_answer" = "-1" ]; do
   AskYesNo "Make XQuad available from /usr/local/bin ? [y/n]:" _answer
   if [ $_answer = 1 ]; then
     if [ -f /usr/local/bin/XQuad ]; then
      _answer=-1
      while [ "$_answer" = "-1" ]; do
       AskYesNo "\ File /usr/local/bin/XQuad exists ! Delete it ? [y/n]:" \
		_answer
       if [ $_answer = 1 ]; then
        echo "\ Removing file /usr/local/bin/XQuad."
	rm -f "/usr/local/bin/XQuad"
        echo "Linking "$prefix"/XQuad to /usr/local/bin/XQuad."
        ln -s $prefix/XQuad /usr/local/bin/XQuad
       fi 
      done
     else
      echo "Linking "$prefix"/XQuad to /usr/local/bin/XQuad."
      ln -s $prefix/XQuad /usr/local/bin/XQuad
     fi
   fi 
  done
 fi

 if [ $is_xmayday = "yes" ]; then
  _answer=-1
  while [ "$_answer" = "-1" ]; do
   AskYesNo "Make XMayday available from /usr/local/bin ? [y/n]:" _answer
   if [ $_answer = 1 ]; then
     if [ -f /usr/local/bin/XMayday ]; then
      _answer=-1
      while [ "$_answer" = "-1" ]; do
       AskYesNo "\ File /usr/local/bin/XMayday exists ! Delete it ? [y/n]:" \
		_answer
       if [ $_answer = 1 ]; then
        echo "\ Removing file /usr/local/bin/XMayday."
	rm -f "/usr/local/bin/XMayday"
        echo "Linking "$prefix"/XMayday to /usr/local/bin/XMayday."
        ln -s $prefix/XMayday /usr/local/bin/XMayday
       fi 
      done
     else
      echo "Linking "$prefix"/XMayday to /usr/local/bin/XMayday."
      ln -s $prefix/XMayday /usr/local/bin/XMayday
     fi
   fi 
  done
 fi
fi

cat << __EOM__

 ========================
 == INSTALLATION DONE. ==
 ========================

__EOM__

if [ ! -d $prefix/lib/fonts ]; then 
 if [ $is_xcl = "yes" -a $is_xquad = "yes" ]; then
  echo "You must install the common.tar.gz package to get Xclamation and "
  echo "XQuad working."
 elif [ $is_xcl = "yes" ]; then
  echo "You must install the common.tar.gz package to get Xclamation working."
 elif [ $is_xquad = "yes" ]; then
  echo "You must install the common.tar.gz package to get XQuad working."
 fi
fi

SkipLine




