#! /bin/sh
##  $Header: /nfs/papaya/u2/rsalz/src/newsgate/RCS/news2mail.sh,v 1.3 91/02/12 14:50:28 rsalz Exp $
##  A short, mostly-awk, script to send news on stdin out as mail.
##  Usage:  news2mail <address>
##  Written by John S. Quarterman <jsq@longway.tic.com>.
##  Light editing by Rich $alz <rsalz@bbn.com>.
PATH=/usr/local:/usr/ucb:/bin:/usr/bin ; export PATH

case $1 in
"")
    echo "Usage:  `basename $0` address"
    exit 1
    ;;
"-")
    TO="cat -u"
    ;;
*)
    TO="/bin/mail $1"
    ;;
esac

awk '
BEGIN {
    header = 1;
    date = "";
}
header == 1 && /^$/ {
    # End of headers; print dates.
    header = 0;
    if (pdate != "" && date ~ /GMT/ && pdate !~ /GMT/) {
	print "Date: "pdate;
	print "Posted-Date: "date;
    } else {
	if (date != "")
	    print "Date: "date;
	if (pdate != "")
	    print "Posted-Date: "pdate;
    }
}
header == 0 {
    print $0;
    next;
}
$1 == "Relay-Version:"		{ next; }
$1 == "Posting-Version:"	{ next; }
$1 == "Path:"			{ next; }
$1 == "From"			{ next; }
$1 == "Date-Received:"		{ next; }
$1 == "Received-Date:"		{ next; }
#$1 == "Newsgroups:"		{ next; }
#$1 == "Organization:"		{ next; }
$1 == "Approved:"		{ next; }
$1 == "Lines:"			{ next; }
$1 == "Date:" {
    date = $2;
    for (i = 3; i <= NF; i++)
	date = date " " $i;
    next;
}
$1 == "Posted-Date:" {
    pdate = $2;
    for (i = 3; i <= NF; i++)
	pdate = pdate " " $i;
    next;
}
$1 == "From:" {
    address=$2;
    name = "";
    surround = 0;
    for (f = 3; f <= NF; f++) {
	if ($f ~ /,/)
	    surround=1;
	if (split ($f, parts, "(") > 1)
	    it = parts[2];
	else
	    it = $f;
	if (split ($f, parts, ")") > 1)
	    it = parts[1];
	if (name == "")
	    name = it;
	else
	    name = name " " it;
    }
    if (address ~ /.UUCP$/) {
	split(address, parts, "@");
	address = sprintf ("%s%%%s@%s", parts[1], parts[2], "'`hostname`'");
    }
    if (surround != 0)
	    printf ("From: %s (%s)\n", address, name);
    else
	    printf ("From: %s <%s>\n", name, address);
    next;
}
{
    print $0;
}' | eval $TO
