#ifndef MP_OUTPUT_H
#define MP_OUTPUT_H
/*****************************************************************
**
** MathSpad 0.60
**
** Copyright 1996, Eindhoven University of Technology (EUT)
** 
********************************************************************/
/*
**  output.h
*/

#define VISIBLE   0
#define INVISIBLE 1
#define SHADES    2
#define SMART     3

#define OFF       0
#define ON        1

#define CURSOR    0
#define MARK      1
#define CURSORHOLLOW 2
#define MARKHOLLOW   3

typedef enum { ExprOpen, ExprClose, SOpOpen, SOpClose, LOpOpen, LOpClose,
               SIdOpen, SIdClose, LIdOpen, LIdClose, VarOpen, VarClose,
               TextOpen, TextClose, DispOpen, DispClose
	   } TexCode;

extern int more_keys(void);
extern int saved_chars;

extern void set_message_window(void *w);
extern void out_message(char *txt);
extern void out_message_curs(char *txt);
extern void clear_message(Bool allways);
extern void draw_message(void);
extern void *test_window(void);
extern void set_output_window(void *w);
extern void unset_output_window(void);
extern void out_clear(void);
extern void switch_thick(void);
extern void switch_thin(void);
extern void switch_reverse(void);
extern void set_text_mode(int mode);
extern void set_underline(Bool on);
extern void set_default_thinspace(int n);
extern void set_italic(Bool on);
extern int  next_id_font(int nr);
extern void set_index(Bool on);
extern void set_drawstyle(int style);
extern void set_margin(int newmargin);
extern void set_smart_height(int height);
extern void set_search_func(void (*func)(void*), int x, int y);
extern void detect_margin(void);
extern int  where_x(void);
extern int  where_y(void);
extern void set_x_y(int new_x, int new_y);
extern void set_x(int new_x);
extern void set_y(int new_y);
extern int  char_width(Char data, int size);
extern void clear_to_end_of_page(void);
extern void flush(void);
extern void out_text_delim(int on);
extern void out_index(int data);
extern void out_cursor(int kind);
extern void open_node(void* data);
extern void close_node(void);
extern void out_char(Char data);
extern Bool display_tab(Char data);
extern void out_string(char *str);
extern void thinspace(int spacing);
extern int  line_height(void);
extern void output_init(void);
extern void put_mark(int x, int y);
extern void tab_unlock(void *ts);
extern void* tab_lock(void);
extern void set_tab_stack(void *ts, int nropen);
extern Bool tab_equal(void *ts);
extern void open_tabbing(void);
extern void close_tabbing(void);
extern void open_display(void);
extern void close_display(void);
extern void settabsize(int newsize);
extern int  getsimpletabsize(void);
extern void setsimpletabsize(int newsize);
extern void opspace(int size);

extern void push_math_pref(Bool premath);
extern void pop_math_pref(void);
extern void tex_set_file(FILE *f);
extern void tex_open_proof(void);
extern void tex_close_proof(void);
extern void tex_unset(void);
extern int  tex_current_pos(void);
extern void tex_placeholders(Bool texthem);
extern void out_latex_char(Char c);
extern void set_display_delta(int d);
extern void tex_code(TexCode c);
extern void tex_to_mode(int tmode);
extern void tex_set_string(char **string);
extern void tex_mode(int mode);
#endif
