/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** hashTable.h
*/

# ifndef HTABLE_H
# define HTABLE_H

/*@constant int HBUCKET_BASESIZE; @*/
# define HBUCKET_BASESIZE 2

/*@constant int HBUCKET_DNE; @*/
# define HBUCKET_DNE NOT_FOUND

typedef struct _hashTable *hashTable ;

typedef struct _hentry
{
  /*@dependent@*/ cstring key;
                  int     val;
} hentry;

typedef /*@null@*/ struct _hbucket
{
  int size;
  int nspace;
  /*@only@*/ hentry *entries;
} *hbucket;

typedef /*@only@*/ hbucket o_hbucket;

struct _hashTable
{
  int size;
  int nentries;
  /*@only@*/ o_hbucket *buckets;
} ;


extern /*@only@*/ hashTable hashTable_create(int size);
extern void hashTable_insert (hashTable h, cstring key, int value);
extern int hashTable_lookup (hashTable h, cstring key);
extern /*@unused@*/ /*@only@*/ cstring hashTable_stats(hashTable h);
extern void hashTable_free (/*@only@*/ hashTable h);
extern void hashTable_remove (hashTable h, cstring key) /*@modifies h@*/ ;
extern void 
  hashTable_replaceKey (hashTable h, cstring oldkey, /*@dependent@*/ cstring newkey);

# else
# error "Multiple include"
# endif 













