/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** fileIdList.h
*/

# ifndef FILEIDLIST_H
# define FILEIDLIST_H

/*@access ctype fileId ctypeList@*/
/*@+allmacros@*/

abst_typedef /*@null@*/ ctypeList fileIdList;

extern /*@falsenull@*/ bool fileIdList_isDefined (fileIdList f);
# define fileIdList_isDefined(f)  (ctypeList_isDefined (f))

/*@iter fileIdList_elements (sef fileIdList x, yield fileId el); @*/
# define fileIdList_elements(x, m_el) \
   if (fileIdList_isDefined (x)) \
    { int m_ind; fileId *m_elements = &((x)->elements[0]); \
      for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
        { fileId m_el = *(m_elements++); 

# define end_fileIdList_elements }}

extern fileIdList fileIdList_create (void);
# define fileIdList_create()       ctypeList_new()

extern bool fileIdList_isEmpty (/*@sef@*/ fileIdList f) /*@*/ ;

extern void fileIdList_add (fileIdList f, fileId fid) /*@modifies f@*/;
# define fileIdList_add(f, el)     ctypeList_addh((ctypeList)(f), (ctype)(el))

extern int fileIdList_size (/*@sef@*/ fileIdList f);
# define fileIdList_size(ft)       ctypeList_size((ctypeList)(ft))

extern void fileIdList_free (/*@only@*/ fileIdList f) /*@modifies f@*/;
# define fileIdList_free(ft)       ctypeList_free((ctypeList)(ft)) 

# define fileIdList_isEmpty(f)     (fileIdList_size (f) == 0)
/*@noaccess ctype fileId ctypeList@*/

# else
# error "Multiple include"
# endif


