/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgFFTLow.c                                                   */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:39 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "FFTLow"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *im;
  int width,height,x,y,halfwidth,halfheight;
  double u,v,radsqd,cutoff;
  double phwc,phhc;
  it_complex *cpx_ptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Fourier high cut, low-pass filter\n",
	      PRGNAME);
      fprintf(stderr,"img%s [cutoff]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Complex\n");
      fprintf(stderr,"  stdout: Complex\n");
      fprintf(stderr,"  cutoff is the transition frequency in radians/pixel\n");
      exit(0);
    }

  cutoff=1.17741; /* Smooth 1 half height position */
  if(argc>2)
    ERROR("invalid arguments");
  if(argc==2)
    cutoff=atof(argv[1]);
  cutoff*=cutoff;
  imgStart(PRGNAME);

  /* Loop for all images */
  do {
    im=i_read_image_file(stdin,IT_COMPLEX,IM_FRAGMENT);
    if(im==NULL) i_error("can't import image");
    width=im->width;
    height=im->height;
    halfwidth=width/2;
    halfheight=height/2;
    phwc=M_PI/((double) halfwidth);
    phhc=M_PI/((double) halfheight);
    for(y=0;y<height;y++)
      {
	cpx_ptr=im_complex_row(im,y);
	for(x=0;x<width;x++,cpx_ptr++)
	  {
	    u=phwc*(double) ((x<halfwidth)?(x):(x-width));
	    v=phhc*(double) ((y<halfheight)?(y):(y-height));
	    radsqd=u*u+v*v;
	    if(radsqd>=cutoff)
	      cpx_ptr->Re=cpx_ptr->Im=0.0;
	  }
      }
    i_write_image_file(stdout,im,IF_BINARY);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
