.TH convert 1 "19 Feb 1995" "ImageMagick"
.SH NAME
convert - converts an input file using one image format to an output
file with a differing image format.
.SH SYNOPSIS
.B "convert"
[ \fIoptions\fP ... ] \fIinput_file\fP \fIoutput_file\fP
.SH DESCRIPTION
\fBconvert\fP converts an input file using one image format to an output file
with a differing image format.

\fBconvert\fP recognizes the following image formats:

.TP 7
.B Tag
\fBDescription\fP
.PP
-------------------------------------------------------------------------------
.TP 7
.B AVS
AVS X image file.
.TP 7
.B BIE+
Joint Bi-level Image experts Group file interchange format.
.TP 7
.B BMP+
Microsoft Windows bitmap image file.
.TP 7
.B CGM
Computer Graphics Metafile.
.TP 7
.B CMYK
Raw cyan, magenta, yellow, and black bytes.
.TP 7
.B DCX+
ZSoft IBM PC multi-page Paintbrush file.
.TP 7
.B DIB
Microsoft Windows bitmap image file.
.TP 7
.B EPS
Adobe Encapsulated PostScript file.
.TP 7
.B EPS2
Adobe Level II Encapsulated PostScript file.
.TP 7
.B EPSF
Adobe Encapsulated PostScript file.
.TP 7
.B EPSI
Adobe Encapsulated PostScript Interchange format.
.TP 7
.B FAX+
Group 3.
.TP 7
.B FITS
Flexible Image Transport System.
.TP 7
.B GIF+
CompuServe graphics interchange format; 8-bit color.
.TP 7
.B GIF87+
CompuServe graphics interchange format; 8-bit color (version 87a).
.TP 7
.B GRAY
Raw gray bytes.
.TP 7
.B GRADATION
gradual passing from one shade to another. Specify the desired shading as the
filename (e.g. gradation:red-blue).
.TP 7
.B GRANITE
granite texture.
.TP 7
.B HDF+
Hierarchical Data Format.
.TP 7
.B HTML
Hypertext Markup Language with a client-side image map.
.TP 7
.B HISTOGRAM
.TP 7
.B JBIG+
Joint Bi-level Image experts Group file interchange format.
.TP 7
.B JPEG
Joint Photographic Experts Group JFIF format; compressed 24-bit color.
.TP 7
.B MAP
Red, green, and blue colormap bytes followed by the image colormap indexes.
.TP 7
.B MATTE
Raw matte bytes.
.TP 7
.B MIFF+
Magick image file format.
.TP 7
.B MONO
Bi-level bitmap in least-significant-byte (LSB) first order.
.TP 7
.B MPEG+
Motion Picture Experts Group file interchange format.
.TP 7
.B MTV+
MTV Raytracing image format.
.TP 7
.B NETSCPAPE
Netscape 216 color cube.
.TP 7
.B NULL
NULL image.
.TP 7
.B PBM+
Portable bitmap format (black and white).
.TP 7
.B PCD
Photo CD.
.TP 7
.B PCL
Page Control Language.
.TP 7
.B PCX
ZSoft IBM PC Paintbrush file.
.TP 7
.B PDF+
Portable Document Format.
.TP 7
.B PGM+
Portable graymap format (gray scale).
.TP 7
.B PICT
Apple Macintosh QuickDraw/PICT file.
.TP 7
.B PLASMA
plasma fractal image.  Specify the base color as the filename
(e.g. plasma:gray).   Use \fBfractal\fP to initialize to a random value
(e.g. plasma:fractal).
.TP 7
.B PNG
Portable Network Graphics.
.TP 7
.B PNM+
Portable anymap.
.TP 7
.B PPM+
Portable pixmap format (color).
.TP 7
.B PS+
Adobe PostScript file.
.TP 7
.B PS2+
Adobe Level II PostScript file.
.TP 7
.B RAD
Radiance image format.
.TP 7
.B RGB
Raw red, green, and blue bytes.
.TP 7
.B RGBA
Raw red, green, blue and matte bytes.
.TP 7
.B RLA
Alias/Wavefront image file; read only
.TP 7
.B RLE
Utah Run length encoded image file; read only.
.TP 7
.B SGI+
Irix RGB image file.
.TP 7
.B SHTML
Hypertext Markup Language with a client-side image map.
.TP 7
.B SUN+
SUN Rasterfile.
.TP 7
.B TEXT
raw text file; read only.
.TP 7
.B TGA+
Truevision Targa image file.
.TP 7
.B TIFF+
Tagged Image File Format.
.TP 7
.B TILE
tile image with a texture.
.TP 7
.B UYVY
16bit/pixel interleaved YUV (e.g. used by AccomWSD).
.TP 7
.B VICAR
read only.
.TP 7
.B VID
Visual Image Directory.
.TP 7
.B VIFF+
Khoros Visualization image file.
.TP 7
.B X
select image from X server screen.
.TP 7
.B XC
constant image of X server color.  Specify the desired color as the filename
(e.g. xc:yellow).
.TP 7
.B XBM
X11 bitmap file.
.TP 7
.B XPM
X Windows system pixmap file (color).
.TP 7
.B XWD
X Windows system window dump file (color).
.TP 7
.B YUV
CCIR 601 4:1:1 file.
.PP
Note, a format delineated with \fB+\fP means that if more than one image is
specified, it is combined into a single multi-image file.  Use
\fB+adjoin\fP if you want a single image produced for each frame.
.PP
Raw images are expected to have one byte per pixel unless \fBImageMagick\fP
is compiled in 16-bit mode.  Here, the raw data is expected to be stored
two bytes per pixel in most-significant-byte-first order.
.PP
.SH EXAMPLES
.PP
To convert a \fIMIFF\fP image of a cockatoo to a SUN raster image, use:
.PP
.B
     convert cockatoo.miff sun:cockatoo.ras
.PP
To convert a multi-page \fIPostscript\fP document to individual FAX pages, use:
.PP
.B
     convert -monochrome document.ps fax:page
.PP
To convert a TIFF image to a \fIPostscript\fP A4 page with the image in
the lower left-hand corner, use:
.PP
.B
     convert -page A4+0+0 image.tiff document.ps
.PP
To convert a raw \fBGRAY\fP image with a 128 byte header to a portable graymap,
use:
.PP
.B
     convert -size 768x512+128 gray:raw image.pgm
.PP
To convert a Photo CD image to a TIFF image, use:
.PP
.B
     convert -size 1536x1024 img0009.pcd image.tiff
     convert img0009.pcd[4] image.tiff
.PP
To create a visual image directory of all your JPEG images, use:
.PP
.B
     convert 'vid:*.jpg' directory.miff
.PP
To annotate an image with blue text using font 12x24 at position (100,100),
use:
.PP
.B
     convert -font 12x24 -pen blue -draw "text +100+100 Cockatoo" bird.jpg bird.miff
.PP
To tile a 640x480 image with a JPEG texture with bumps use:
.PP
.B
     convert -size 640x480 tile:bumps.jpg tiled.png
.PP
To surround an icon with an ornamental border to use with \fBMosaic(1)\fP, use:
.PP
.B
     convert -mattecolor #ccc -frame 6x6 bird.jpg icon.png
.PP
To create a GIF animation image from a DNA molecule sequence, use:
.PP
.B
     convert -delay 20 dna.* dna.gif
.PP
.SH OPTIONS
.TP
.B "-adjoin
join images into a single multi-image file.
.TP
.B "-average
averages a set of images.
.TP
.B "-blur \fIfactor\fP"
blurs an image.  Specify \fIfactor\fP as the percent enhancement
(0.0 - 99.9%).
.TP
.B "-border \fI<width>x<height>\fP"
surround the image with a border of color.  See \fBX(1)\fP for details
about the geometry specification.

The color of the border is specified with the \fB-bordercolor\fP command line
option.
.TP
.B "-box \fIcolor\fP"
set the color of the annotation bounding box.  See \fB-draw\fP or
for further details.
 
See \fBX(1)\fP for details about the color specification.
.TP
.B "-charcoal \fIfactor\fP"
simulate a charcoal drawing.
.TP
.B "-colorsize \fIvalue\fP"
colorize the image with the pen color.

Specify the amount of colorization as a percentage.  You can apply separate
colorization values to the red, green, and blue channels of the image with a
colorization value list delineated with slashes (e.g. 0/0/50).
.TP
.B "-colors \fIvalue\fP"
preferred number of colors in the image.

The actual number of colors in the image may be less than your request,
but never more.  Note, this is a color reduction option.  Images with
less unique colors than specified with this option will remain unchanged.
Refer to \fBquantize(9)\fP for more details.

Note, options \fB-dither\fP, \fB-colorspace\fP, and \fB-treedepth\fP affect
the color reduction algorithm.
.TP
.B "-colorspace \fIvalue\fP"
the type of colorspace: \fBGRAY\fP, \fBOHTA\fP, \fBRGB\fP, 
\fBTransparent\fP, \fBXYZ\fP, \fBYCbCr\fP, \fBYIQ\fP, \fBYPbPr\fP, or
\fBYUV\fP.

Color reduction, by default, takes place in the RGB color space.
Empirical evidence suggests that distances in color spaces such as YUV
or YIQ correspond to perceptual color differences more closely
than do distances in RGB space.  These color spaces may give better
results when color reducing an image.  Refer to \fBquantize(9)\fP for
more details.

The \fBTransparent\fP color space behaves uniquely in that it preserves
the matte channel of the image if it exists.

The \fB-colors\fP or \fB-monochrome\fP option is required for this option
to take effect.
.TP
.B "-comment \fIstring\fP"
annotate an image with a comment.

By default, each image is commented with its file name.  Use this
option to assign a specific comment to the image.  Optionally you can
include the image filename, type, width, height, or scene number by
embedding special format characters.  Embed \fB%f\fP for filename,
\fB%m\fP for magick, \fB%w\fP for width, \fB%h\fP for height, \fB%s\fP
for scene number, \fB%b\fP for file size in kilobytes, or \fB\\n\fP for
newline.  For example,

.nf
     -comment "%m:%f %wx%h"
.fi

produces an image comment of \fBMIFF:bird.miff 512x480\fP for an image
titled \fBbird.miff\fP and whose width is 512 and height is 480.

If the first character of \fIstring\fP is \fB@\fP, the image comment is read
from a file titled by the remaining characters in the string.
.TP
.B "-compress \fItype\fP"
the type of image compression: \fIZip\fP or \fIRunlengthEncoded\fP.

Specify \fB\+compress\fP to store the binary image in an uncompressed format.
The default is the compression type of the specified image file.
.TP
.B "-contrast"
enhance or reduce the image contrast.

This option enhances the intensity differences between the
lighter and darker elements of the image.  Use \fB-contrast\fP to
enhance the image or \fB+contrast\fP to reduce the image contrast.
.TP
.B "-crop \fI<width>{%}x<height>{%}{\+-}<x offset>{\+-}<y offset>\fP"
preferred size and location of the cropped image.  See \fBX(1)\fP for details
about the geometry specification.

To specify a percentage width or height instead, append \fB%\fP.  For example
to crop the image by ten percent on all sides of the image, use
\fB-crop 10%\fP.

Use cropping to crop a particular area of an image.   Use \fB-crop
0x0\fP to remove edges that are the background color.  Omit the x and y offset
to generate one or more subimages of a uniform size.
.TP
.B "-cycle \fIamount\fP"
displace image colormap by amount.

\fIAmount\fP defines the number of positions each colormap entry is shifted.
.TP
.B "-delay \fI<1/100ths of a second>\fP"
display the next image after pausing.
 
This option is useful for regulating the animation of a sequence of
GIF images within Netscape.  \fI1/100ths of a second\fP must expire
before the redisplay of the image sequence.  The default is no delay
between each showing of the image sequence.  The maximum delay is 65535.
.TP
.B "-density \fI<width>x<height>\fP
vertical and horizontal resolution in pixels of the image.

This option specifies an image density when decoding a Postscript or
Portable Document page.  The default is 72 pixels per inch in the horizontal
and vertical direction.
.TP
.B "-despeckle"
reduce the speckles within an image.
.TP
.B "-display \fIhost:display[.screen]\fP"
specifies the X server to contact; see \fBX(1)\fP.
.TP
.B "-dispose \fImethod\fP"
GIF disposal method.

Graphics Interchange Format (GIF) Specification 89a of July 31, 1990 for
details.
.TP
.B "-dither"
apply Floyd/Steinberg error diffusion to the image.

The basic strategy of dithering is to trade intensity resolution for
spatial resolution by averaging the intensities of several neighboring
pixels.  Images which suffer from severe contouring when reducing colors
can be improved with this option.

The \fB-colors\fP option is required for dithering to take effect.
.TP
.B "-draw \fIstring\fP"
annotate an image with one or more graphic primitives.

Use this option to annotate an image with one or more graphic primitives.
The primitives include

.nf
  point
  line
  rectangle
  fillRectangle
  circle
  fillCircle
  polygon
  fillPolygon
  color
  matte
  text
  image
.fi

\fBPoint\fP, \fBline\fP, \fBcolor\fP, \fBmatte\fP, \fBtext\fP, and
\fBimage\fP each require a single coordinate.  \fBLine\fP requires a
start and end coordinate, while \fBrectangle\fP expects an upper left
and lower right coordinate.  \fBCircle\fP has a center coordinate and a
coordinate on the outer edge.  Finally, \fBpolygon\fP requires three or
more coordinates defining its boundaries.  Coordinates are integers
separated by an optional comma.  For example, to define a circle
centered at 100,100 that extends to 150,150 use:

.nf
  -draw 'circle 100,100 150,150'
.fi

Use \fBcolor\fP to change the color of a pixel.  Follow the
pixel coordinate with a method:

.nf
  point
  replace
  floodfill
  reset
.fi

Consider the target pixel as that specified by your coordinate.  The
\fBpoint\fP method recolors the target pixel.  The \fBreplace\fP method
recolors any pixel that matches the color of the target pixel.
\fBFloodfill\fP recolors any pixel that matches the color of the target
pixel and is a neighbor.  Finally, \fBreset\fP recolors all pixels.
 
Use \fBmatte\fP to the change the pixel matte value to transparent.
Follow the pixel coordinate with a method (see the \fBcolor\fB
primitive for a description of methods).  The \fBpoint\fP method
changes the matte value of the target pixel.  The \fBreplace\fP method
changes the matte value of any pixel that matches the color of the
target pixel.  \fBFloodfill\fP changes the matte value of any pixel
that matches the color of the target pixel and is a neighbor. Finally
\fBreset\fP changes the matte value of all pixels.

Use \fBtext\fP to annotate an image with text.  Follow the
text coordinates with a string.  If the string has embedded spaces,
enclose it in double quotes.  Optionally you can
include the image filename, type, width, height, or scene number by
embedding special format characters.  Embed \fB%f\fP for filename,
\fB%m\fP for magick, \fB%w\fP for width, \fB%h\fP for height, \fB%s\fP
for scene number, \fB%b\fP for file size in kilobytes, or
\fB\\n\fP for newline.  For example,

.nf
     -draw 'text 100,100 "%m:%f %wx%h"'
.fi

annotates the image with \fBMIFF:bird.miff 512x480\fP for an image
titled \fBbird.miff\fP and whose width is 512 and height is 480.

If the first character of the string is \fB@\fP, the text is read
from a file titled by the remaining characters in the string.

Use \fBimage\fP to composite an image with another image.  Follow the
image coordinates with the filename of an image.

If the first character of \fIstring\fP is \fB@\fP, the text is read
from a file titled by the remaining characters in the string.

You can set the primitive color, font color, and font bounding box color with
\fB-pen\fP, \fB-font\fP, and \fB-box\fP respectively.  Options are
processed in command line order so be sure to use \fB-pen\fP
\fIbefore\fP the \fB-draw\fP option.
.TP
.B "-edge \fIfactor\fP"
detect edges with an image.  Specify \fIfactor\fP as the percent enhancement
(0.0 - 99.9%).
.TP
.B "-emboss"
emboss the image.
.TP
.B "-enhance"
apply a digital filter to enhance a noisy image.
.TP
.B "-equalize"
perform histogram equalization to the image.
.TP
.B "-flip"
create a "mirror image" by reflecting the image scanlines in the vertical
direction.
.TP
.B "-flop"
create a "mirror image" by reflecting the image scanlines in the horizontal
direction.
.TP
.B "-font \fIname\fP"
use this font when annotating the image with text.

\fBConvert\fP contacts an X server to obtain the font.  If an X server is not
available, a Postscript font is used.  You can set the pointsize with
\fB-pointsize\fP.
.TP
.B "-frame \fI<width>x<height>+<outer bevel width>+<inner bevel width>\fP"
surround the image with an ornamental border.  See \fBX(1)\fP for details
about the geometry specification.

The color of the border is specified with the \fB-mattecolor\fP command line
option.
.TP
.B "-gamma \fIvalue\fP"
level of gamma correction.

The same color image displayed on two different workstations may look
different due to differences in the display monitor.  Use gamma
correction to adjust for this color difference.  Reasonable values
extend from 0.8 to 2.3.

You can apply separate gamma values to the red, green, and blue
channels of the image with a gamma value list delineated with slashes
(e.g. 1.7/2.3/1.2).
.TP
.B "-geometry \fI<width>{%}x<height>{%}{!}{<}{>}\fP"
preferred size or location of the image when encoding.

By default, the width and height are maximum values.  That is, the
image is expanded or contracted to fit the width and height value while
maintaining the aspect ratio of the image.  Append an exclamation point
to the geometry to force the image size to exactly the size you
specify.  For example, if you specify \fB640x480!\fP the image width is
set to 640 pixels and height to 480.  If only one factor is
specified, both the width and height assume the value.

To specify a percentage width or height instead, append \fB%\fP.  The
image size is multiplied by the width and height percentages to obtain
the final image dimensions.  To increase the size of an image, use a
value greater than 100 (e.g. 125%).  To decrease an image's size, use a
percentage less than 100.

Use \fB>\fP to change the dimensions of the image \fIonly\fP
if its size exceeds the geometry specification.  \fB<\fP resizes
the image \fIonly\fP if its dimensions is less than the geometry
specification.  For example, if you specify \fB640x480>\fP and the
image size is 512x512, the image size does not change.  However, if
the image is 1024x1024, it is resized to 640x480.

There are 72 pixels per inch in Postscript coordinates.
.TP
.B "-implode \fIfactor\fP"
implode image pixels about the center.  Specify \fIfactor\fP as the percent
implosion (0 - 99.9%) or explosion (-99.9 - 0%).
.TP
.B "-interlace \fItype\fP"
the type of interlacing scheme: \fBNone\fP, \fBLine\fP, \fBPlane\fP, or
\fBPartition\fP.  The default is \fBPlane\fP.

This option is used to specify the type of interlacing scheme for raw
image formats such as \fBRGB\fP or \fBYUV\fP.  \fBNone\fP means do not
interlace (RGBRGBRGBRGBRGBRGB...), \fBLine\fP uses scanline
interlacing (RRR...GGG...BBB...RRR...GGG...BBB...), and \fBPlane\fP uses
plane interlacing (RRRRRR...GGGGGG...BBBBBB...).  \fBPartition\fP is like
plane except the different planes are saved to individual files (e.g.
image.R, image.G, and image.B).

Use \fBLine\fP, or \fBPlane\fP to create an interlaced GIF or progressive
JPEG image.
.TP
.B "-label \fIname\fP"
assign a label to an image.

Use this option to assign a specific label to the image.  Optionally
you can include the image filename, type, width, height, or scene
number in the label by embedding special format characters.   Embed
\fB%f\fP for filename, \fB%m\fP for magick, \fB%w\fP for width,
\fB%h\fP for height, \fB%s\fP for scene number, \fB%b\fP for file size in
kilobytes, or \fB\\n\fP for newline.  For example,
.nf
     -label "%m:%f %wx%h"
.fi
produces an image label of \fBMIFF:bird.miff 512x480\fP for an image
titled \fBbird.miff\fP and whose width is 512 and height is 480.

If the first character of \fIstring\fP is \fB@\fP, the image label is read
from a file titled by the remaining characters in the string.

When converting to Postscript, use this option to specify a header string
to print above the image.
.TP
.B "-linewidth \fIvalue\fP"
set the width of a line.  See \fB-draw\fP for further details.
.TP
.B "-loop \fIiterations\fP"
add Netscape loop extension to your GIF animation.

A value other than zero forces the animation to repeat itself up to
\fIiterations\fP times.
.TP
.B "-map \fIfilename\fP"
choose a particular set of colors from this image.

By default, color reduction chooses an optimal set of colors that
best represent the original image.  Alternatively, you can choose a
particular set of colors from an image file with this option.  Use
\fB+map\fP to reduce all images provided on the command line to a single
optimal set of colors that best represent all the images.
.TP
.B "-matte"
store matte channel if the image has one.
.TP
.B "-modulate \fIvalue\fP"
vary the brightness, saturation, and hue of an image.

Specify the percent change in brightness, the color saturation, and the color
hue separated by commas.  For example, to increase the color brightness
by 20% and decrease the color saturation by 10% and leave the hue unchanged,
use: \fB-modulate 20/-10\fP.
.TP
.B "-monochrome"
transform the image to black and white.
.TP
.B "-negate"
apply color inversion to image.

The red, green, and blue intensities of an image are negated.  Use
\fB+negate\fP to only negate the grayscale pixels of the image.
.TP
.B "-noise"
add or reduce the noise in an image.

The principal function of noise peak elimination filter is to smooth
the objects within an image without losing edge information and without
creating undesired structures.  The central idea of the algorithm is to
replace a pixel with its next neighbor in value within a 3 x 3 window,
if this pixel has been found to be noise.  A pixel is defined as noise
if and only if this pixel is a maximum or minimum within the 3 x 3 window.
.PP
Use \fB+noise\fP followed by a noise type to add noise to an image.  Choose
from these noise types:
.PP
    uniform
    gaussian
    multiplicative
    impulse
    laplacian
    poisson
.TP
.B "-normalize"
transform image to span the full range of color values.

This is a contrast enhancement technique.
.TP
.B "-opaque \fIcolor\fP"
change this color to the pen color within the image.  See \fB-pen\fP for
more details.
.TP
.B "-page \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP"
preferred size and location of the Postscript page.

Use this option to specify the dimensions of the Postscript page in
pixels per inch or a TEXT page in pixels.  The default for a Postscript page is
to center the image on a letter page 612 by 792 pixels. The
margins are 1/2" (i.e.  612x792+42+42).  Other common sizes are:

    Letter      612x 792
    Tabloid     792x1224
    Ledger     1224x 792
    Legal       612x1008
    Statement   396x 612
    Executive   540x 720
    A3          842x1190
    A4          595x 842
    A5          420x 595
    B4          729x1032
    B5          516x 729
    Folio       612x 936
    Quarto      610x 780
    10x14       720x1008
.PP
For convenience you can specify the page size by media (e.g.
A4, Ledger, etc.).
.PP
To place a Postscript image with a given size on a given location on a
page, use -page +HOFFSET+VOFFSET -geometry WIDTHxHEIGHT (fill in
numbers). Note: this is only for generating Postscript, not Encapsulated
Postscript.
.PP
To position a GIF image, use -page +LEFT+TOP (e.g. -page +100+200).
.PP
The default page dimensions for a TEXT image is 612x792.
.TP
.B "-paint \fIradius\fP"
simulate an oil painting.

Each pixel is replaced by the most frequent color in a circular neighborhood
whose width is specified with \fIradius\fP.
.TP
.B "-pen \fIcolor\fP"
set the color of the font or opaque color.  See \fB-draw\fP for further details.

See \fBX(1)\fP for details about the color specification.
.TP
.B "-pointsize \fIvalue\fP"
pointsize of the Postscript font.
.TP
.B "-quality \fIvalue\fP"
JPEG quality setting.

Quality is 0 (worst) to 100 (best). The default is 75.
.TP
.B "-raise \fI<width>x<height>\fP"
lighten or darken image edges to create a 3-D effect.    See \fBX(1)\fP for
details about the geometry specification.

Use \fB-raise\fP to create a raised effect, otherwise use \fB+raise\fP.
.TP
.B "-region \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP"
apply options to a portion of the image.

By default, any command line options are applied to the entire image.  Use
\fB-region\fP to restrict operations to a particular area of the image.
.TP
.B "-roll \fI{\+-}<x offset>{\+-}<y offset>\fP"
roll an image vertically or horizontally.  See \fBX(1)\fP for details
about the geometry specification.

A negative \fIx offset\fP rolls the image left-to-right.  A negative
\fIy offset\fP rolls the image top-to-bottom.
.TP
.B "-rotate \fIdegrees{<}{>}\fP"
apply Paeth image rotation to the image.

Use \fB>\fP to rotate the image \fIonly\fP if its width exceeds the
height.  \fB<\fP rotates the image \fIonly\fP if its width is less than
the height.  For example, if you specify \fB-90>\fP and the image size
is 480x640, the image is not rotated by the specified angle.  However,
if the image is 640x480, it is rotated by -90 degrees.

Empty triangles left over from rotating the image are filled with
the color defined as \fBbordercolor\fP (class \fBborderColor\fP).
See \fBX(1)\fP for details.
.TP
.B "-sample \fIgeometry\fP"
scale image with pixel sampling.
.TP
.B "-scene \fIvalue\fP"
image scene number.
.TP
.B "-segment \fI<cluster threshold>x<smoothing threshold>\fP"
segment an image by analyzing the histograms of the color components and
identifying units that are homogeneous with the fuzzy c-means technique.

Specify \fIcluster threshold\fP as the number of pixels in each cluster must
exceed the the cluster threshold to be considered valid.  \fISmoothing
threshold\fP eliminates noise in the second derivative of the
histogram.  As the value is increased, you can expect a smoother second
derivative.  The default is 1.5.  See \fBIMAGE SEGMENTATION\fB for
details.
.TP
.B "-shade \fI<azimuth>x<elevation>\fP"
shade the image using a distant light source.

Specify \fIazimuth\fP and \fIelevation\fP as the position of the light source.
Use \fB+shade\fP to return the shading results as a grayscale image.
.TP
.B "-sharpen \fIfactor\fP"
sharpen an image.  Specify \fIfactor\fP as the percent enhancement
(0.0 - 99.9%).
.TP
.B "-shear \fI<x degrees>x<y degrees>\fP"
shear the image along the X or Y axis by a positive or negative shear angle.

Shearing slides one edge of an image along the X or Y axis, creating a
parallelogram.  An X direction shear slides an edge along the X axis,
while a Y direction shear slides an edge along the Y axis.  The amount
of the shear is controlled by a shear angle.  For X direction shears,
\fIx degrees\fP is measured relative to the Y axis, and similarly, for
Y direction shears \fIy degrees\fP is measured relative to the X axis.

Empty triangles left over from shearing the image are filled with
the color defined as \fBbordercolor\fP (class \fBborderColor\fP).
See \fBX(1)\fP for details.
.TP
.B "-size \fI<width>{%}x<height>{%}+<offset>\fP"
width and height of the image.

Use this option to specify the width and height of raw images whose
dimensions are unknown such as \fBGRAY\fP, \fBRGB\fP, or \fBCMYK\fP.
In addition to width and height, use \fB-size\fP to skip any header
information in the image or tell the number of colors in a \fBMAP\fP
image file, (e.g. -size 640x512+256).

For Photo CD images, choose from these sizes:

   192x128
   384x256
   768x512
  1536x1024
  3072x2048

Finally, use this option to choose a particular resolution layer of a JBIG
image (e.g. -size 1024x768).
.TP
.B "-solarize \fIfactor\fP"
negate all pixels above the threshold level.  Specify \fIfactor\fP as the
percent threshold of the intensity (0 - 99.9%).

This option produces a \fBsolarization\fB effect seen when exposing
a photographic film to light during the development process.
.TP
.B "-spread \fIamount\fP"
displace image pixels by a random amount.

\fIAmount\fP defines the size of the neighborhood around each pixel to
choose a candidate pixel to swap.
.TP
.B "-swirl \fIdegrees\fP"
swirl image pixels about the center.
 
\fIDegrees\fP defines the tightness of the swirl.
.TP
.B "-texture \fIfilename\fP"
name of texture to tile onto the image background.
.TP
.B "-threshold \fIvalue\fP"
threshold the image.

Create a bi-level image such that any pixel intensity that
is equal or exceeds the threshold is reassigned the maximum intensity otherwise
the minimum intensity.
.TP
.B "-transparency \fIcolor\fP"
make this color transparent within the image.
.TP
.B "-treedepth \fIvalue\fP"
Normally, this integer value is zero or one.  A zero or one tells
\fBconvert\fP to choose a optimal tree depth for the color reduction
algorithm.

An optimal depth generally allows the best representation of the source
image with the fastest computational speed and the least amount of
memory.  However, the default depth is inappropriate for some images.
To assure the best representation, try values between 2 and 8 for this
parameter.  Refer to \fBquantize(9)\fP for more details.

The \fB-colors\fP option is required for this option to take effect.
.TP
.B "-undercolor \fI<undercolor factor>x<black-generation factor>\fP"
control undercolor removal and black generation on CMYK images.

This option enables you to perform undercolor removal and black
generation on CMYK images-- images to be printed on a four-color
printing system. You can control how much cyan, magenta, and yellow
to remove from your image and how much black to add to it.
The standard undercolor removal is \fB1.0x1.0\fP.  You'll
frequently get better results, though, if the percentage of black you
add to your image is slightly higher than the percentage of C, M, and Y
you remove from it.  For example you might try \fB0.5x0.7\fP.
.TP
.B -verbose
print detailed information about the image.

This information is printed: image scene number;  image name;  converted
image name;  image size;  the image class (\fIDirectClass\fP or
\fIPseudoClass\fP);  the total number of unique colors;  and the number
of seconds to read and transform the image.
.PP
Options are processed in command line order.
Any option you specify on the command line remains in effect until it is
explicitly changed by specifying the option again with a different effect.
.PP
Change '-' to '+' in any option above to reverse its effect.  For
example, specify \fB+matte\fP to store the image without its matte channel.
.PP
By default, the image format is determined by its magic number. To
specify a particular image format, precede the filename with an image
format name and a colon (i.e. ps:image) or specify the image type as
the filename suffix (i.e. image.ps).  See \fBDESCRIPTION\fP for a list
of valid formats.
.PP
When you specify \fBX\fP as your image type, the filename has special
meaning.  It specifies an X window by id, name, or \fBroot\fP.  If no
filename is specified, the window is selected by clicking the mouse in
the desired window.
.PP
Specify \fIinput_file\fP as \fI-\fP for standard input,
\fIoutput_file\fP as \fI-\fP for standard output.  If \fIinput_file\fP
has the extension \fB.Z\fP or \fB.gz\fP, the file is uncompressed with
\fBuncompress\fP or \fBgunzip\fP respectively.  If \fIoutput_file\fP
has the extension \fB.Z\fP or \fB.gz\fP, the file size is compressed
using with \fBcompress\fP or \fBgzip\fP respectively.  Finally, precede
the image file name with \fI|\fP to pipe to or from a system command.
.PP
Use an optional index enclosed in brackets after a file name to specify
a desired subimage of a multi-resolution image format like Photo CD
(e.g. img0001.pcd[4]) or a range for MPEG images (e.g. video.mpg[50-75]).
A subimage specification can be disjoint (e.g. image.tiff[2,4,7]).
For raw images, specify a subimage with a geometry (e.g. -size 640x512
image.rgb[320x256+50+50]).
.PP
Single images are written with the filename you specify.  However,
multi-part images (e.g. a multi-page Postscript document with \fB+adjoin\fP
specified) are written with the filename followed by a period (\fB.\fP) and
the scene number.  You can change this behavior by embedding a \fBprintf\fP
format specification in the file name.  For example,

.nf
    image%02d.miff
.fi

converts files image00.miff, image01.miff, etc.
.SH IMAGE SEGMENTATION
Use \fB-segment\fP to segment an image by analyzing the histograms of the color
components and identifying units that are homogeneous with the fuzzy c-means
technique.  The scale-space filter analyzes the histograms of the three
color components of the image and identifies a set of classes.  The
extents of each class is used to coarsely segment the image with
thresholding.  The color associated with each class is determined by
the mean color of all pixels within the extents of a particular class.
Finally, any unclassified pixels are assigned to the closest class with
the fuzzy c-means technique.
.PP
The fuzzy c-Means algorithm can be summarized as follows:
.RS
.LP
o Build a histogram, one for each color component of the image.
.LP
o For each histogram, successively apply the scale-space filter and
build an interval tree of zero crossings in the second derivative at
each scale.  Analyze this scale-space ``fingerprint'' to determine
which peaks or valleys in the histogram are most predominant.
.LP
o The fingerprint defines intervals on the axis of the histogram.  Each
interval contains either a minima or a maxima in the original signal.
If each color component lies within the maxima interval, that pixel is
considered ``classified'' and is assigned an unique class number.
.LP
o Any pixel that fails to be classified in the above thresholding pass is
classified using the fuzzy c-Means technique.  It is assigned to one
of the classes discovered in the histogram analysis phase.
.RE
.PP
The fuzzy c-Means technique attempts to cluster a pixel by finding the local
minima of the generalized within group sum of squared error objective
function.  A pixel is assigned to the closest class of which the fuzzy
membership has a maximum value.

For additional information see
.IP
Young Won Lim, Sang Uk Lee, "On The Color Image Segmentation Algorithm Based
on the Thresholding and the Fuzzy c-Means Techniques", Pattern Recognition,
Volume 23, Number 9, pages 935-952, 1990.
.SH ENVIRONMENT
.PP
.TP
.B DISPLAY
To get the default host, display number, and screen.
.SH SEE ALSO
.B
display(1), animate(1), import(1), montage(1), mogrify(1),
combine(1), xtp(1)
.SH COPYRIGHT
Copyright 1997 E. I. du Pont de Nemours and Company
.PP
Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of E. I. du Pont de Nemours
and Company not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.  E. I. du Pont de Nemours and Company makes no representations
about the suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
.PP
E. I. du Pont de Nemours and Company disclaims all warranties with regard
to this software, including all implied warranties of merchantability
and fitness, in no event shall E. I. du Pont de Nemours and Company be
liable for any special, indirect or consequential damages or any
damages whatsoever resulting from loss of use, data or profits, whether
in an action of contract, negligence or other tortious action, arising
out of or in connection with the use or performance of this software.
.SH AUTHORS
John Cristy, E.I. du Pont De Nemours and Company Incorporated

