;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.9/Ieee/fixnum.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 10:06:37 1995                          */
;*    Last change :  Mon Apr  8 15:46:59 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.5. Numbers (page 18, r4) The `fixnum' functions                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r4_numbers_6_5_fixnum
   
   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool       c-fixnum?     (obj)         "INTEGERP")
	    (macro bool       c-elong?      (obj)         "ELONGP")
	    (macro bool       c-llong?      (obj)         "LLONGP")
	    (infix macro bool c-=fx         (long long)   "==")
	    (infix macro bool c-<fx         (long long)   "<")
	    (infix macro bool c-<=fx        (long long)   "<=")
	    (infix macro bool c->fx         (long long)   ">")
	    (infix macro bool c->=fx        (long long)   ">=")
	    (macro bool       c-even?       (long)        "EVENP_FX")
	    (macro bool       c-odd?        (long)        "ODDP_FX")
	    (infix macro long c-+fx         (long long)   "+")
	    (infix macro long c--fx         (long long)   "-")
	    (infix macro long c-*fx         (long long)   "*")
	    (infix macro long c-/fx         (long long)   "/")
	    (macro long       c-negfx       (long)        "NEG")
	    (infix macro long c-quotient    (long long)   "/")
	    (infix macro long c-remainder   (long long)   "%")
	    (string           c-int->string (long long)   "integer_to_string")
	    (macro long       strtol   (string long long) "strtol"))

   (export  (inline integer?::bool        ::obj)
	    (inline fixnum?::bool         ::obj)
	    (inline elong?::bool          ::obj)
	    (inline llong?::bool          ::obj)
	    (inline make-elong::belong    ::long)
	    (inline =fx::bool             ::long ::long)
	    (inline >fx::bool             ::long ::long)
	    (inline >=fx::bool            ::long ::long)
	    (inline <fx::bool             ::long ::long)
	    (inline <=fx::bool            ::long ::long)
	    (inline zerofx?::bool         ::long)
	    (inline positivefx?::bool     ::long)
	    (inline negativefx?::bool     ::long)
	    (inline odd?::bool            ::long)
	    (inline even?::bool           ::long)
	    (maxfx::long                  ::long . pair)
	    (minfx::long                  ::long . pair)
	    (inline +fx::long             ::long ::long)
	    (inline -fx::long             ::long ::long)
	    (inline *fx::long             ::long ::long)
	    (inline /fx::long             ::long ::long)
	    (inline negfx::long           ::long)
	    (inline absfx::long           ::long)
	    (inline quotient::long        ::long ::long)
	    (inline remainder::long       ::long ::long)
	    (modulo::long                 ::long ::long)
	    (gcd::long                    . pair)
	    (lcm::long                    . pair)
	    (integer->string::string      ::long . pair)
	    (string->integer::long        ::string . pair)
	    (string->elong::belong        ::string . pair)
	    (string->llong::bllong        ::string . pair))

   (pragma  (fixnum? _no_side_effect_ (_type-checker_ bint))
	    (c-fixnum? _no_side_effect_ (_type-checker_ bint))
	    (c-elong? _no_side_effect_ (_type-checker_ belong))
	    (c-llong? _no_side_effect_ (_type-checker_ bllong))
	    (integer? _no_side_effect_)
	    (c-=fx _no_side_effect_)
	    (c->fx _no_side_effect_)
	    (c->=fx _no_side_effect_)
	    (c-<fx _no_side_effect_)
	    (c-<=fx _no_side_effect_)
	    (c-odd? _no_side_effect_)
	    (c-even? _no_side_effect_)
	    (c-+fx _no_side_effect_)
	    (c--fx _no_side_effect_)
	    (c-*fx _no_side_effect_)
	    (c-/fx _no_side_effect_)
	    (c-negfx _no_side_effect_)))

;*---------------------------------------------------------------------*/
;*    integer? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (integer? obj)
   (c-fixnum? obj))

;*---------------------------------------------------------------------*/
;*    fixnum? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (fixnum? obj)
   (c-fixnum? obj))

;*---------------------------------------------------------------------*/
;*    elong? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (elong? obj)
   (c-elong? obj))

;*---------------------------------------------------------------------*/
;*    llong? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (llong? obj)
   (c-llong? obj))

;*---------------------------------------------------------------------*/
;*    make-elong ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (make-elong long)
   (long->belong long))

;*---------------------------------------------------------------------*/
;*    =fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (=fx n1 n2)
   (c-=fx n1 n2))

;*---------------------------------------------------------------------*/
;*    <fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (<fx n1 n2)
   (c-<fx n1 n2))

;*---------------------------------------------------------------------*/
;*    >fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (>fx n1 n2)
   (c->fx n1 n2))

;*---------------------------------------------------------------------*/
;*    <=fx ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (<=fx n1 n2)
   (c-<=fx n1 n2))

;*---------------------------------------------------------------------*/
;*    >=fx ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (>=fx n1 n2)
   (c->=fx n1 n2))

;*---------------------------------------------------------------------*/
;*    zerofx? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (zerofx? n)
   (=fx n 0))

;*---------------------------------------------------------------------*/
;*    positivefx?  ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (positivefx? n)
   (>fx n 0))

;*---------------------------------------------------------------------*/
;*    negativefx? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (negativefx? n)
   (<fx n 0))

;*---------------------------------------------------------------------*/
;*    odd? ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (odd? x)
   (c-odd? x))

;*---------------------------------------------------------------------*/
;*    even? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (even? x)
   (c-even? x))

;*---------------------------------------------------------------------*/
;*    maxfx ...                                                        */
;*---------------------------------------------------------------------*/
(define (maxfx n1 . nn)
   (let loop ((max n1)
	      (nn  nn))
      (if (null? nn)
	  max
	  (if (>fx (car nn) max)
	      (loop (car nn) (cdr nn))
	      (loop max (cdr nn))))))

;*---------------------------------------------------------------------*/
;*    minfx ...                                                        */
;*---------------------------------------------------------------------*/
(define (minfx n1 . nn)
   (let loop ((min n1)
	      (nn  nn))
      (if (null? nn)
	  min
	  (if (<fx (car nn) min)
	      (loop (car nn) (cdr nn))
	      (loop min (cdr nn))))))

;*---------------------------------------------------------------------*/
;*    +fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (+fx z1 z2)
   (c-+fx z1 z2))

;*---------------------------------------------------------------------*/
;*    -fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (-fx z1 z2)
   (c--fx z1 z2))

;*---------------------------------------------------------------------*/
;*    *fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (*fx z1 z2)
   (c-*fx z1 z2))

;*---------------------------------------------------------------------*/
;*    /fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (/fx z1 z2)
   (c-/fx z1 z2))

;*---------------------------------------------------------------------*/
;*    negfx ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (negfx n1)
   (c-negfx n1))

;*---------------------------------------------------------------------*/
;*    absfx ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (absfx n)
   (if (<fx n 0)
       (negfx n)
       n))

;*---------------------------------------------------------------------*/
;*    quotient ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (quotient n1 n2)
   (c-quotient n1 n2))

;*---------------------------------------------------------------------*/
;*    remainder ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (remainder n1 n2)
   (c-remainder n1 n2))

;*---------------------------------------------------------------------*/
;*    modulo ...                                                       */
;*---------------------------------------------------------------------*/
(define (modulo x y)
   (let ((r (remainder x y)))
      (if (zerofx? r)
	  r
	  (if (positivefx? y)
	      (if (positivefx? r) r (+fx y r))
	      (if (negativefx? r) r (+fx y r))))))

;*---------------------------------------------------------------------*/
;*    gcd ...                                                          */
;*---------------------------------------------------------------------*/
(define (gcd . x)
    (define (gcd2 m n)
       (if (zerofx? n)
	   m
	   (let ((r (remainder m n)))
	      (if (=fx r 0)
		  n
		  (gcd2 n r)))))
    (case (length x)
       ((0) 0)
       ((1) (absfx (car x)))
       (else
	(let loop ((result (gcd2 (absfx (car x)) (absfx (cadr x))))
			(left (cddr x)))
		(if (pair? left)
		    (loop (gcd2 result (absfx (car left))) (cdr left))
		    result)))))

;*---------------------------------------------------------------------*/
;*    lcm ...                                                          */
;*---------------------------------------------------------------------*/
(define (lcm . x)
   (define (lcm2 m n)
      (let ((m (absfx m)) (n (absfx n)))
	 (cond ((=fx m n) m)
	       ((=fx (remainder m n) 0) m)
	       ((=fx (remainder n m) 0) n)
	       (else (*fx (/fx m (gcd m n)) n)))))
   (case (length x)
      ((0) 1)
      ((1) (absfx (car x)))
      (else (let loop ((result (lcm2 (car x) (cadr x))) (left (cddr x)))
	       (if (pair? left)
		   (loop (lcm2 result (car left)) (cdr left))
		   result)))))

;*---------------------------------------------------------------------*/
;*    integer->string ...                                              */
;*---------------------------------------------------------------------*/
(define (integer->string x . radix)
   (if (null? radix)
       (set! radix 10)
       (set! radix (car radix)))
   (case radix
      ((2 8 10 16)
       (c-int->string x radix))
      (else
       (error "integer->string" "Illegal radix" radix))))

;*---------------------------------------------------------------------*/
;*    string->integer ...                                              */
;*---------------------------------------------------------------------*/
(define (string->integer string . radix)
   (if (null? radix)
       (set! radix 10)
       (set! radix (car radix)))
   (strtol string 0 radix))

;*---------------------------------------------------------------------*/
;*    string->elong ...                                                */
;*---------------------------------------------------------------------*/
(define (string->elong string . radix)
   (if (pair? radix)
       (long->belong (string->integer string (car radix)))
       (long->belong (string->integer string))))

;*---------------------------------------------------------------------*/
;*    string->llong ...                                                */
;*---------------------------------------------------------------------*/
(define (string->llong string . radix)
   (if (pair? radix)
       (llong->bllong (string->integer string (car radix)))
       (llong->bllong (string->integer string))))
