;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Ieee/boolean.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 08:34:45 1995                          */
;*    Last change :  Mon Jul 17 11:26:25 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.1. Booleans (page 13, r4)                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r4_booleans_6_1
   
   (use     (__type                    "Llib/type.scm")
	    (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    
	    (__evenv                   "Eval/evenv.scm"))
   
   (foreign (macro bool c-boolean? (obj)  "BOOLEANP")
	    (macro bbool btrue            "BTRUE")
	    (macro bbool bfalse           "BFALSE"))
   
   (export  (inline not::bool      ::obj)
	    (inline boolean?::bool ::obj))
   
   (pragma  (not _no_side_effect_)
	    (c-boolean? _no_side_effect_ (_type-checker_ bbool))))

;*---------------------------------------------------------------------*/
;*    not ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (not obj)
   (if obj #f #t))

;*---------------------------------------------------------------------*/
;*    boolean? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (boolean? obj)
   (c-boolean? obj))
   
