;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Eval/progn.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 10:07:31 1994                          */
;*    Last change :  Wed Nov  1 14:24:58 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La normalisation des formes `begin'                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __progn
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__unix                    "Llib/unix.scm")
	    
	    (__reader                  "Read/reader.scm")
	    
	    (__rgc                     "Rgc/runtime.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm"))

   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))
   
   (export  (normalize-progn <expression>)
	    (replace! p1 p2)))

;*---------------------------------------------------------------------*/
;*    normalize-progn ...                                              */
;*    sexp --> sexp                                                    */
;*    -------------------------------------------------------------    */
;*    Cette fonction doit etre utilisee pour normalise du code         */
;*    utilisateur tel qu'il est lu par le lecteur.                     */
;*---------------------------------------------------------------------*/
(define (normalize-progn body)
   (cond
      ((not (pair? body))
       `(begin ,body))
      (else
       (let ((res `(begin ,@(let loop ((body (if (eq? (car body) 'begin)
						 (cdr body)
						 body)))
			       (if (null? body)
				   '()
				   (let ((expr (car body)))
				      (if (and (pair? expr)
					       (eq? (car expr) 'begin))
					  (append (cdr expr) (loop (cdr body)))
					  (cons expr (loop (cdr body))))))))))
	  (replace! body res)))))

;*---------------------------------------------------------------------*/
;*    replace! ...                                                     */
;*---------------------------------------------------------------------*/
(define (replace! p1 p2)
   (if (and (pair? p1) (pair? p2))
       (begin
	  (set-car! p1 (car p2))
	  (set-cdr! p1 (cdr p2))
	  p1)
       p2))

