;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/examples/Roman/roman.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 22 08:44:51 1992                          */
;*    Last change :  Mon May 10 08:06:57 1993  (serrano)               */
;*                                                                     */
;*    On lit et on effectue des additions sur les nombres romains      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module roman (main main))

;*---------------------------------------------------------------------*/
;*    romain->arabe ...                                                */
;*---------------------------------------------------------------------*/
(define (romain->arabe r)
   (define (chiffre.romain->arabe chiffre)
      (case chiffre
	 ((#\m #\M) 1000)
	 ((#\d #\D) 500)
	 ((#\c #\C) 100)
	 ((#\l #\L) 50)
	 ((#\x #\X) 10)
	 ((#\v #\V) 5)
	 ((#\i #\I) 1)
	 (else
	  (error "chiffre" "Illegal char" chiffre))))
   (let ((len (string-length r)))
      (let loop ((indice 0))
      (cond
	 ((= indice len)
	  0)
	 ((= indice (- len 1))
	  (chiffre.romain->arabe (string-ref r indice)))
	 (else
	  (let ((x (chiffre.romain->arabe (string-ref r indice)))
		(y (chiffre.romain->arabe (string-ref r (+ 1 indice)))))
	     (if (< x y)
		 (+ (- x) (loop (+ 1 indice)))
		 (+ x (loop (+ 1 indice))))))))))

;*---------------------------------------------------------------------*/
;*    grammaire-romaine ...                                            */
;*---------------------------------------------------------------------*/
(define grammaire-romaine
   (let ((par-open 0))
      (regular-grammar ((arabe  (>-< #\0 #\9))
			(romain (in #\i #\I #\v #\V #\x #\X #\l #\L
				    #\c #\C #\d #\D #\m #\M)))
	 ((+ (in #\space #\newline #\tab))
	  (ignore))
	 ((+ arabe)
	  (string->integer (the-string)))
	 ((+ romain)
	  (romain->arabe (the-string)))
	 ((#\()
	  (let ((open-key par-open))
	     (set! par-open (+ 1 par-open))
	     (context 'pair)
	     (let loop-pair ((walk (ignore))) 
		(cond
		   ((= open-key par-open)
		    '())
		   (else
		    (cons walk (loop-pair (ignore))))))))
	 ((#\))
	  (set! par-open (- par-open 1))
	  (if (< par-open 0)
	      (begin
		 (set! par-open 0)
		 (ignore))
	      #f))
	 ((in #\+ #\- #\* #\\)
	  (string->symbol (the-string)))
	 (else
	  (let ((char (the-failing-char)))
	     (if (eof-object? char)
		 char
		 (error "grammaire-romaine" "Illegal char" char)))))))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (let ((prompt ":-) "))
      (display prompt)
      (let loop ((exp (read/rp grammaire-romaine (current-input-port))))
	 (if (eof-object? exp)
	     'done
	     (begin
		(display* (eval exp) #\Newline prompt)
		(loop (read/rp grammaire-romaine (current-input-port))))))))
