;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Tvector/install.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 27 13:33:40 1995                          */
;*    Last change :  Wed Oct  4 16:39:09 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We install all the coercer and accessor for `tvector' types.     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tvector_install
   (include "Type/type.sch"
	    "Tvector/tvector.sch"
	    "Tools/trace.sch")
   (import  parse_cforeign
	    ast_pragma
	    type_env
	    type_coercion
	    tvector_declare
	    engine_param)
   (export  (install-tvector-accessors-and-coercers!)
	    (install-tvector-accessors tv)))

;*---------------------------------------------------------------------*/
;*    install-tvector-accessors-and-coercers! ...                      */
;*---------------------------------------------------------------------*/
(define (install-tvector-accessors-and-coercers!)
   (let loop ((tvectors (get-tvector-list))
	      (new-code '()))
      (if (null? tvectors)
	  (begin
	     (trace init
		    "-------------------------------------------"
		    #\Newline
		    "install-tvector-accessors-and-coercers!:"
		    #\Newline)
	     (for-each (lambda (x)
			  (trace init x #\Newline))
		       new-code)
	     (trace init #\Newline)
	     (cons (install-declare-tvector!) new-code))
	  (loop (cdr tvectors)
		(append (install-tvector-accessors (car tvectors))
			new-code)))))

;*---------------------------------------------------------------------*/
;*    install-tvector-accessors ...                                    */
;*    -------------------------------------------------------------    */
;*    For each `tvector' `tv' , we produce several inlines and         */
;*    several foreign. Here they are listed:                           */
;*    inline:                           foreign:                       */
;*       tv?                               c-tv-ref                    */
;*       tv-ref                            c-tv-set!                   */
;*       tv-set!                           c-allocate-tv               */
;*       make-tv                                                       */
;*       allocate-tv                                                   */
;*       tv-length                                                     */
;*       tv-obj-ref                                                    */
;*       tv-obj-set!                                                   */
;*       tv->vector                                                    */
;*       vector->tv                                                    */
;*---------------------------------------------------------------------*/
(define (install-tvector-accessors tv)
   (let* ((id         (type-id tv))
	  (info       (type-tinfo tv))
	  (obj        (find-type 'obj))
	  (item-id    (tvector-info-item-id (type-tinfo tv)))
	  (item-type  (find-type item-id))
	  (item-name  (type-name item-type))
	  (descr-id   (symbol-append id '-descriptor)))
      (define (make-descr)
	 (tvector-info-descr-set! info descr-id)
	 ;; we use an hack, the variable descri-id is initialized
	 ;; by the code emited in the function `install-declare-tvector!'.
	 ;; Once this code is executed the value of this variable must
	 ;; not change. That's why we defined it as itself (no code
	 ;; will be emited for this statement).
	 `(define ,(symbol-append descr-id '::obj) ,descr-id))
      (define (make-tv?)
	 `(define-inline (,(symbol-append id '?::bool) o::obj)
	     (if (tvector? o)
		 (eq? (tvector-descr o) ,descr-id)
		 #f)))
      (define (make-tv-ref)
	 (tvector-info-tv-ref-set! info (symbol-append id '-ref))
	 `(define-inline (,(symbol-append id '-ref:: item-id)
			  ,(symbol-append 'tv:: id)
			  o::long)
	     ,(if *unsafe-range*
		  `(,(symbol-append 'c- id '-ref)
		    (pragma ,item-name)
		    tv
		    o)
		  `(if (vector-bound-check? o (tvector-length tv))
		       (,(symbol-append 'c- id '-ref)
			(pragma ,item-name)
			tv
			o)
		       (begin
			  (failure ,(string-append (symbol->string id) "-ref")
				   "Illegal offset"
				   o)
			  ;; we return the first element of the tvector
			  ;; otherwise, the type checking will refuse
			  ;; this function.
			  (,(symbol-append id '-ref) tv 0))))))
      (define (make-tv-set!)
	 (tvector-info-tv-set!-set! info (symbol-append id '-set!))
	 `(define-inline (,(symbol-append id '-set!::obj)
			  ,(symbol-append 'tv:: id)
 			  o::long
			  ,(symbol-append 'v:: item-id))
	     ,(if *unsafe-range*
		  `(,(symbol-append 'c- id '-set!)
		    (pragma ,item-name)
		    tv
		    o
		    v)
		  `(if (vector-bound-check? o (tvector-length tv))
		       (,(symbol-append 'c- id '-set!)
			(pragma ,item-name)
			tv
			o
			v)
		       (failure ,(string-append (symbol->string id) "-set!")
				"Illegal offset"
				o)))))
      (define (make-make-tv)
	 (tvector-info-make-set! info (symbol-append 'make- id))
	 `(define-inline (,(symbol-append 'make- id ':: id)
			  len::long
			  ,(symbol-append 'v:: item-id))
	     (let ((tv (,(symbol-append 'allocate- id) len)))
		(labels ((loop (i::long)
			       (if (=fx i len)
				   tv
				   (let ((ni::long (+fx i 1)))
				      (,(symbol-append id '-set!) tv i v)
				      (loop ni)))))
		   (loop 0)))))
      (define (make-make-s-tv)
	 (tvector-info-make-s-set! info (symbol-append 'make-s- id))
	 `(define-inline (,(symbol-append 'make-s- id ':: id)
			  len::long
			  ,(symbol-append 'v:: item-id))
	     (let ((tv (,(symbol-append 'allocate-s- id) len)))
		(labels ((loop (i::long)
			       (if (=fx i len)
				   tv
				   (let ((ni::long (+fx i 1)))
				      (,(symbol-append id '-set!) tv i v)
				      (loop ni)))))
		   (loop 0)))))
      (define (make-allocate-tv)
	 (tvector-info-allocate-set! info (symbol-append 'allocate- id))
	 `(define-inline (,(symbol-append 'allocate- id ':: id)
			  len::long)
	     (,(symbol-append 'c-allocate- id ':: id)
	      (pragma ,item-name)
	      len
	      ,descr-id)))
      (define (make-allocate-s-tv)
	 (tvector-info-allocate-s-set! info (symbol-append 'allocate-s- id))
	 `(define-inline (,(symbol-append 'allocate-s- id ':: id)
			  len::long)
	     (,(symbol-append 'c-allocate-s- id ':: id)
	      (pragma ,item-name)
	      len
	      ,descr-id)))
      (define (make-tv-obj-ref)
	 (let ((coercer (find-coercer item-type obj)))
	    (if (not coercer)
		(begin
		   (tvector-info-ref-set! info #f)
		   #f)
		(let ((name (gensym)))
		   (tvector-info-ref-set! info name)
		   `(define (,(symbol-append name '::obj)
			     tvect::obj
			     o::obj)
		       (,(symbol-append id '-ref) tvect o))))))
      (define (make-tv->vector)
	 `(define-inline (,(symbol-append id '->vector::vector)
			  ,(symbol-append id ':: id))
	     (tvector->vector ,id)))
      (define (make-vector->tv)
	 `(define-inline (,(symbol-append 'vector-> id ':: id) v::vector)
	     (vector->tvector ',id v)))
      (define (make-tv-obj-set!)
	 (let ((coercer (find-coercer obj item-type)))
	    (if (not coercer)
		(begin
		   (tvector-info-set!-set! info #f)
		   #f)
		(let ((name (gensym)))
		   (tvector-info-set!-set! info name)
		   `(define (,(symbol-append name '::obj)
			     tvect::obj
			     o::obj
			     item::obj)
		       (,(symbol-append id '-set!) tvect o item))))))
      (define (make-tv-length)
	 `(define-inline (,(symbol-append id '-length::long)
			  ,(symbol-append 'o:: id))
	     (tvector-length o)))
      (define (make-c-tv-ref)
	 `(macro ,item-id
	     ,(symbol-append 'c- (symbol-append id '-ref))
	     (obj ,id long)
	     "TVECTOR_REF"))
      (define (make-c-tv-set!)
	 `(macro obj
	     ,(symbol-append 'c- (symbol-append id '-set!))
	     (obj ,id long ,item-id)
	     "TVECTOR_SET"))
      (define (make-c-allocate-tv)
	 `(macro ,id
	     ,(symbol-append 'c-allocate- id ':: id)
	     (obj long obj)
	     "ALLOCATE_TVECTOR"))
      (define (make-c-allocate-s-tv)
	 `(macro ,id
	     ,(symbol-append 'c-allocate-s- id ':: id)
	     (obj long obj)
	     "ALLOCATE_S_TVECTOR"))
      (parse-c-foreign (list (make-c-tv-ref)
			     (make-c-tv-set!)
			     (make-c-allocate-tv)
			     (make-c-allocate-s-tv))
		       'export)
      (let* ((descr         (make-descr))
	     (tv?           (make-tv?))
	     (tv-ref        (make-tv-ref))
	     (tv-set!       (make-tv-set!))
	     (make-tv       (make-make-tv))
	     (allocate-tv   (make-allocate-tv))
	     (make-s-tv     (make-make-s-tv))
	     (allocate-s-tv (make-allocate-s-tv))
	     (obj-ref       (make-tv-obj-ref))
	     (obj-set!      (make-tv-obj-set!))
	     (tv-len        (make-tv-length))
	     (tv->vector    (make-tv->vector))
	     (vector->tv    (make-vector->tv))
	     (def           (list descr tv? tv-len tv-ref
				  tv-set! make-tv allocate-tv
				  make-s-tv allocate-s-tv
				  tv->vector vector->tv))
	     (def           (if obj-ref
				(cons obj-ref def)
				def))
	     (def           (if obj-set!
				(cons obj-set! def)
				def)))
	 def)))

;*---------------------------------------------------------------------*/
;*    install-declare-tvector! ...                                     */
;*---------------------------------------------------------------------*/
(define (install-declare-tvector!)
   (let loop ((tvectors (get-tvector-list))
	      (ast      '(#unspecified)))
      (if (null? tvectors)
	  `(define (tvectors-declarations!)
	      (begin ,@ast))
	  (let* ((tvec      (car tvectors))
		 (info      (type-tinfo tvec)))
	     (loop (cdr tvectors)
		   (cons `(set! ,(tvector-info-descr info)
				(declare-tvector!
				 ,(symbol->string (type-id tvec))
				 ,(tvector-info-allocate info)
				 ,(tvector-info-ref info)
				 ,(tvector-info-set! info)))
			 ast))))))



