;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Tvector/declare.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 27 11:21:53 1995                          */
;*    Last change :  Wed Oct  4 16:39:00 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The declaration of `tvector' types.                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tvector_declare
   (include "Type/type.sch"
	    "Tvector/tvector.sch")
   (import  type_env
	    type_cache
	    parse_type
	    tools_error)
   (export  (declare-tvector-type! <symbol> <symbol> <exp>)
	    (get-tvector-list)))

;*---------------------------------------------------------------------*/
;*    declare-tvector-type! ...                                        */
;*---------------------------------------------------------------------*/
(define (declare-tvector-type! tvect-type-id item-type-id exp)
   (let ((obj (find-type 'obj)))
      (if (not (type? obj))
	  (user-error "declare-tvector-type!"
		      "Unable to find `obj' type"
		      exp)
	  (let ((t (declare-subtype! tvect-type-id
				     (type-name obj)
				     (list 'obj)
				     'bigloo
				     exp))
		(i (make-tvector-info)))
	     (tvector-info-item-id-set! i item-type-id)
	     (type-tinfo-set! t i)
	     (add-tvector! t)
	     ;; we have declared the type, we add the coercion
	     (parse-type (list
			  `(coerce ,tvect-type-id tvector () ())
			  `(coerce tvector ,tvect-type-id () ())))
	     t))))

;*---------------------------------------------------------------------*/
;*    *tvector-list* ...                                               */
;*---------------------------------------------------------------------*/
(define *tvector-list* '())

;*---------------------------------------------------------------------*/
;*    add-tvector! ...                                                 */
;*---------------------------------------------------------------------*/
(define (add-tvector! t)
   (set! *tvector-list* (cons t *tvector-list*)))

;*---------------------------------------------------------------------*/
;*    get-tvector-list ...                                             */
;*---------------------------------------------------------------------*/
(define (get-tvector-list)
   *tvector-list*)
