;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Reduce/letb.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb  5 17:33:09 1996                          */
;*    Last change :  Tue Feb  6 17:08:54 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `useles' let-var binding construction removal.               */
;*    -------------------------------------------------------------    */
;*    This removal can be done now since the coercion have been        */
;*    introduced. They can be removed before.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module reduce_letb
   (include "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_speek
	    engine_param
	    ast_dump
	    ast_env
	    ast_global
	    ast_pragma
	    ast_typeof
	    type_env
	    type_cache
	    effect_effect)
   (export  (reduce-let-var-bindings! globals)))

;*---------------------------------------------------------------------*/
;*    reduce-let-var-bindings! ...                                     */
;*---------------------------------------------------------------------*/
(define (reduce-let-var-bindings! globals)
   (verbose 2 "        let bindings" #\Newline)
   (for-each (lambda (global)
		(let* ((fun (global-value global))
		       (ast (function-body fun))) 
		   (function-body-set! fun (ast-letb! ast))
		   #unspecified))
	     globals))
   
;*---------------------------------------------------------------------*/
;*    ast-letb! ...                                                    */
;*---------------------------------------------------------------------*/
(define (ast-letb! ast)
   (ast-case ast
      ((atom)
       ast)
      ((kwote)
       ast)
      ((var)
       (if (and (local? (var-variable ast))
		(ast? (local-fast-alpha (var-variable ast))))
	   (local-fast-alpha (var-variable ast))
	   ast))
      ((make-box)
       (make-box-value-set! ast (ast-letb! (make-box-value ast)))
       ast)
      ((box-ref)
       (box-ref-var-set! ast (ast-letb! (box-ref-var ast)))
       ast)
      ((box-set!)
       (box-set!-value-set! ast (ast-letb! (box-set!-value ast)))
       ast)
      ((prag-ma)
       (let loop ((exp (prag-ma-values ast)))
	  (if (null? exp)
	      ast
	      (begin
		 (set-car! exp (ast-letb! (car exp)))
		 (loop (cdr exp))))))
      ((fail)
       (fail-proc-set! ast (ast-letb! (fail-proc ast)))
       (fail-msg-set!  ast (ast-letb! (fail-msg ast)))
       (fail-obj-set!  ast (ast-letb! (fail-obj ast)))
       ast)
      ((sequence)
       (let loop ((exp (sequence-exp ast)))
	  (if (null? exp)
	      ast
	      (begin
		 (set-car! exp (ast-letb! (car exp)))
		 (loop (cdr exp))))))
      ((conditional)
       (conditional-test-set! ast (ast-letb! (conditional-test ast)))
       (conditional-then-set! ast (ast-letb! (conditional-then ast)))
       (conditional-else-set! ast (ast-letb! (conditional-else ast)))
       ast)
      ((switch)
       (switch-test-set! ast (ast-letb! (switch-test ast)))
       (for-each (lambda (clause)
		    (set-cdr! clause (ast-letb! (cdr clause))))
		 (switch-clauses ast))
       ast)
      ((setq)
       (let ((var (var-variable (setq-var ast)))
	     (val (setq-val ast)))
	  (setq-val-set! ast (ast-letb! val)))
       ast)
      ((let-var)
       (ast-letb-var! ast))
      ((let-fun)
       (for-each (lambda (local)
		    (let ((fun (local-value local)))
		       (function-body-set! fun
					   (ast-letb! (function-body fun)))))
		 (let-fun-locals ast))
       (let-fun-body-set! ast (ast-letb! (let-fun-body ast)))
       ast)
      ((set-ex-it)
       (set-ex-it-body-set! ast (ast-letb! (set-ex-it-body ast)))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (ast-letb! (jump-ex-it-exit ast)))
       (jump-ex-it-value-set! ast (ast-letb! (jump-ex-it-value ast)))
       ast)
      ((fun)
       (fun-value-set! ast (ast-letb! (fun-value ast)))
       ast)
      ((app-ly)
       (app-ly-fun-set! ast (ast-letb! (app-ly-fun ast)))
       (app-ly-value-set! ast (ast-letb! (app-ly-value ast)))
       ast)
      ((funcall)
       (funcall-fun-set! ast (ast-letb! (funcall-fun ast)))
       (let loop ((actuals (funcall-actuals ast)))
	  (if (null? actuals)
	      ast
	      (begin
		 (set-car! actuals (ast-letb! (car actuals)))
		 (loop (cdr actuals))))))
       ((app)
	(app-fun-set! ast (ast-letb! (app-fun ast)))
	(let loop ((actuals (app-actuals ast)))
	   (if (null? actuals)
	       ast
	       (begin
		  (set-car! actuals (ast-letb! (car actuals)))
		  (loop (cdr actuals))))))))

;*---------------------------------------------------------------------*/
;*    ast-letb-var! ...                                                */
;*---------------------------------------------------------------------*/
(define (ast-letb-var! ast)
   (trace reduce "letb: " (shape ast) #\Newline)
   (let* ((body      (let-var-body ast))
	  (body-sef? (side-effect-free? body)))
      (trace reduce
	     "letb: " (shape ast) #\Newline
	     "   body side effect free: " body-sef? #\Newline)
      (let loop ((obindings (let-var-bindings ast))
		 (nbindings '()))
	 (if (null? obindings)
	     (let ((new-body (ast-letb! body)))
		(if (and (null? nbindings) (let-var-removable? ast))
		    new-body
		    (begin
		       (let-var-bindings-set! ast (reverse! nbindings))
		       (let-var-body-set!     ast new-body)
		       ast)))
	     (let* ((bin (car obindings))
		    (var (car bin))
		    (val (ast-letb! (cdr bin))))
		(if (or (not body-sef?) (require-binding? var val))
		    (begin
		       (local-fast-alpha-set! var #f)
		       (set-cdr! bin val)
		       (loop (cdr obindings) (cons bin nbindings)))
		    (begin
		       (local-fast-alpha-set! var val)
		       (loop (cdr obindings) nbindings))))))))

;*---------------------------------------------------------------------*/
;*    require-binding? ...                                             */
;*---------------------------------------------------------------------*/
(define (require-binding? var val)
   (trace reduce "    require bindings(" (shape var) " " (shape val) "): ")
   (cond
      ((not (eq? (local-access var) 'read))
       (trace reduce "#t .1" #\Newline)
       #t)
      ((>fx (local-occurrence var) 1)
       (trace reduce "#t .2" #\Newline)
       #t)
      ((var? val)
       (trace reduce "#t .3" #\Newline)
       #t)
      ((not (side-effect-free? val))
       (trace reduce "#t .4" #\Newline)
       #t)
      (else
       (trace reduce "#f" #\Newline)
       #f)))
      
