;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Integrate/tools.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Mar 14 11:57:57 1995                          */
;*    Last change :  Tue Apr 25 17:36:25 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Some tools for the integrate pass.                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_tools
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Integrate/integrate.sch")
   (export  (create-ivar)
	    (initialize-fun! <variable> <variable>>)))

;*---------------------------------------------------------------------*/
;*    create-ivar ...                                                  */
;*---------------------------------------------------------------------*/
(define (create-ivar)
   (ivar #unspecified    ;; f-mark
	 #unspecified    ;; u-mark
	 #f              ;; kaptured?
	 ))    

;*---------------------------------------------------------------------*/
;*    create-ifun ...                                                  */
;*---------------------------------------------------------------------*/
(define (create-ifun owner global?)
   (ifun owner           ;; owner 
	 #unspecified    ;; free  
	 '()             ;; bound
	 '()	         ;; cfrom 
	 '()	         ;; cto   
	 '()	         ;; K     
	 '()	         ;; K*    
	 #unspecified    ;; U     
	 '()	         ;; Cn    
	 '()	         ;; Ct    
	 '()	         ;; kont  
	 global?         ;; G?    
	 #unspecified    ;; L
	 '()             ;; Led
	 #unspecified    ;; istamp
	 #unspecified    ;; global
	 #unspecified    ;; kaptured
	 )) 

;*---------------------------------------------------------------------*/
;*    initialize-fun! ...                                              */
;*---------------------------------------------------------------------*/
(define (initialize-fun! fun owner)
   (variable-info-set! fun (create-ifun owner (global? fun)))
   (for-each (lambda (x)
		(local-info-set! x (create-ivar)))
	     (function-args (variable-value fun))))
