;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Eval/parse.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 09:21:36 1994                          */
;*    Last change :  Mon Jan 22 13:11:38 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We parse `eval' clauses.                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module eval_parse
   (include "Ast/ast.sch")
   (import  tools_error
	    ast_global
	    ast_env
	    parse_definition
	    engine_param
	    engine_engine
	    tools_shape)
   (export  (parse-eval clauses)
	    (get-eval-global-exported)))

;*---------------------------------------------------------------------*/
;*    parse-eval ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-eval clauses)
   (for-each (lambda (clause)
		(match-case clause
		   ((export-all)
		    (set! *eval?*    #t)
		    (set! *all-eval* #t))
		   ((export (and (? symbol?) ?var))
		    (set! *eval?* #t)
		    (remember-eval-exported! var '()))
		   ((export (@ (? symbol?) ?var) (? symbol?) ?module)
		    (set! *eval?* #t)
		    (remember-eval-exported! var module))
		   ((import (and (? symbol?) ?var))
		    (declare-global-variable! 'eval
					      (string->symbol "no matter")
					      'eval
					      (cdr (parse-definition
						    var))))
		   (else
		    (user-error "Parse error"
				"Illegal `eval clause'"
				clause))))
	     clauses))

;*---------------------------------------------------------------------*/
;*    *eval-exported* ...                                              */
;*---------------------------------------------------------------------*/
(define *eval-exported* '())

;*---------------------------------------------------------------------*/
;*    remember-eval-exported! ...                                      */
;*---------------------------------------------------------------------*/
(define (remember-eval-exported! var module)
   (set! *eval-exported* (cons (cons var module) *eval-exported*)))

;*---------------------------------------------------------------------*/
;*    *all-eval* ...                                                   */
;*---------------------------------------------------------------------*/
(define *all-eval* #f)

;*---------------------------------------------------------------------*/
;*    get-eval-global-exported ...                                     */
;*---------------------------------------------------------------------*/
(define (get-eval-global-exported)
   (if *all-eval*
       (let ((res '()))
	  (for-each-global!
	   (lambda (g)
	      (if (and (memq (global-import g) '(import static export))
		       (global-eval? g)
		       (or *lib-mode* (not (global-library? g))))
		  (set! res (cons g res)))))
	  res)
       (let loop ((eval-exported *eval-exported*)
		  (res           '()))
	  (if (null? eval-exported)
	      res
	      (let ((var.module (car eval-exported)))
		 (let ((g (if (null? (cdr var.module))
			      (find-global (car var.module))
			      (find-global (car var.module)
					   (cdr var.module)))))
		    (cond
		       ((not (global? g))
			(user-error "get-eval-global-exported"
				    "Unbound variable"
				    (car var.module)))
		       ((and (not *lib-mode*) (global-library? g))
			(loop (cdr eval-exported) res))
		       ((not (global-eval? g))
			(warning "get-eval-global-exported"
				 "This variable is not reachable from eval"
				 (shape g))
			(loop (cdr eval-exported) res))
		       (else
			(loop (cdr eval-exported) (cons g res))))))))))
