;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Engine/param.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct  3 12:44:17 1995                          */
;*    Last change :  Mon Apr  8 16:28:48 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Global control of the compiler                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_param
   (import  tools_module
	    ;; tools_date is a generated file and hence, it can't be
	    ;; set in the .afile file.
	    (tools_date "Tools/date.scm"))
   (export  *bigloo-name*
	    *bigloo-level*
	    *bigloo-cmd-name*  
	    *bigloo-args*
	    *rest-args*
	    *bigloo-author*    
	    *bigloo-email*     
	    *bigloo-date*
	    *bigloo-tmp*
	    *lib-mode*
	    *init-mode*
	    *max-c-token-length*
	    *verbose*
	    *unsafe-type*      
	    *unsafe-range*     
	    *unsafe-struct*    
	    *unsafe-arity*
	    *unsafe-version*
	    *optim*
	    *superlift?*
	    *heap->stack?*
	    *stack-alloc*
	    *max-stack-alloc-size*
	    *inlining?*
	    *genericity*
	    *shared-cnst?*
	    ;; -------------------------------------------------------------
	    ;; warning, any change about this variable name must be reported
	    ;; in the no-trace-no-check macro of Llib/error.scm file
	    *compiler-debug*            
	    ;; -------------------------------------------------------------
	    *c-debug*                   
	    *c-debug-option*            
	    *module-shape?*             
	    *key-shape?*
	    *type-shape?*
	    *pp-env-mode*      
	    *src*              
	    *tmp-dest*         
	    *dest*
	    *os*
	    *cc*               
	    *stdc*               
	    *cc-options*       
	    *rm-c-files*       
	    *ld-options*       
	    *strip*            
	    *bigloo-lib*
	    *bigloo-user-lib*
	    *lib-dir*
	    *bigloo-user-includes*
	    *include-foreign*  
	    *indent*
	    *indent-opt*
	    *access-file*      
	    *access-table*     
	    *o-files*          
	    *with-files*
	    *used-modules*
	    *used-library-modules*
	    *init-functions*   
	    *interpreter*      
	    *startup-file*     
	    *eval?*            
	    *call/cc?*
	    *full-tail-recursion?*
	    *garbage-collector*
	    *pass*             
	    *inline-level-max*
	    *heap-name*
	    *main*             
	    *module-name*
	    *module-clause*
	    *extend-entry*
	    *auto-mode*
	    *suffix*
	    (initialisation-name))
   (foreign (macro string prevent-string-cnst-allocation (string) ""))
   (eval    (export-all)))
     
;*---------------------------------------------------------------------*/
;*    Les auteurs et le nom du soft                                    */
;*---------------------------------------------------------------------*/
(define *bigloo-name*       "Bigloo (v1.8)")
(define *bigloo-level*      #\b)  ;; #f or a character
(define *bigloo-cmd-name*   'nothing-yet)
(define *bigloo-args*       'nothing-yet)
(define *rest-args*         '())
(define *bigloo-author*     "Manuel Serrano")
(define *bigloo-email*      "serrano@pa.dec.com")
(define *bigloo-date*       (bigloo-date))
(define *bigloo-tmp*        (let ((Venv (getenv "TMPDIR")))
			       (if (string? Venv)
				   Venv
				   "/tmp")))
   
;*---------------------------------------------------------------------*/
;*    Le bavardage ...                                                 */
;*---------------------------------------------------------------------*/
(define *verbose*           0)         ;; is the compiler verbose
(define *pp-env-mode*       'short)    ;; On trace en petit, par defaut

;*---------------------------------------------------------------------*/
;*    Les noms des differents fichiers                                 */
;*---------------------------------------------------------------------*/
(define *src*               #f)        ;; Le #t par default signifie que
(define *tmp-dest*          #f)        ;; si l'utilisateur ne precise pas
(define *dest*              #f)        ;; de fichier on lira sur la console.

;*---------------------------------------------------------------------*/
;*    La profondeur maximum des inlines                                */
;*---------------------------------------------------------------------*/
(define *inline-level-max*  4)

;*---------------------------------------------------------------------*/
;*    Le compilateur C et ses options                                  */
;*---------------------------------------------------------------------*/
(define *os*                   (prevent-string-cnst-allocation "unix"))
(define *cc*                   (prevent-string-cnst-allocation "gcc"))
(define *stdc*                 #f)
(define *cc-options*           "")
(define *rm-c-files*           #t)
(define *ld-options*           "")
(define *strip*                #f)
(define *bigloo-lib*           (list (prevent-string-cnst-allocation "-lm")
				     "-lbigloo"))
(define *bigloo-user-lib*      '())
(define *bigloo-user-includes* '())
(define *default-lib-dir*      (prevent-string-cnst-allocation "/udir/serrano/prgm/project/bigloo/lib/1.8"))
(define *lib-dir*              (let ((lib-env (getenv "BIGLOOLIB")))
				  (if (not (string? lib-env))
				      *default-lib-dir*
				      lib-env)))
(set!   *load-path*            (cons *lib-dir* *load-path*))
(define *include-foreign*      `("bigloo.h"))
(define *heap-name*            "bigloo.heap")
(define *indent*               (prevent-string-cnst-allocation "/usr/local/bin/indent"))
(define *indent-opt*           (prevent-string-cnst-allocation ""))
(define *compiler-debug*       0)
(define *c-debug*              #f)
(define *c-debug-option*       "-g")

;*---------------------------------------------------------------------*/
;*    Les fichier de link                                              */
;*---------------------------------------------------------------------*/
(define *access-file*          #f)    ;; fichier d'indirection
(define *access-table*         '())   ;; la table d'indirection
(define *o-files*              '())   ;; avec quels fichiers link-t-on ?
(define *with-files*           '())   ;; les modules pour faire l'application
(define *used-modules*         '())   ;; la liste des modules a utiliser
(define *used-library-modules* '())   ;; la liste des modules a utiliser
(define *init-functions*       '())   ;; la liste des fonctions d'init.
   
;*---------------------------------------------------------------------*/
;*    Des variables de controle sur `comment on doit compiler'         */
;*---------------------------------------------------------------------*/
(define *interpreter*          #f)  ;; compile-t-on ou interprete-t-on ?
(define *startup-file*         #f)  ;; le fichier `rc' de l'interprete
(define *eval?*                #f)
(define *call/cc?*             #f)
(define *full-tail-recursion?* #f)  ;; est-on proper-tail-recursive ?
(define *pass*                 'ld)
(define *garbage-collector*    'boehm)

;*---------------------------------------------------------------------*/
;*    Les modes de compilations                                        */
;*---------------------------------------------------------------------*/
(define *unsafe-type*               #f)
(define *unsafe-arity*              #f)
(define *unsafe-range*              #f)
(define *unsafe-struct*             #f)
(define *unsafe-version*            #f)
(define *module-shape?*             #f)
(define *key-shape?*                #f)
(define *type-shape?*               #f)
(define *optim*                     0)
(define *superlift?*                #f)
(define *heap->stack?*              #f)
(define *stack-alloc*              'ALLOCA)
(define *max-stack-alloc-size*      1000)
(define *inlining?*                 #t)
(define *genericity*                #t)
(define *shared-cnst?*              #f)
(define *lib-mode*                  #f)
(define *init-mode*                 'read)
(define *max-c-token-length*        1024)
 
;*---------------------------------------------------------------------*/
;*    Informations about the module being compiled                     */
;*---------------------------------------------------------------------*/
(define *module-name*       #f)
(define *module-clause*     #f)

;*---------------------------------------------------------------------*/
;*    Le point d'entree de la compilation                              */
;*---------------------------------------------------------------------*/
(define *main*              #f)

;*---------------------------------------------------------------------*/
;*    initialisation-name ...                                          */
;*---------------------------------------------------------------------*/
(define (initialisation-name)
   (module-init-name *module-name*))

;*---------------------------------------------------------------------*/
;*    *extend-entry* ...                                               */
;*---------------------------------------------------------------------*/
(define *extend-entry*      #f)

;*---------------------------------------------------------------------*/
;*    *suffix* ...                                                     */
;*    -------------------------------------------------------------    */
;*    The list of suffix recognize by the linker.                      */
;*---------------------------------------------------------------------*/
(define *suffix* '("scm"))

;*---------------------------------------------------------------------*/
;*    Les auto-modes (comme en emacs)                                  */
;*---------------------------------------------------------------------*/
(define *auto-mode*         '(("ml"  . "caml")
			      ("mli" . "caml")
			      ("oon" . "meroon")))
