;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cnst/ast.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb  6 14:08:40 1995                          */
;*    Last change :  Fri Mar 22 15:52:03 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The constant compilation (of the kwoted forms and                */
;*    `make-??-procedure' calls).                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cnst_ast
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Globalize/globalize.sch"
	    "Tvector/tvector.sch")
   (import  tools_shape
	    tools_speek
	    ast_sexp
	    ast_env
	    ast_global
	    ast_local
	    ast_dump
	    cnst_cache
	    cnst_alloc)
   (export (cnst       <ast>)
	   (cnst-quote <ast>)))

;*---------------------------------------------------------------------*/
;*    cnst ...                                                         */
;*---------------------------------------------------------------------*/
(define (cnst ast)
   (trace cnst "cnst: " (ast->sexp ast) #\Newline)
   (ast-case ast
      ((atom)
       ast)
      ((kwote)
       (cnst-quote ast))
      ((var)
       ast)
      ((fun)
       ast)
      ((prag-ma)
       (let loop ((values (prag-ma-values ast)))
	  (if (null? values)
	      ast
	      (begin
		 (set-car! values (cnst (car values)))
		 (loop (cdr values))))))
      ((fail)
       (fail-proc-set! ast (cnst (fail-proc ast)))
       (fail-msg-set! ast (cnst (fail-msg ast)))
       (fail-obj-set! ast (cnst (fail-obj ast)))
       ast)
      ((sequence)
       (let liip ((sexp (sequence-exp ast)))
	  (if (null? (cdr sexp))
	      (begin
		 (set-car! sexp (cnst (car sexp)))
		 ast)
	      (begin
		 (set-car! sexp (cnst (car sexp)))
		 (liip (cdr sexp))))))
      ((conditional)
       (conditional-test-set! ast (cnst (conditional-test ast)))
       (conditional-then-set! ast (cnst (conditional-then ast)))
       (conditional-else-set! ast (cnst (conditional-else ast)))
       ast)
      ((setq)
       (setq-val-set! ast (cnst (setq-val ast)))
       ast)
      ((let-var)
       (for-each (lambda (binding)
		    (set-cdr! binding (cnst (cdr binding))))
		 (let-var-bindings ast))
       (let-var-body-set! ast (cnst (let-var-body ast)))
       ast)
      ((let-fun)
       (for-each (lambda (local)
		    (let ((fun (local-value local)))
		       (function-body-set! fun (cnst (function-body fun)))))
		 (let-fun-locals ast))
       (let-fun-body-set! ast (cnst (let-fun-body ast)))
       ast)
      ((set-ex-it)
       (set-ex-it-body-set! ast (cnst (set-ex-it-body ast)))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (cnst (jump-ex-it-exit ast)))
       (jump-ex-it-value-set! ast (cnst (jump-ex-it-value ast)))
       ast)
      ((funcall)
       (funcall-fun-set! ast (cnst (funcall-fun ast)))
       (let liip ((asts (funcall-actuals ast)))
	  (if (null? asts)
	      ast
	      (begin
		 (set-car! asts (cnst (car asts)))
		 (liip (cdr asts))))))
      ((app-ly)
       (app-ly-fun-set! ast (cnst (app-ly-fun ast)))
       (app-ly-value-set! ast (cnst (app-ly-value ast)))
       ast)
      ((app)
       (cnst-app ast))
      ((make-box)
       (make-box-value-set! ast (cnst (make-box-value ast)))
       ast)
      ((box-ref)
       (box-ref-var-set! ast (cnst (box-ref-var ast)))
       ast)
      ((box-set!)
       (box-set!-var-set! ast (cnst (box-set!-var ast)))
       (box-set!-value-set! ast (cnst (box-set!-value ast)))
       ast)
      ((switch)
       (switch-test-set! ast (cnst (switch-test ast)))
       (for-each (lambda (clause)
		    (set-cdr! clause (cnst (cdr clause))))
		 (switch-clauses ast))
       ast)))

;*---------------------------------------------------------------------*/
;*    cnst-quote ...                                                   */
;*---------------------------------------------------------------------*/
(define (cnst-quote ast)
   (let ((value (kwote-value ast)))
      (cond
	 ((symbol? value)
	  (cnst-alloc-symbol value (ast-location ast)))
	 ((pair? value)
	  (cnst-alloc-list value (ast-location ast)))
	 ((vector? value)
	  (cnst-alloc-vector value (ast-location ast)))
	 ((string? value)
	  (cnst-alloc-string value (ast-location ast)))
	 ((a-tvector? value)
	  (cnst-alloc-tvector value (ast-location ast)))
	 ((or (char? value)
	      (integer? value)
	      (boolean? value)
	      (real? value)
	      (cnst? value))
	  (ast-atom (ast-location ast)
		    (ast-type ast)
		    (ast-info ast)
		    value))
	 (else
	  (internal-error "cnst-quote"
			  "Illegal expression"
			  (ast->sexp ast))))))

;*---------------------------------------------------------------------*/
;*    cnst-app ...                                                     */
;*---------------------------------------------------------------------*/
(define (cnst-app ast)
   ;; we first compile all the actuals
   (let loop ((actuals (app-actuals ast)))
      (if (null? actuals)
	  'done
	  (begin
	     (set-car! actuals (cnst (car actuals)))
	     (loop (cdr actuals)))))
   ;; then we make special cases depending on the called function
   (if (null? (app-actuals ast))
       ast
       (let ((fun    (var-variable (app-fun ast)))
	     (actual (car (app-actuals ast)))
	     (loc    (ast-location ast)))
	  (cond
	     ((eq? fun *string->bstring*)
	      (if (and (atom? actual) (string? (atom-value actual)))
		  (let ((r (cnst-alloc-string (atom-value actual)
					      loc)))
		     (trace cnst "string->bstring: " (ast->sexp r) #\Newline)
		     r)
		  ast))
	     ((eq? fun *bool->bbool*)
	      (if (and (atom? actual) (boolean? (atom-value actual)))
		  (if (atom-value actual)
		      (ast-var loc (ast-type ast) #f *btrue*)
		      (ast-var loc (ast-type ast) #f *bfalse*))
		  ast))
	     ((or (eq? fun *make-fx-procedure*)
		  (eq? fun *make-va-procedure*))
	      (let ((size (caddr (app-actuals ast))))
		 (if (and (atom? size) (=fx (atom-value size) 0))
		     (cnst-alloc-procedure ast loc)
		     ast)))
	     ((eq? fun *double->real*)
	      (if (and (atom? actual) (real? (atom-value actual)))
		  (cnst-alloc-real (atom-value actual) loc)
		  ast))
	     (else
	      ast)))))
