;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Cgen/generate.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 16 18:14:47 1995                          */
;*    Last change :  Sat Apr  6 10:05:10 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The generation of the C file                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_generate
   (include "Ast/ast.sch")
   (import  cgen_comment
	    cgen_prototype
	    cgen_cdef
	    tstruct_cgen
	    engine_param
	    ast_env
	    ast_global)
   (export  (generate-c-file <sexp>)))

;*---------------------------------------------------------------------*/
;*    *dest-prefix* ...                                                */
;*---------------------------------------------------------------------*/
(define *dest-prefix* #f)

;*---------------------------------------------------------------------*/
;*    open-output-port ...                                             */
;*---------------------------------------------------------------------*/
(define (open-output-port)
   (if (eq? *dest* '--to-stdout)
       (current-output-port)
       (let* ((prefix    (if (and (string? *dest*)
				  (pair? (memq *pass*
					       '(cgen distrib cc cindent))))
			     (prefix *dest*)
			     (prefix *src*)))
	      (file-name (string-append prefix ".c")))
	  (set! *dest-prefix* prefix)
	  (let ((port (open-output-file file-name)))
	     (if (not (output-port? port))
		 file-name
		 port)))))
       
;*---------------------------------------------------------------------*/
;*    generate-c-file ...                                              */
;*---------------------------------------------------------------------*/
(define (generate-c-file global)
   (let ((oport (open-output-port)))
      (if (not (output-port? oport))
	  (user-error "generate-c-file"
		      "Can't not open output file"
		      oport)
	  (begin
	     ;; a very little comment 
	     (emit-file-header oport *src*)
	     ;; emit the GC selection
	     (emit-garbage-collector-selection oport)
	     ;; if we are in debugging mode, we generate a maco
	     (if (or (>fx *compiler-debug* 0) *c-debug*)
		 (emit-debug-activation oport))
	     ;; the include (both Bigloo's and user's ones)
	     (emit-include oport)
	     ;; we emit the generated type for the typed structure
	     (emit-tstruct-type oport)
	     ;; we declare prototypes
	     ;; first, we print the prototype of non procedure
	     (for-each-global!
	      (lambda (global)
		 (if (and (not (eq? (global-class global) 'sprocedure))
			  (or (eq? (global-import global) 'export)
			      (and (eq? (global-import global) 'static)
				   (or (not (function? (global-value global)))
				       (>fx (global-occurrence global) 0)))
			      (and (or (eq? (global-import global) 'import)
				       (eq? (global-import global) 'foreign))
				   (>fx (global-occurrence global) 0))))
		     (emit-prototype oport global))))
	     ;; then we print them
	     (newline oport)
	     (for-each-global!
	      (lambda (global)
		 (if (and (eq? (global-class global) 'sprocedure)
			  (or (eq? (global-import global) 'export)
			      (>fx (global-occurrence global) 0)))
		     (emit-sprocedure-prototype oport global))))
	     (newline oport)
	     ;; we print the C main...
	     (if (or *main*
		     (eq? *pass* 'ld)
		     (eq? *pass* 'distrib))
		 (emit-c-main oport))
	     ;; and we emit all global definitions
	     (for-each (lambda (var)
			  (enter-function (global-shape var))
			  (emit-c-def oport var)
			  (leave-function))
		       global)
	     ;; ok, it is finished we close the port (if not stdout)
	     (if (not (eq? oport (current-output-port)))
		 (close-output-port oport))
	     *dest-prefix*))))

;*---------------------------------------------------------------------*/
;*    emit-file-header ...                                             */
;*---------------------------------------------------------------------*/
(define (emit-file-header port file-name)
   (emit-comment port "" #\=)
   (emit-comment port file-name #\space)
   (emit-comment port *bigloo-name* #\space)
   (emit-comment port (string-append *bigloo-author*
				     (string-append " (c)      "
						    *bigloo-date*))
		 #\space)
   (emit-comment port "" #\=))

;*---------------------------------------------------------------------*/
;*    emit-include ...                                                 */
;*---------------------------------------------------------------------*/
(define (emit-include port)
    (for-each (lambda (i) (fprint port "#include <" i ">"))
	      (reverse! *include-foreign*))
    (newline port))

;*---------------------------------------------------------------------*/
;*    emit-garbage-collector-selection ...                             */
;*---------------------------------------------------------------------*/
(define (emit-garbage-collector-selection port)
   (case *garbage-collector*
      ((boehm)
       (fprint port "#define THE_GC BOEHM_GC"))
      ((bumpy)
       (fprint port "#define THE_GC BOEHM_GC")
       (fprint port "#define BUMPY_GC"))
      (else
       (error "emit-garbage-collector-selection"
	      "Can't emit code for gc"
	      *garbage-collector*))))
       
;*---------------------------------------------------------------------*/
;*    emit-debug-activation ...                                        */
;*---------------------------------------------------------------------*/
(define (emit-debug-activation port)
   (fprint port "#define BIGLOO_DEBUG 1")
   (newline port))

;*---------------------------------------------------------------------*/
;*    emit-c-main ...                                                  */
;*---------------------------------------------------------------------*/
(define (emit-c-main port)
   (fprint port "extern void _bigloo_main();")
   (fprint port "#if defined( __STDC__ )")
   (fprint port "void BIGLOO_MAIN( int argc, char *argv[] )")
   (fprint port "#else")
   (fprint port "void BIGLOO_MAIN( argc, argv )")
   (fprint port "int argc; char *argv[];")
   (fprint port "#endif")
   (fprint port "{_bigloo_main( argc, argv );}"))
