;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/show.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar  8 18:51:37 1995                          */
;*    Last change :  Wed Oct 11 12:21:38 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We show the result of the cfa.                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_show
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Cfa/approx.sch")
   (import  ast_dump
	    ast_env
	    tools_shape
	    tools_speek
	    cfa_dead
	    cfa_cfa
	    cfa_dead
	    cfa_approx)
   (export  (show-cfa-nb-iterations)
	    (show-cfa-results)))

;*---------------------------------------------------------------------*/
;*    show-cfa-nb-iterations ...                                       */
;*---------------------------------------------------------------------*/
(define (show-cfa-nb-iterations)
   (verbose 2 "        " (+fx 1 *cfa-stamp*) " Iteration(s)"
	    #\Newline))

;*---------------------------------------------------------------------*/
;*    show-cfa-results ...                                             */
;*---------------------------------------------------------------------*/
(define (show-cfa-results)
   (trace cfa
	  #\Newline
	  "============================================" #\Newline
	  "cfa-results:" #\Newline
	  "--------------------------------------------" #\Newline)
   (for-each-global! (lambda (global)
			(if (or (eq? (global-import global) 'export)
				(eq? (global-import global) 'static))
			    (if (function? (global-value global))
				(if (alive-function? global)
				    (trace-fun 0 global)
				    #unspecified)
				(trace-var 0 global))))))

;*---------------------------------------------------------------------*/
;*    trace-var ...                                                    */
;*---------------------------------------------------------------------*/
(define (trace-var offset var)
   (let ((marge (make-string offset #\space)))
      (trace cfa marge (shape var) #\: #\Newline)
      (trace cfa marge "<~~ "
	     (approx-shape (get-approx var)) #\Newline)))

;*---------------------------------------------------------------------*/
;*    trace-fun ...                                                    */
;*---------------------------------------------------------------------*/
(define (trace-fun offset var)
   (let ((marge (make-string offset #\space))
	 (fun   (variable-value var)))
      (if (dead-function? var)
	  (trace cfa marge (shape var) #\: " unreachable" #\Newline)
	  (begin
	     (trace cfa marge "---- " (shape var) " -------------------- "
		    #\Newline)
	     (let ((new-marge (make-string (+fx 1 offset) #\space)))
		(for-each (lambda (l)
			     (trace cfa
				    new-marge (shape l) #\:
				    (approx-shape (get-approx l))
				    #\Newline))
			  (function-args fun))
		(trace cfa marge "<-- "
		       (approx-shape (get-approx var))
		       #\Newline)
		(trace-ast (+fx offset 1) (function-body fun))
		(if (global? var)
		    (trace cfa #a012 #\Newline #\Newline)))))))

;*---------------------------------------------------------------------*/
;*    trace-ast ...                                                    */
;*---------------------------------------------------------------------*/
(define (trace-ast marge ast)
   (ast-case ast
      ((atom)
       #unspecified)
      ((kwote)
       #unspecified)
      ((var)
       #unspecified)
      ((prag-ma)
       (for-each (lambda (value)
		    (trace-ast marge value))
		 (prag-ma-values ast))
       #unspecified)
      ((fail)
       #unspecified)
      ((sequence)
       (for-each (lambda (a) (trace-ast marge a)) (sequence-exp ast)))
      ((conditional)
       (trace-ast marge (conditional-test ast))
       (trace-ast marge (conditional-then ast))
       (trace-ast marge (conditional-else ast)))
      ((switch)
       (trace-ast marge (switch-test ast))
       (for-each (lambda (clause)
		    (trace-ast marge (cdr clause)))
		 (switch-clauses ast)))
      ((setq)
       (trace-ast marge (setq-val ast)))
      ((let-var)
       (let ((s (make-string marge #\space)))
	  (for-each (lambda (b)
		       (trace cfa
			      s (shape (car b)) #\:
			      (approx-shape (get-approx (car b)))
			      #\Newline))
		    (let-var-bindings ast))
	  (for-each (lambda (b)
		       (trace-ast (+fx 1 marge) (cdr b)))
		    (let-var-bindings ast))
	  (trace-ast (+fx marge 1) (let-var-body ast))))
      ((let-fun)
       (let ((s (make-string marge #\space)))
	  (for-each (lambda (l)
		       (trace-fun marge l))
		    (let-fun-locals ast))
	  (trace-ast (+fx marge 1) (let-fun-body ast))))
      ((set-ex-it)
       (trace-ast marge (set-ex-it-body ast)))
      ((jump-ex-it)
       (trace-ast marge (jump-ex-it-exit ast))
       (trace-ast marge (jump-ex-it-value ast)))
      ((app-ly)
       (trace-ast marge (app-ly-fun ast))
       (trace-ast marge (app-ly-value ast)))
      ((funcall)
       (trace-ast marge (funcall-fun ast))
       (for-each (lambda (a) (trace-ast marge a)) (funcall-actuals ast)))
      ((app)
       (for-each (lambda (a) (trace-ast marge a)) (app-actuals ast)))
      ((make-box)
       (trace-ast marge (make-box-value ast)))
      ((box-ref)
       (trace-ast marge (box-ref-var ast)))
      ((box-set!)
       (trace-ast marge (box-set!-var ast))
       (trace-ast marge (box-set!-value ast)))))

		    
