;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Bivalue/app.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan 23 08:35:08 1995                          */
;*    Last change :  Thu Mar 28 16:15:53 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The bivaluation of `app' nodes.                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module bivalue_app
   (include "Ast/node.sch")
   (import  tools_shape
	    tools_speek
	    ast_global
	    ast_app
	    ast_sexp
	    ast_env
	    ast_dump
	    bivalue_walk
	    bivalue_cache)
   (export (bivalue-app! <ast>)))

;*---------------------------------------------------------------------*/
;*    bivalue-app! ...                                                 */
;*---------------------------------------------------------------------*/
(define (bivalue-app! ast)
   ;; first of all, we bivaluate the arguments
   (bivalue*! (app-actuals ast))
   ;; and we examine the functional operator
   (let ((fun (app-fun ast)))
      (cond
	 ((and (var? fun)
	       (or (function? (variable-value (var-variable fun)))
		   (and (global? (var-variable fun))
			(eq? (global-import (var-variable fun)) 'foreign))))
	  ;; ok, we apply a function.
	  (bivalue-known-app! ast))
	 ((and (var? fun)
	       (local? (var-variable fun))
	       (return? (local-value (var-variable fun))))
	  (internal-error (current-function)
			  "Illegal application"
			  (ast->sexp ast)))
	 (else
	  ;; the applied value is not a known function, we construct
	  ;; a `funcall' node. We add the new argument (the argument
	  ;; which hold the environement).
	  (let ((fun (bivalue! fun)))
	     (ast-funcall (ast-location ast)
			  (ast-type ast)
			  (ast-info ast)
			  fun
			  (cons fun (app-actuals ast))
			  #unspecified))))))

;*---------------------------------------------------------------------*/
;*    bivalue-known-app! ...                                           */
;*---------------------------------------------------------------------*/
(define (bivalue-known-app! ast)
   (let ((callee (var-variable (app-fun ast))))
      (if (function? (variable-value callee))
	  (bivalue-known-bigloo-app! callee ast)
	  (bivalue-known-foreign-app! callee ast))))

;*---------------------------------------------------------------------*/
;*    bivalue-known-bigloo-app! ...                                    */
;*---------------------------------------------------------------------*/
(define (bivalue-known-bigloo-app! callee ast)
   (let ((fun (variable-value callee)))
      (if (correct-app? (function-arity fun) ast)
	  (if (>=fx (function-arity fun) 0)
	      ast
	      (bivalue-known-bigloo-va-app! fun callee ast))
	  (app-error (current-function) ast))))

;*---------------------------------------------------------------------*/
;*    bivalue-known-bigloo-va-app! ...                                 */
;*---------------------------------------------------------------------*/
(define (bivalue-known-bigloo-va-app! fun callee ast)
   (define (make-args-list actuals)
      (let ((cons *cons*)
	    (loc  (ast-location ast)))
         (let loop ((actuals actuals))
            (if (null? actuals)
                (sexp->ast ''()
                           '()
                           #f
			   loc
                           'read)
		(begin
		   (global-occurrence-set! cons
					   (+fx 1 (global-occurrence cons)))
		   (ast-app loc
			    #f
			    #f
			    (ast-var loc #f #f cons)
			    (list (car actuals) (loop (cdr actuals)))
			    #f
			    #f
			    #f
			    #f))))))
   (let loop ((actuals (app-actuals ast))
	      (formals (function-args fun)))
      (if (null? (cdr formals))
	  (if (null? actuals)
	      (begin
		 (app-actuals-set! ast (append (app-actuals ast)
					       (list
						(sexp->ast ''()
							   '()
							   #f
							   (ast-location ast)
							   'read))))
		 ast)
	      (begin
		 ;; it is the rest argument
		 (set-car! actuals (make-args-list actuals))
		 (set-cdr! actuals '())
		 ast))
	  (loop (cdr actuals)
		(cdr formals)))))

;*---------------------------------------------------------------------*/
;*    bivalue-known-foreign-app! ...                                   */
;*---------------------------------------------------------------------*/
(define (bivalue-known-foreign-app! callee ast)
   (let ((fun (global-value callee)))
      (cond
	 ((not (foreign-applicable? fun (global-name callee)))
	  (app-error (current-function) ast))
	 ((correct-app? (ffunction-arity fun) ast)
	  ast)
	 (else
	  (app-error (current-function) ast)))))

