.TH XGetfile 1 "24 Aug 1995"
.UC 4
.SH NAME
xgetfile \- X based versatile file requester
.SH SYNOPSIS
.B xgetfile
[
.B -title
.I title
] [
.B -path
.I path
] [
.B -pattern
.I pattern
] [
.B -file
.I file
] [
.B -popup
] [
.B -quote
] [
.B -exec
.I "command"
] [
.B -format
.I "format-string"
] [
.B -queue
]

.SH DESCRIPTION
.I XGetfile
is a versatile file requester. It pops up a window and lets the user
chose a file with the mouse or the keyboard. When the user selects a
file, several actions are possible. Please see also the
.B EXAMPLES
section below.

By default,
.I XGetfile
sends the selected filename with the complete path to stdout and exits.
This makes the program very useful for shell-scripts.

In addition, you can specify a command which
.I XGetfile
should execute whenever a file is selected. In that case, two modes are
possible. In normal mode, the command is executed with the filename anywhere
in its argument list, and the user will have to wait until the command
finishes before a new filename can be selected.
In queued mode, the user can select several files one after the other without
delay, while
.I XGetfile
will queue them up in a list. Each time a command finishes, the next file
in the list is taken and fed to a new command until the list is empty.
Queued mode is much fun when browsing through a list of audio files (:

.SH OPTIONS
Options offered by
.I XGetfile
are the following:
.TP 0.6i
.B -display \<display\>
Show the control window on the given display.
.TP 0.6i
.B -fn \<font\>
Use this font rather than the default. The given font should be about the
same size like the default font. If not, the window may look ugly.
.TP 0.6i
.B -title \<title\>
Display the given title in the windows title bar instead of just
.I XGetfile.
.TP 0.6i
.B -path \<path\>
Start up with \<path\> as the default search path.
.TP 0.6i
.B -pattern \<pattern\>
Display only files which match \<pattern\>. Usual shell pattern matching
is used. The pattern string may hold several patterns separated by spaces.
Be sure to place the pattern string in double quotes on the commandline to
prevent the shell from parsing them.
.TP 0.6i
.B -file \<file\>
Offer \<file\> to the user as the default selection. The user may still select
another file of course.
.TP 0.6i
.B -popup
Tells
.I XGetfile
to pop up as a transient window directly under the pointer. Depending on your
window manager setup, this means that the requester pops up immediately
instead of letting the user pick a place for the window first. In addition,
the window manager may chose to decorate the window in a different way to
tell the user that the window is not going to live very long.
 However, the actual difference between using -popup or not depends heavily
on your windowmanager.
.TP 0.6i
.B -quote
Print the selected filename in single quotes on exit. This is useful for
filenames which contain weird characters. This option is useless if
.B -exec
is given.
.TP 0.6i
.B -exec \<command\>
Execute command whenever the user selects a file.
.I XPlaycd
won't quit after the user made a selection, but will continue running until
the user selects
.B Cancel
or the program gets otherwise killed.
Up to eight occurances of
.B %s
in \<command\> will be replaced by the selected file. Be sure to place the
command in double quotes on the command line if it contains tabs or spaces.
.TP 0.6i
.B -queue
This option is only useful if a command was specified with the -exec option.
.I XPlaycd
will run in queued mode and won't wait until a command finishes before the
user can select a new file. See examples below.
.TP 0.6i
.B -format \<format-string\>
Allows to format the appearance of each file in the list.
.I \<format-string\>
may be an arbitrary string. The following character sequences are understood:
.TP 0.8i
.B %p
Permissions (e.g. -rw-rw-rw). Default size 10 characters.
.TP 0.8i
.B %n
Filename, default size is rest of the default window width of 40 characters.
If the window is too small to display everything it is expanded and the
default size of %n is set to 20.
.TP 0.8i
.B %s
File size in bytes or <DIR> for directories and <UP-DIR> for parent directory.
Default size 8 characters.
.TP 0.8i
.B %o
The owner of the file. Default size 8 characters.
.TP 0.8i
.B %g
The group of the file. Default size 8 characters.
.TP 0.8i
.B %h
The number of hardlinks of the file. Default size 3 characters.
.TP 0.8i
.B %tm
The file creation time. Default size 12 characters.
.TP 0.8i
.B %tc
The file change time. Default size 12 characters.
.TP 0.8i
.B %ta
The file access time. Default size 12 characters.
.TP 0.6i
\ 
Any other characters are printed as is. It is possible to change the default
size of the above control sequences by putting the size behind the % sign
(e.g. %12n).

A special case is the format string "ll" which is an abbreviation for
"%p\ %h\ %o\ %g\ %s\ %tm\ %n". This is the default format used by ls -l.

Be sure to quote the format string when used on the commandline or in
a shell-script.

The default format string is "%p\ %n\ %s".

.SH "RESOURCES"
.I XGetfile
understands a large number of
.I X11
resources which are listed below. These system wide resources usually sit in
a file called
.B /usr/lib/X11/app-defaults/XGetfile.
Personal resources reside either in 
.B ~/.Xdefaults
or
.B ~/.Xresources
depending on your installation. To put an
.I XGetfile
resource into your personal resource file, prefix it with the word
.B xgetfile.
After editing your personal file, be sure to run
.B xrdb ~/.Xresources
or
.B xrdb ~/.Xdefaults
to make them work. There is no need for a prefix or an invocation of
.I xrdb
if you change the system wide file.

.SH "STANDARD RESOURCES"
Standard
.I X11
resources with their defaults are shown here. For an explanation of the
standard resources please see the
.I X11
dcumentation.

Standard resources are:

.TP 0.6i
.B *title: XGetfile
.TP 0.6i
.B *geometry: 312x300
.TP 0.6i
.B *iconic: off
.TP 0.6i
.B *background: gray80
.TP 0.6i
.B *foreground: black
.TP 0.6i
.B *font: -b&h-lucida-medium-r-normal-sans-*-120-*-*-p-*-*-*
.TP 0.6i
.B *reverseVideo: off
.TP 0.6i
.B *synchronize: off


.SH "SPECIAL RESOURCES"
Special
.I XGetfile
resources are:

.TP 0.6i
.B *brightBorder: gray94
.TP 0.6i
.B *darkBorder: gray40
.TP 0.6i
.B *hilightColor: gray72
These settings are responsible for the 3D-look-and-feel of the program.
Just play with the values to see what they do.
.TP 0.6i
.B *dirFormat: %p %n %s
Directory list format. See -format commandline option for description.

.SH "EXAMPLES"
Here are a few examples for the use of XGetfile.

In a shell script:
.nf
.sp
 SELECTION=`xgetfile -title "Please select a file to load" -path "/tmp"`
.fi

.I XGetfile
will prompt the user for a file and will print it to stdout. The
calling shell will take
.I XGetfile's
output and assign it to the environment variable
.B SELECTION
for further processing.
  If you want to use XGetfile in a script which may be used from graphic
and text based terminals, you should check for the
.B DISPLAY
environment variable and you should provide a text based way to select
a file if
.B DISPLAY
is not set. I find the
.I dialog(1)
program useful for that purpose.


As a versatile frontend to an audio file player with the assumed command
name
.B play
:
.nf
.sp
 xgetfile -title "Please select a file to play" -exec "play %s" -queue"
.fi

.I XGetfile
will take each selected file and execute
.B play \<filename\>
which will play it throught the sound hardware. If the user selects
more than one file, the next sample is played as soon as the previous one
ends.
If you give the command without the
.B -queue
option, the user
.B must
wait until the
.B play
command finishes.
  To understand the difference between queued and normal mode, try something
like this example with and without the
.B -queue
option.


I like it to browse through my selection of samples with the following
short script:
.nf
.sp
 #!/bin/sh
 exec xgetfile -title "Please select a file to play" \\
               -path "/usr/local/lib/sound/fx" -exec "play %s" -queue
.fi


.SH BUGS
This manpage is
.B really
confusing.

.SH "SEE ALSO"
xmixer(1), xplaycd(1)

.SH AUTHOR
Olav Woelfelschneider
   (wosch@rbg.informatik.th-darmstadt.de)

.SH COPYING
Copyright (C) 1994 
 Olav Woelfelschneider
 (wosch@rbg.informatik.th-darmstadt.de)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

