/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  net.h
 * Purpose: Header file for the network interface
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Ethernet hardware address length:
 */
#define ETH_ALEN	6



/*
 **************************************************************************
 *
 * Internet address length, and type:
 */
typedef unsigned long	t_ipaddr;

#define IP_ALEN		4



/*
 **************************************************************************
 *
 * Special internet addresses:
 */

/* Address to accept any incoming messages */
#define	IP_ANY		((t_ipaddr) 0x00000000L)

/* Address for a default route */
#define IP_DEFAULT	((t_ipaddr) 0x00000000L)

/* Address to send to all hosts */
#define	IP_BROADCAST	((t_ipaddr) 0xffffffffL)

/* Address to loopback in software to local host  */
#define	IP_LOCALHOST	((t_ipaddr) 0x7f000001L)

/* Netmask for class A network */
#define IN_CLASS_A(a)	(((a) & 0x80000000L) == 0L)
#define IP_CLASS_A	((t_ipaddr) 0xff000000L)

/* Netmask for class B network */
#define IN_CLASS_B(a)	(((a) & 0xc0000000L) == 0x80000000L)
#define IP_CLASS_B	((t_ipaddr) 0xffff0000L)

/* Netmask for class C network */
#define IN_CLASS_C(a)	(((a) & 0xe0000000L) == 0xc0000000L)
#define IP_CLASS_C	((t_ipaddr) 0xffffff00L)



/*
 **************************************************************************
 *
 * Routines to convert the host byte order into network byte order:
 */
extern unsigned short _htons(unsigned short);
extern unsigned long _htonl(unsigned long);
#define _ntohs _htons
#define _ntohl _htonl

#ifndef USE_INLINE

#define htons _htons				/* short to net order	*/
#define htonl _htonl				/* long to net order	*/
#define ntohs _htons				/* net order to short	*/
#define ntohl _htonl				/* net order to long	*/

#else

#define byteswap(a)	((((a) & 0x00ff) << 8) | (((a) & 0xff00) >> 8))
#define htons(a)	(byteswap(a))
#define htonl(a)	_htonl(a)
#define ntohs(a)	(byteswap(a))
#define ntohl(a)	_ntohl(a)

#endif



/*
 **************************************************************************
 *
 * Public routines of the network interface library:
 */

/* Initialization of network library */
extern void init_net(void);

/* Configure interface addresses */
extern void if_config(t_ipaddr myip, t_ipaddr netmask);

/* Get hardware address */
extern void get_hw_addr(char *hwaddr);

/* Set default gateway */
extern void set_gateway(t_ipaddr gw);

/* Open a UDP socket */
extern int udp_open(t_ipaddr daddr, int source, int dest);

/* Read from a UDP socket */
extern int udp_read(char *buf, int bufsize, int timeout, char abortch);

/* Write to a UDP socket */
extern int udp_write(char *buf, int writelen);

