;;; ms-insert.el --- insert functions for MS-Dos

;;; If we can't insert something that doesn't exist in PC-437...
(defun ms-insert-850-warning-message ()
  (message "PC-850 code page character"))

(if ms850iso
    (setq eight t four nil)
  (setq eight nil four t))

(defun ms-insert-inverted-exclamation-mark ()
   (interactive "*")
   (insert 173)
)

(defun ms-insert-cent-sign ()
  (interactive "*")
  (if eight (insert 189)
    (ms-insert-850-warning-message)))

(defun ms-insert-pound-sign ()
   (interactive "*")
   (insert 156)
)

(defun ms-insert-general-currency-sign ()
   (interactive "*")
   (if h
       (insert 207)
     (ms-insert-850-warning-message))
)

(defun ms-insert-yen-sign ()
   (interactive "*")
   (if eight (insert 190)
     (insert 157))
)

(defun ms-insert-broken-vertical-line ()
   (interactive "*")
   (if eight (insert 221)
     (insert 124))
)

(defun ms-insert-section-sign ()
   (interactive "*")
   (if eight (insert 245)
     (ms-insert-850-warning-message))
)

(defun ms-insert-diaeresis ()
   (interactive "*")
   (if eight (insert 249)
     (ms-insert-850-warning-message))
)

(defun ms-insert-copyright-sign ()
   (interactive "*")
   (if eight (insert 184)
     (ms-insert-850-warning-message))
)

(defun ms-insert-ordinal-indicator-feminine ()
   (interactive "*")
   (insert 166)
)

(defun ms-insert-angle-quotation-mark-left ()
   (interactive "*")
   (insert 174)
)

(defun ms-insert-not-sign ()
   (interactive "*")
   (insert 172)
)

(defun ms-insert-soft-hyphen ()
   (interactive "*")
   (if eight (insert 173)
     (ms-insert-850-warning-message))
)

(defun ms-insert-registered-sign ()
   (interactive "*")
   (if eight (insert 169)
     (ms-insert-850-warning-message))
)

(defun ms-insert-macron ()
   (interactive "*")
   (if eight (insert 238)
     (ms-insert-850-warning-message))
)

(defun ms-insert-degree-sign ()
   (interactive "*")
   (insert 248)
)

(defun ms-insert-plus-or-minus-sign ()
   (interactive "*")
   (insert 241)
)

(defun ms-insert-superscript-two ()
   (interactive "*")
   (insert 253)
)

(defun ms-insert-superscript-three ()
   (interactive "*")
   (if eight (insert 252)
     (ms-insert-850-warning-message))
)

(defun ms-insert-acute-accent ()
   (interactive "*")
   (if eight (insert 239)
     (ms-insert-850-warning-message))
)

(defun ms-insert-micro-sign ()
   (interactive "*")
   (insert 230)
)

(defun ms-insert-pilcrow ()
   (interactive "*")
   (if eight (insert 244)
     (ms-insert-850-warning-message))
)

(defun ms-insert-middle-dot ()
   (interactive "*")
   (insert 250)
)

(defun ms-insert-cedilla ()
   (interactive "*")
   (if eight (insert 247)
     (ms-insert-850-warning-message))
)

(defun ms-insert-superscript-one ()
   (interactive "*")
   (if eight (insert 251)
     (ms-insert-850-warning-message))
)

(defun ms-insert-ordinal-indicator-masculine ()
   (interactive "*")
   (insert 167)
)

(defun ms-insert-angle-quotation-mark-right ()
   (interactive "*")
   (insert 175)
)

(defun ms-insert-fraction-one-quarter ()
   (interactive "*")
   (insert 172)
)

(defun ms-insert-fraction-one-half ()
   (interactive "*")
   (insert 171)
)

(defun ms-insert-fraction-three-quarters ()
   (interactive "*")
   (if eight (insert 243)
     (ms-insert-850-warning-message))
)

(defun ms-insert-inverted-question-mark ()
   (interactive "*")
   (insert 168)
)

(defun ms-insert-A-grave ()
   (interactive "*")
   (if eight (insert 183)
     (ms-insert-850-warning-message))
)

(defun ms-insert-A-acute ()
   (interactive "*")
   (if eight (insert 181)
     (ms-insert-850-warning-message))
)

(defun ms-insert-A-circumflex ()
   (interactive "*")
   (if eight (insert 182)
     (ms-insert-850-warning-message))
)

(defun ms-insert-A-tilde ()
   (interactive "*")
   (if eight (insert 199)
     (ms-insert-850-warning-message))
)

(defun ms-insert-A-umlaut ()
   (interactive "*")
   (insert 142)
)

(defun ms-insert-A-ring ()
   (interactive "*")
   (insert 143)
)

(defun ms-insert-AE ()
   (interactive "*")
   (insert 146)
)

(defun ms-insert-C-cedilla ()
   (interactive "*")
   (insert 128)
)

(defun ms-insert-E-grave ()
   (interactive "*")
   (if eight (insert 212)
     (ms-insert-850-warning-message))
)

(defun ms-insert-E-acute ()
   (interactive "*")
   (insert 144)
)

(defun ms-insert-E-circumflex ()
   (interactive "*")
   (if eight (insert 210)
     (ms-insert-850-warning-message))
   )

(defun ms-insert-E-umlaut ()
   (interactive "*")
   (if eight (insert 211)
     (ms-insert-850-warning-message))
)

(defun ms-insert-I-grave ()
   (interactive "*")
   (if eight (insert 222)
     (ms-insert-850-warning-message))
)

(defun ms-insert-I-acute ()
   (interactive "*")
   (if eight (insert 214)
     (ms-insert-850-warning-message))
)

(defun ms-insert-I-circumflex ()
   (interactive "*")
   (if eight (insert 215)
     (ms-insert-850-warning-message))
)

(defun ms-insert-I-umlaut ()
   (interactive "*")
   (if eight (insert 216)
     (ms-insert-850-warning-message))
)

(defun ms-insert-D-stroke ()
   (interactive "*")
   (if eight (insert 209)
     (ms-insert-850-warning-message))
)

(defun ms-insert-N-tilde ()
   (interactive "*")
   (insert 165)
)

(defun ms-insert-O-grave ()
   (interactive "*")
   (if eight (insert 227)
     (ms-insert-850-warning-message))
)

(defun ms-insert-O-acute ()
   (interactive "*")
   (if eight (insert 224)
     (ms-insert-850-warning-message))
)

(defun ms-insert-O-circumflex ()
   (interactive "*")
   (if eight (insert 226)
     (ms-insert-850-warning-message))
)

(defun ms-insert-O-tilde ()
   (interactive "*")
   (if eight (insert 229)
     (ms-insert-850-warning-message))
)

(defun ms-insert-O-umlaut ()
   (interactive "*")
   (insert 153)
)

(defun ms-insert-multiplication-sign ()
   (interactive "*")
   (if eight (insert 158)
     (ms-insert-850-warning-message))
)

(defun ms-insert-O-slash ()
   (interactive "*")
   (if eight (insert 157)
     (ms-insert-850-warning-message))
)

(defun ms-insert-U-grave ()
   (interactive "*")
   (if eight (insert 235)
     (ms-insert-850-warning-message))
)

(defun ms-insert-U-acute ()
   (interactive "*")
   (if eight (insert 233)
     (ms-insert-850-warning-message))
)

(defun ms-insert-U-circumflex ()
   (interactive "*")
   (if eight (insert 234)
     (ms-insert-850-warning-message))
)

(defun ms-insert-U-umlaut ()
   (interactive "*")
   (insert 154)
)

(defun ms-insert-Y-acute ()
   (interactive "*")
   (if eight (insert 237)
     (ms-insert-850-warning-message))
)

(defun ms-insert-THORN ()
   (interactive "*")
   (if eight (insert 232)
     (ms-insert-850-warning-message))
)

(defun ms-insert-ss ()
   (interactive "*")
   (insert 225)
)

(defun ms-insert-a-grave ()
   (interactive "*")
   (insert 133)
)

(defun ms-insert-a-acute ()
   (interactive "*")
   (insert 160)
)

(defun ms-insert-a-circumflex ()
   (interactive "*")
   (insert 131)
)

(defun ms-insert-a-tilde ()
   (interactive "*")
   (if eight (insert 198)
     (ms-insert-850-warning-message))
)

(defun ms-insert-a-umlaut ()
   (interactive "*")
   (insert 132)
)

(defun ms-insert-a-ring ()
   (interactive "*")
   (insert 134)
)

(defun ms-insert-ae ()
   (interactive "*")
   (insert 145)
)

(defun ms-insert-c-cedilla ()
   (interactive "*")
   (insert 135)
)

(defun ms-insert-e-grave ()
   (interactive "*")
   (insert 138)
)

(defun ms-insert-e-acute ()
   (interactive "*")
   (insert 130)
)

(defun ms-insert-e-circumflex ()
   (interactive "*")
   (insert 136)
)

(defun ms-insert-e-umlaut ()
   (interactive "*")
   (insert 137)
)

(defun ms-insert-i-grave ()
   (interactive "*")
   (insert 141)
)

(defun ms-insert-i-acute ()
   (interactive "*")
   (insert 161)
)

(defun ms-insert-i-circumflex ()
   (interactive "*")
   (insert 140)
)

(defun ms-insert-i-umlaut ()
   (interactive "*")
   (insert 139)
)

(defun ms-insert-d-stroke ()
   (interactive "*")
   (if eight (insert 208)
     (ms-insert-850-warning-message))
)

(defun ms-insert-n-tilde ()
   (interactive "*")
   (insert 164)
)

(defun ms-insert-o-grave ()
   (interactive "*")
   (if eight (insert 149)
     (ms-insert-850-warning-message))
)

(defun ms-insert-o-acute ()
   (interactive "*")
   (insert 162)
)

(defun ms-insert-o-circumflex ()
   (interactive "*")
   (insert 147)
)

(defun ms-insert-o-tilde ()
   (interactive "*")
   (if eight (insert 228)
     (ms-insert-850-warning-message))
)

(defun ms-insert-o-umlaut ()
   (interactive "*")
   (insert 148)
)

(defun ms-insert-division-sign ()
   (interactive "*")
   (insert 246)
)

(defun ms-insert-o-slash ()
   (interactive "*")
   (if eight (insert 155)
     (ms-insert-850-warning-message))
)

(defun ms-insert-u-grave ()
   (interactive "*")
   (insert 151)
)

(defun ms-insert-u-acute ()
   (interactive "*")
   (insert 163)
)

(defun ms-insert-u-circumflex ()
   (interactive "*")
   (insert 150)
)

(defun ms-insert-u-umlaut ()
   (interactive "*")
   (insert 129)
)

(defun ms-insert-y-acute ()
   (interactive "*")
   (if eight (insert 236)
     (ms-insert-850-warning-message))
)

(defun ms-insert-thorn ()
   (interactive "*")
   (if eight (insert 231)
     (ms-insert-850-warning-message))
)

(defun ms-insert-y-umlaut ()
   (interactive "*")
   (insert 152)
)

(defvar ms-map nil "Keymap for MS-DOS character insertion.")
(if ms-map nil
   (setq ms-map (make-keymap))
   (define-key ms-map "!"    'ms-insert-inverted-exclamation-mark)
   (define-key ms-map "\""   (make-sparse-keymap))
   (define-key ms-map "\"\"" 'ms-insert-diaeresis)
   (define-key ms-map "\"A"  'ms-insert-A-umlaut)
   (define-key ms-map "\"E"  'ms-insert-E-umlaut)
   (define-key ms-map "\"I"  'ms-insert-I-umlaut)
   (define-key ms-map "\"O"  'ms-insert-O-umlaut)
   (define-key ms-map "\"U"  'ms-insert-U-umlaut)
   (define-key ms-map "\"a"  'ms-insert-a-umlaut)
   (define-key ms-map "\"e"  'ms-insert-e-umlaut)
   (define-key ms-map "\"i"  'ms-insert-i-umlaut)
   (define-key ms-map "\"o"  'ms-insert-o-umlaut)
   (define-key ms-map "\"u"  'ms-insert-u-umlaut)
   (define-key ms-map "\"y"  'ms-insert-y-umlaut)
   (define-key ms-map "'"    (make-sparse-keymap))
   (define-key ms-map "''"   'ms-insert-acute-accent)
   (define-key ms-map "'A"   'ms-insert-A-acute)
   (define-key ms-map "'E"   'ms-insert-E-acute)
   (define-key ms-map "'I"   'ms-insert-I-acute)
   (define-key ms-map "'O"   'ms-insert-O-acute)
   (define-key ms-map "'U"   'ms-insert-U-acute)
   (define-key ms-map "'Y"   'ms-insert-Y-acute)
   (define-key ms-map "'a"   'ms-insert-a-acute)
   (define-key ms-map "'e"   'ms-insert-e-acute)
   (define-key ms-map "'i"   'ms-insert-i-acute)
   (define-key ms-map "'o"   'ms-insert-o-acute)
   (define-key ms-map "'u"   'ms-insert-u-acute)
   (define-key ms-map "'y"   'ms-insert-y-acute)
   (define-key ms-map "$"    'ms-insert-general-currency-sign)
   (define-key ms-map "+"    'ms-insert-plus-or-minus-sign)
   (define-key ms-map ","    (make-sparse-keymap))
   (define-key ms-map ",,"   'ms-insert-cedilla)
   (define-key ms-map ",C"   'ms-insert-C-cedilla)
   (define-key ms-map ",c"   'ms-insert-c-cedilla)
   (define-key ms-map "-"    'ms-insert-soft-hyphen)
   (define-key ms-map "."    'ms-insert-middle-dot)
   (define-key ms-map "/"    (make-sparse-keymap))
   (define-key ms-map "//"   'ms-insert-division-sign)
   (define-key ms-map "/O"   'ms-insert-O-slash)
   (define-key ms-map "/o"   'ms-insert-o-slash)
   (define-key ms-map "1"    (make-sparse-keymap))
   (define-key ms-map "1/"   (make-sparse-keymap))
   (define-key ms-map "1/2"  'ms-insert-fraction-one-half)
   (define-key ms-map "1/4"  'ms-insert-fraction-one-quarter)
   (define-key ms-map "3"    (make-sparse-keymap))
   (define-key ms-map "3/"   (make-sparse-keymap))
   (define-key ms-map "3/4"  'ms-insert-fraction-three-quarters)
   (define-key ms-map "<"    'ms-insert-angle-quotation-mark-left)
   (define-key ms-map "="    'ms-insert-macron)
   (define-key ms-map ">"    'ms-insert-angle-quotation-mark-right)
   (define-key ms-map "?"    'ms-insert-inverted-question-mark)
   (define-key ms-map "A"    (make-sparse-keymap))
   (define-key ms-map "AA"   'ms-insert-A-ring)
   (define-key ms-map "AE"   'ms-insert-AE)
   (define-key ms-map "C"    'ms-insert-copyright-sign)
   (define-key ms-map "D"    'ms-insert-D-stroke)
   (define-key ms-map "L"    'ms-insert-pound-sign)
   (define-key ms-map "P"    'ms-insert-pilcrow)
   (define-key ms-map "R"    'ms-insert-registered-sign)
   (define-key ms-map "S"    'ms-insert-section-sign)
   (define-key ms-map "T"    'ms-insert-THORN)
   (define-key ms-map "Y"    'ms-insert-yen-sign)
   (define-key ms-map "^"    (make-sparse-keymap))
   (define-key ms-map "^1"   'ms-insert-superscript-one)
   (define-key ms-map "^2"   'ms-insert-superscript-two)
   (define-key ms-map "^3"   'ms-insert-superscript-three)
   (define-key ms-map "^A"   'ms-insert-A-circumflex)
   (define-key ms-map "^E"   'ms-insert-E-circumflex)
   (define-key ms-map "^I"   'ms-insert-I-circumflex)
   (define-key ms-map "^O"   'ms-insert-O-circumflex)
   (define-key ms-map "^U"   'ms-insert-U-circumflex)
   (define-key ms-map "^a"   'ms-insert-a-circumflex)
   (define-key ms-map "^e"   'ms-insert-e-circumflex)
   (define-key ms-map "^i"   'ms-insert-i-circumflex)
   (define-key ms-map "^o"   'ms-insert-o-circumflex)
   (define-key ms-map "^u"   'ms-insert-u-circumflex)
   (define-key ms-map "_"    (make-sparse-keymap))
   (define-key ms-map "_a"   'ms-insert-ordinal-indicator-feminine)
   (define-key ms-map "_o"   'ms-insert-ordinal-indicator-masculine)
   (define-key ms-map "`"    (make-sparse-keymap))
   (define-key ms-map "`A"   'ms-insert-A-grave)
   (define-key ms-map "`E"   'ms-insert-E-grave)
   (define-key ms-map "`I"   'ms-insert-I-grave)
   (define-key ms-map "`O"   'ms-insert-O-grave)
   (define-key ms-map "`U"   'ms-insert-U-grave)
   (define-key ms-map "`a"   'ms-insert-a-grave)
   (define-key ms-map "`e"   'ms-insert-e-grave)
   (define-key ms-map "`i"   'ms-insert-i-grave)
   (define-key ms-map "`o"   'ms-insert-o-grave)
   (define-key ms-map "`u"   'ms-insert-u-grave)
   (define-key ms-map "a"    (make-sparse-keymap))
   (define-key ms-map "aa"   'ms-insert-a-ring)
   (define-key ms-map "ae"   'ms-insert-ae)
   (define-key ms-map "c"    'ms-insert-cent-sign)
   (define-key ms-map "d"    'ms-insert-d-stroke)
   (define-key ms-map "o"    'ms-insert-degree-sign)
   (define-key ms-map "s"    'ms-insert-ss)
   (define-key ms-map "t"    'ms-insert-thorn)
   (define-key ms-map "u"    'ms-insert-micro-sign)
   (define-key ms-map "x"    'ms-insert-multiplication-sign)
   (define-key ms-map "|"    'ms-insert-broken-vertical-line)
   (define-key ms-map "~"    (make-sparse-keymap))
   (define-key ms-map "~A"   'ms-insert-A-tilde)
   (define-key ms-map "~N"   'ms-insert-N-tilde)
   (define-key ms-map "~O"   'ms-insert-O-tilde)
   (define-key ms-map "~a"   'ms-insert-a-tilde)
   (define-key ms-map "~n"   'ms-insert-n-tilde)
   (define-key ms-map "~o"   'ms-insert-o-tilde)
   (define-key ms-map "~~"   'ms-insert-not-sign)
   )

;; MS-DOS suff

;; Define here the characters found in MS-DOS and not in ISO 8859-1
