.\" $Id: vboxgetty.conf.man,v 1.3 1997/09/11 10:53:55 aj Exp $
.\" CHECKIN $Date: 1997/09/11 10:53:55 $
.TH vboxgetty.conf 5 "@MANDATE@" "ISDN 4 Linux @I4LVERSION@" "Linux System Administration"
.PD 0
.SH NAME
vboxgetty.conf \- config file for vboxgetty

.SH Description
The file 
.B @I4LCONFDIR@/vboxgetty.conf
is used to configure vboxgetty. Please read the man page vboxgetty(8) for
a description of how vboxgetty works.

Everything after "#" is ignored, as are empty lines. All arguments
must be separated by whitespace (spaces, tabs). Arguments may not contain
whitespace.

All settings before the first
.B port 
command are global settings, after a port command they only affect the
current port.

.TP
.B port <string>
ISDN device to configure.

.TP
.B modeminit <string>
Command to initialize the modem. You should set the MSN/EAZ on which
vboxgetty should listen for incoming calls. Default is "ATZ".

.TP
.B user <string>
Name of the user that vboxgetty will use. This user must exist in
/etc/passwd and you must use this parameter.

.TP
.B group <string>
Name of the group that vboxgetty will use. This group must exist in
/etc/group and you must use this parameter.

.TP
.B umask <number>
Vboxgetty will use this umask when creating new files. You must give the
umask as an octal number. Default is 077.

.TP
.B dropdtrtime <seconds>
Number of milliseconds to hold the DTR-Line low to reset the modem.
Default value is 800.

.TP
.B initpause <number>
Number of milliseconds to wait after initializing the modem. This is used
to compensate the delay of the "NO CARRIER" response. Default value is
1500.

.TP
.B badinitsexit <number>
Maximum failures with modeminit. If this number is reached, vboxgetty
exits. Default is 0.


.TP
.B ringtimeout <number>
Time in seconds to wait for a RING. If no RING is received within this time,
no call is taken. Default is 5.

.TP
.B echotimeout <number>
Time in seconds to wait for the echo from the modem. Default is 4.

.TP
.B commandtimeout <number>
Time in seconds to wait for a response to a modem command. Default is 4.

.TP
.B alivetimeout <number>
After this time in seconds vboxgetty will check if the modem is still
responding to modem commands. Default is 1800.

.TP
.B compression <string>
Audio compression to use to record new messages. Possible values are
ADPCM-2, ADPCM-3, ADPCM-4 and ULAW. The ALAW compression mode is no
longer supported. Default is ULAW.

.TP
.B spooldir <string>
Spool directory to use. This directory must exist. It's used for control
files of several programs. Default is @SPOOLDIR@/<user>.

.TP
.B vboxconfig <string>
Full path of the vbox config file. Default value is <spooldir>/vbox.conf.

.TP
.B freespace <number>
Number of bytes that must be available on the partition with the spool
directory, so that a call may be taken. Default is 0.

.SH FILES
.TP
.B @I4LCONFDIR@/vboxgetty.conf
this configuration file
.TP
.B /usr/doc/isdnutils/examples/vboxgetty.conf
an example

.SH SEE ALSO
.B vboxgetty(8), vbox(5), vboxtcl(5)

.SH AUTHOR
This manual page was written by Andreas Jellinghaus <aj@debian.org>,
for Debian GNU/Linux and isdn4linux.
