/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* sql_yacc.y */

%{
#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex current_lex
#include "mysql_priv.h"
#include "sql_lex.h"
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

extern void yyerror(char*);
int yylex(void *yylval);

#define yyoverflow(A,B,C,D,E,F) if (my_yyoverflow((B),(D),(F))) { yyerror(A); return 2; }

%}
%union {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_num;
  char *str;
  Item *item;
  List<Item> *item_list;
  Key::Keytype key_type;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
}

%{
bool my_yyoverflow(short **a, YYSTYPE **b,int *yystacksize);
%}

%pure_parser					/* We have threads */

%token	END_OF_INPUT

%token	EQ
%token	GE
%token	GT_SYM
%token	LE
%token	LT
%token	NE
%token	IS

%token	AVG_SUM
%token	COUNT_SUM
%token	MAX_SUM
%token	MIN_SUM
%token	SUM_SUM
%token	STD_SUM

%token	ADD
%token	ALTER
%token	CHANGE
%token	CREATE
%token	CROSS
%token	CREATE_TABLE
%token	CREATE_INDEX
%token	DELETE_SYM
%token	DROP
%token	DROP_TABLE
%token	DROP_INDEX
%token	INSERT
%token	INSERT_SELECT
%token	SELECT_SYM
%token	SHOW
%token	UPDATE_SYM
%token	LOAD
%token	LOCK_SYM
%token	UNLOCK_SYM

%token	ACTION
%token	ALL
%token	AS
%token	DISTINCT
%token	STRAIGHT_JOIN

%token	AND
%token	ASC
%token	BIT_SYM
%token	BOTH
%token	BY
%token	CASCADE
%token	CHECK_SYM
%token	DATA_SYM
%token	DATABASES
%token	DEFAULT
%token	DESC
%token	DESCRIBE
%token	COLUMN_SYM
%token	COLUMNS
%token	ESCAPED
%token	ENCLOSED
%token	FOREIGN
%token	KEYS
%token	FULL
%token	FROM
%token	GRANT
%token	GROUP
%token	IGNORE_SYM
%token	INDEX
%token	INFILE
%token	INTO
%token	IN_SYM
%token	JOIN
%token	LEADING
%token	LONG_SYM
%token	LIKE
%token	LINES
%token	PARTIAL
%token	PRIVILEGES
%token	READ_SYM
%token	REGEXP
%token	RENAME
%token	RESTRICT
%token	REFERENCES
%token	MATCH
%token	NATURAL
%token	NO_SYM
%token	NOT
%token	NULL_SYM
%token	ON
%token	OPTION
%token	OPTIONALLY
%token	OR
%token	ORDER_SYM
%token	OUTER
%token	OUTFILE
%token	HAVING
%token	SET
%token	STARTING
%token	USING
%token	TABLES
%token	TABLE_SYM
%token	TERMINATED
%token	TRAILING
%token	TO_SYM
%token	VALUES
%token	USAGE
%token	USE_SYM
%token	WITH
%token	WRITE_SYM
%token	WHERE

%token	KEY_SYM
%token	PRIMARY_SYM
%token	UNIQUE_SYM
%token	AUTO_INC
%token	BINARY

%token	IDENT
%token	NUM
%token	LONG_NUM
%token	REAL_NUM
%token	TEXT_STRING
%token	HEX_NUM

%token	CHAR_SYM
%token	VARYING
%token	VARBINARY
%token	INT_SYM
%token	REAL
%token	SMALLINT
%token	BIGINT
%token	VARCHAR
%token	BLOB_SYM
%token	TEXT_SYM
%token	TINYBLOB
%token	TINYTEXT
%token	MEDIUMBLOB
%token	MEDIUMTEXT
%token	LONGBLOB
%token	LONGTEXT
%token	TIMESTAMP
%token	DATETIME
%token	DATE_SYM
%token	TIME_SYM
%token	TINYINT
%token	MEDIUMINT
%token	FLOAT_SYM
%token	DOUBLE_SYM
%token	DECIMAL_SYM
%token	NUMERIC_SYM
%token	ENUM
%token	ZEROFILL
%token	UNSIGNED
%token	PRECISION
%token	LIMIT

%token	ABS
%token	ACOS
%token	ASCII
%token	ASIN
%token	ATAN
%token	BETWEEN_SYM
%token	BIT_AND
%token	BIT_COUNT
%token	BIT_OR
%token	CEILING
%token	CONCAT
%token	COS
%token	COT
%token	CURDATE
%token	CURTIME
%token	DATABASE
%token  DATE_ADD_MM
%token  DATE_FORMAT_SYM
%token  DATE_ADD_INTERVAL
%token	DEGREES
%token  YEAR_SYM
%token  MONTH_SYM
%token  DAY_SYM
%token  HOUR_SYM
%token  MINUTE_SYM
%token  SECOND_SYM
%token  YEAR_MONTH_SYM
%token  DAY_HOUR_SYM
%token  DAY_MINUTE_SYM
%token  DAY_SECOND_SYM
%token  DAY_OF_WEEK
%token  HOUR_MINUTE_SYM
%token  HOUR_SECOND_SYM
%token  MINUTE_SECOND_SYM
%token	ELT_FUNC
%token	ENCRYPT
%token	EXP
%token	FIELD_FUNC
%token	FLOOR
%token	FOR_SYM
%token	FORMAT
%token	FROM_DAYS
%token	FROM_UNIXTIME
%token	GROUP_UNIQUE_USERS
%token	IF
%token	IFNULL
%token	INTERVAL_SYM
%token	INSTR
%token	ISNULL
%token	LAST_INSERT_ID
%token	LCASE
%token	LEFT
%token	LENGTH
%token	LOCATE
%token	LOG
%token	LOG10
%token	LTRIM
%token	MOD_SYM
%token	NOW_SYM
%token	PASSWORD
%token	PERIOD_ADD
%token	PERIOD_DIFF
%token	PI_SYM
%token	POSITION
%token	POW
%token	PROCEDURE
%token	RAND
%token	RADIANS
%token	REPEAT
%token	REPLACE
%token	REVERSE
%token	RIGHT
%token	ROUND
%token	RTRIM
%token	SEC_TO_TIME
%token	SIGN
%token	SIN
%token	SOUNDEX
%token  SPACE
%token	SQRT
%token	STRCMP
%token	SUBSTRING
%token	SUBSTRING_INDEX
%token	TAN
%token	TIME_TO_SEC
%token	TO_DAYS
%token	TRIM
%token	TRUNCATE
%token	UCASE
%token	UNIQUE_USERS
%token	UNIX_TIMESTAMP
%token	USER
%token	VERSION_SYM
%token	WEEKDAY

%token	SQL_BIG_TABLES
%token	SQL_BIG_SELECTS
%token	SQL_SELECT_LIMIT
%token  SQL_LOG_OFF

%left	OR
%left	AND
%left	BETWEEN_SYM
%left	EQ GE GT_SYM LE LT NE IS LIKE REGEXP IN_SYM
%left	'|'
%left	'&' 
%left	'-' '+'
%left	'*' '/' '%'
%left	NEG
%right	NOT

%type <str>
	IDENT TEXT_STRING REAL_NUM NUM LONG_NUM HEX_NUM remember_name remember_end
	SIDENT select_alias opt_len opt_ident ident

%type <string>
	text_string

%type <num>
	type int_type real_type opt_keyspec opt_field_type
	order_dir opt_field_spec opt_unique set_option lock_option

%type <ulong_num>
	ULONG_NUM

%type <ulonglong_num>
	ULONGLONG_NUM

%type <item>
	literal text_literal insert_ident group_ident order_ident
	simple_ident select_item2 expr sum_expr table_ident opt_default opt_pad
	no_in_expr expr_expr simple_expr no_and_expr interval using_list
	
%type <item_list>
	expr_list

%type <key_type>
	key_type

%type <key_part>
	key_part

%type <table_list>
	join_table_list join_table

%type <NONE>
	query verb_clause create select drop insert replace insert2
	insert_values update delete show describe load alter
	field_list field_list_item field_spec
	select_item_list select_item
	limit_clause fields values procedure_list procedure_item expr_list2
	opt_precision opt_ignore opt_column opt_restrict opt_null
	grant set lock unlock user_list string_list field_options field_option
	field_opt_list opt_binary table_lock_list table_lock keyword varchar
	references opt_on_delete opt_on_delete_list opt_on_delete_item use
	opt_outer table_list table opt_option
	END_OF_INPUT

%type <NONE>
	'-' '+' '*' '/' '%' '=' '<' '>' '[' ']' '(' ')'
	',' '!' ':' ';' '{' '}' '&' '|' AND OR BETWEEN_SYM
%%


query:
	END_OF_INPUT { send_error(&current_thd->net,ER_EMPTY_QUERY); }
	| verb_clause END_OF_INPUT { mysql_execute_command(); }

verb_clause:
	  create
	| select
	| drop
	| insert
	| replace
	| update
	| delete
	| show
	| describe
	| load
	| alter
	| grant
	| set
	| lock
	| unlock
	| use

/* create a table */

create:
	CREATE TABLE_SYM SIDENT
	  {
	    Lex->sql_command= SQL_CREATE_TABLE;
	    if (!add_table_to_list($3,NULL))
	      return 0;
	    Lex->col_list.empty();
	    Lex->change=NullS;
	  }
	  '(' field_list ')'
	| CREATE opt_unique INDEX ident ON SIDENT
	  {
	    Lex->sql_command= SQL_CREATE_INDEX;
	    Lex->unique_flag= (bool) $2;
	    Lex->col_list.empty();
	    if (!add_table_to_list($6,NULL))
	      return 0;
	    Lex->change=NullS;
	  }
	  '(' key_list ')'
	| CREATE DATABASE ident
	  {
	    Lex->sql_command=SQL_CREATE_DB;
	    Lex->name=$3;
	  }

field_list:
	  field_list_item
	| field_list ',' field_list_item


field_list_item:
	  field_spec
	| field_spec references
	  { 
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
	| key_type opt_ident '(' key_list ')'
	  { 
	    current_thd->key_list.push_back(new Key($1,$2,Lex->col_list));
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
	| FOREIGN KEY_SYM '(' key_list ')' references
	  { 
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
	| CHECK_SYM '(' expr ')'
	  {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }

field_spec:
	SIDENT { Lex->length=Lex->dec=0; Lex->type=0; Lex->interval=0;}
	type opt_default opt_field_type opt_keyspec
	{
	  if (add_field_to_list($1,
				(enum enum_field_types) $3,
				Lex->length,Lex->dec,Lex->type, $5, $6,
				$4,Lex->change,Lex->interval))
	    return 0;
	}

type:
	int_type opt_len field_options	{ Lex->length=$2; $$=$1; }
	| real_type opt_precision field_options { $$=$1; }
	| FLOAT_SYM float_options field_options { $$=FIELD_TYPE_FLOAT; }
	| BIT_SYM			{ Lex->length="1";
					  $$=FIELD_TYPE_STRING; }
	| CHAR_SYM '(' NUM ')' opt_binary	{ Lex->length=$3; 
					  $$=FIELD_TYPE_STRING; }
	| CHAR_SYM opt_binary		{ Lex->length="1"; 
					  $$=FIELD_TYPE_STRING; }
	| BINARY '(' NUM ')' 		{ Lex->length=$3;
					  Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_STRING; }
	| varchar '(' NUM ')' opt_binary { Lex->length=$3;
					  $$=FIELD_TYPE_VAR_STRING; }
	| VARBINARY '(' NUM ')' 	{ Lex->length=$3;
					  Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_VAR_STRING; }
	| DATE_SYM			{ $$=FIELD_TYPE_DATE; }
	| TIME_SYM			{ $$=FIELD_TYPE_TIME; }
	| TIMESTAMP	 		{ $$=FIELD_TYPE_TIMESTAMP; }
	| TIMESTAMP '(' NUM ')'		{ Lex->length=$3;
					  $$=FIELD_TYPE_TIMESTAMP; }
	| DATETIME			{ $$=FIELD_TYPE_DATETIME; }
	| TINYBLOB			{ Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_TINY_BLOB; }
	| BLOB_SYM			{ Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_BLOB; }
	| MEDIUMBLOB			{ Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_MEDIUM_BLOB; }
	| LONGBLOB			{ Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_LONG_BLOB; }
	| LONG_SYM VARBINARY		{ Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_MEDIUM_BLOB; }
	| LONG_SYM varchar		{ $$=FIELD_TYPE_MEDIUM_BLOB; }
	| TINYTEXT			{ $$=FIELD_TYPE_TINY_BLOB; }
	| TEXT_SYM			{ $$=FIELD_TYPE_BLOB; }
	| MEDIUMTEXT			{ $$=FIELD_TYPE_MEDIUM_BLOB; }
	| DECIMAL_SYM '(' NUM ',' NUM ')' field_options
					{ Lex->length=$3; Lex->dec=$5;
					  $$=FIELD_TYPE_DECIMAL;}
	| NUMERIC_SYM '(' NUM ',' NUM ')' field_options
					{ Lex->length=$3; Lex->dec=$5;
					  $$=FIELD_TYPE_DECIMAL;}
	| ENUM {Lex->interval_list.empty();} '(' string_list ')'
	  {
	    Lex->interval=typelib(Lex->interval_list);
	    $$=FIELD_TYPE_ENUM;
	    Lex->interval_list.empty();		/* Alloced by sql_alloc */
	  }
	| SET { Lex->interval_list.empty();} '(' string_list ')'
	  {
	    Lex->interval=typelib(Lex->interval_list);
	    $$=FIELD_TYPE_SET;
	    Lex->interval_list.empty();		/* Alloced by sql_alloc */
	  }

varchar:
	CHAR_SYM VARYING {}
	| VARCHAR {}

int_type:
	INT_SYM		{ $$=FIELD_TYPE_LONG; }
	| TINYINT	{ $$=FIELD_TYPE_TINY; }
	| SMALLINT	{ $$=FIELD_TYPE_SHORT; }
	| MEDIUMINT	{ $$=FIELD_TYPE_INT24; }
	| BIGINT	{ $$=FIELD_TYPE_LONGLONG; }

real_type:
	REAL		{ $$=FIELD_TYPE_DOUBLE; }
	| DOUBLE_SYM	{ $$=FIELD_TYPE_DOUBLE; }
	| DOUBLE_SYM PRECISION { $$=FIELD_TYPE_DOUBLE; }


float_options:
	/* empty */		{}
	| '(' NUM ')'		{ Lex->length=$2; }
	| '(' NUM ',' NUM ')'	{ Lex->length=$2; Lex->dec=$4; }

field_options:
	/* empty */		{}
	| field_opt_list	{}

field_opt_list:
	field_opt_list field_option {}
	| field_option {}

field_option:
	UNSIGNED	{ Lex->type|= UNSIGNED_FLAG;}
	| ZEROFILL	{ Lex->type|= UNSIGNED_FLAG | ZEROFILL_FLAG; }

opt_len:
	/* empty */	{ $$=(char*) 0; }	/* use default length */
	| '(' NUM ')'	{ $$=$2; }

opt_precision:
	/* empty */	{}
	| '(' NUM ',' NUM ')'	{ Lex->length=$2; Lex->dec=$4; }

opt_default:
	/* empty */	  { $$ = 0; }
	| opt_null	  { $$ = 0; }
	| opt_null DEFAULT literal { $$ = $3;}
	| DEFAULT literal { $$ = $2;}
	| DEFAULT literal opt_null  { $$ = $2; }

opt_null:
	NULL_SYM	 {}
	| NOT NULL_SYM { Lex->type|= NOT_NULL_FLAG; }

opt_binary:
	/* empty */	{}
	| BINARY	{ Lex->type|=BINARY_FLAG; }

opt_keyspec:					/* This is to emualate mysql */
	/* empty */	{ $$= 0; }
	| PRIMARY_SYM KEY_SYM { $$= PRI_KEY_FLAG; }

references:
	REFERENCES SIDENT opt_on_delete {}
	| REFERENCES SIDENT '(' key_list ')' opt_on_delete
	  { 
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }

opt_on_delete:
	/* empty */ {}
	| opt_on_delete_list {}

opt_on_delete_list:
	opt_on_delete_list opt_on_delete_item {}
	| opt_on_delete_item {}


opt_on_delete_item:
	ON DELETE_SYM delete_option {}
	| ON UPDATE_SYM delete_option {}
	| MATCH FULL	{}
	| MATCH PARTIAL {}

delete_option:
	RESTRICT	 {}
	| CASCADE	 {}
	| SET NULL_SYM {}
	| NO_SYM ACTION {}
	| SET DEFAULT {}

key_type:
	PRIMARY_SYM KEY_SYM { $$=Key::PRIMARY; }
	| key_or_index	   { $$=Key::MULTIPLE; }
	| UNIQUE_SYM	   { $$=Key::UNIQUE; }

key_or_index:
	KEY_SYM {}
	| INDEX {}
	
opt_field_type:	
	/* empty */	{ $$= 0; }
	| AUTO_INC	{ $$= Field::NEXT_NUMBER; }

opt_unique:	
	/* empty */	{ $$= 0; }
	| UNIQUE_SYM	{ $$= 1; }

key_list:
	key_list ',' key_part order_dir { Lex->col_list.push_back($3); }
	| key_part order_dir		{ Lex->col_list.push_back($1); }

key_part:
	ident 			{ $$=new key_part_spec($1); }
	| ident '(' NUM ')'	{ $$=new key_part_spec($1,(uint) atoi($3)); }

opt_ident:
	/* empty */	{ $$=(char*) 0; }	/* Defaultlength */
	| ident		{ $$=$1; }

string_list:
	text_string			{ Lex->interval_list.push_back($1); }
	| string_list ',' text_string	{ Lex->interval_list.push_back($3); }

/*
** Alter table
*/

alter:
	ALTER opt_ignore TABLE_SYM SIDENT
	{
	   Lex->sql_command = SQL_ALTER_TABLE;
	   Lex->name=0;
	   if (!add_table_to_list($4,NULL))
	     return 0;
	   Lex->drop_primary=0;
	   Lex->col_list.empty();
	   Lex->drop_list.empty();
	   Lex->alter_list.empty();
	}
	alter_list

alter_list:
	  alter_list_item
	| alter_list ',' alter_list_item


alter_list_item:
	ADD opt_column { Lex->change=0;} field_list_item
	| CHANGE opt_column ident { Lex->change= $3; } field_spec
	| DROP opt_column ident opt_restrict
	  { Lex->drop_list.push_back(new Alter_drop(Alter_drop::COLUMN,
						    $3)); }
	| DROP PRIMARY_SYM KEY_SYM { Lex->drop_primary=1; }
	| DROP FOREIGN KEY_SYM opt_ident {}
	| DROP key_or_index ident
	  { Lex->drop_list.push_back(new Alter_drop(Alter_drop::KEY,
						    $3)); }
	| ALTER opt_column ident SET DEFAULT literal
	  { Lex->alter_list.push_back(new Alter_column($3,$6)); }
	| ALTER opt_column ident DROP DEFAULT
	  { Lex->alter_list.push_back(new Alter_column($3,(Item*) 0)); }
	| RENAME table_alias ident
	  { Lex->name=$3; }

opt_column:
	/* empty */	{}
	| COLUMN_SYM	{}

opt_ignore:
	/* empty */	{ Lex->duplicates=DUP_ERROR; }
	| IGNORE_SYM	{ Lex->duplicates=DUP_IGNORE; }

opt_restrict:
	/* empty */	{}
	| RESTRICT	{}
	| CASCADE	{}

/*
** Select : retrieve data from table
*/


select:
	SELECT_SYM
	{
	  LEX *lex=Lex;
	  lex->where=lex->having=0;
	  lex->select_limit=current_thd->default_select_limit;
	  lex->offset_limit=0L;
	  lex->options=0;
	  lex->sql_command= SQL_SELECT;
	  Lex->exchange = 0;
	}
	select_options select_item_list select_into

select_into:
	/* empty */
	| select_from
	| opt_into select_from
	| select_from opt_into

select_from:
	FROM join_table_list where_clause group_clause having_clause order_clause limit_clause procedure_clause


select_options:
	  opt_straight_join opt_distinct 

opt_straight_join:
	/* empty */
	| STRAIGHT_JOIN { Lex->options|= SELECT_STRAIGHT_JOIN; }

opt_distinct:
	/* empty */
	| ALL
	| DISTINCT	{ Lex->options|= SELECT_DISTINCT; }

select_item_list:
	  select_item_list ',' select_item
	| select_item
	| '*'
	  {
	    if (add_item_to_list(new Item_field(NULL,"*")))
	      return 0;
	  }


select_item:
	  remember_name select_item2 remember_end select_alias
	  {
	    if (add_item_to_list($2))
	      return 0;
	    if ($4)
	      $2->set_name($4);
	    else if (!$2->name)
	      $2->set_name($1,(uint) ($3 - $1));
	  }

remember_name:
	{ $$=(char*) Lex->tok_start; }

remember_end:
	{ $$=(char*) Lex->tok_end; }

select_item2:
	table_ident	{ $$=$1; } /* table.* */
	| expr		{ $$=$1; }

select_alias:
	{ $$=0;}
	| AS ident { $$=$2; }
	| AS TEXT_STRING  { $$=$2; }

/* all possible expressions */
expr:	expr_expr	{$$ = $1; }
	| simple_expr	{$$ = $1; }

/* expressions that begin with 'expr' */
expr_expr:
	expr IN_SYM '(' expr_list ')'
	  { $$= new Item_func_in($1,*$4); }
	| expr NOT IN_SYM '(' expr_list ')'
	  { $$= new Item_func_not(new Item_func_in($1,*$5)); }
	| expr BETWEEN_SYM no_and_expr AND expr
	  { $$= new Item_func_between($1,$3,$5); }
	| expr NOT BETWEEN_SYM no_and_expr AND expr
	  { $$= new Item_func_not(new Item_func_between($1,$4,$6)); }
	| expr OR expr		{ $$= new Item_cond_or($1,$3); }
	| expr AND expr		{ $$= new Item_cond_and($1,$3); }
	| expr LIKE expr	{ $$= new Item_func_like($1,$3); }
	| expr NOT LIKE expr	{ $$= new Item_func_not(new Item_func_like($1,$4)); }
	| expr REGEXP text_literal { $$= new Item_func_regex($1,$3); }
	| expr NOT REGEXP text_literal { $$= new Item_func_not(new Item_func_regex($1,$4)); }
	| expr IS NULL_SYM	{ $$= new Item_func_isnull($1); }
	| expr IS NOT NULL_SYM { $$= new Item_func_isnotnull($1); }
	| expr EQ expr		{ $$= new Item_func_eq($1,$3); }
	| expr GE expr		{ $$= new Item_func_ge($1,$3); }
	| expr GT_SYM expr	{ $$= new Item_func_gt($1,$3); }
	| expr LE expr		{ $$= new Item_func_le($1,$3); }
	| expr LT expr		{ $$= new Item_func_lt($1,$3); }
	| expr NE expr		{ $$= new Item_func_ne($1,$3); }
	| expr '+' expr		{ $$= new Item_func_plus($1,$3); }
	| expr '-' expr		{ $$= new Item_func_minus($1,$3); }
	| expr '*' expr		{ $$= new Item_func_mul($1,$3); }
	| expr '/' expr		{ $$= new Item_func_div($1,$3); }
	| expr '|' expr		{ $$= new Item_func_bit_or($1,$3); }
	| expr '&' expr		{ $$= new Item_func_bit_and($1,$3); }
	| expr '%' expr		{ $$= new Item_func_mod($1,$3); }
	| '(' expr ')' 		{ $$= $2; }
	| '{' ident expr '}'	{ $$= $3; }

/* expressions that begin with 'expr' that do NOT follow IN_SYM */
no_in_expr:
	no_in_expr BETWEEN_SYM no_and_expr AND expr
	  { $$= new Item_func_between($1,$3,$5); }
	| no_in_expr NOT BETWEEN_SYM no_and_expr AND expr
	  { $$= new Item_func_not(new Item_func_between($1,$4,$6)); }
	| no_in_expr OR expr		{ $$= new Item_cond_or($1,$3); }
	| no_in_expr AND expr		{ $$= new Item_cond_and($1,$3); }
	| no_in_expr LIKE expr	{ $$= new Item_func_like($1,$3); }
	| no_in_expr NOT LIKE expr	{ $$= new Item_func_not(new Item_func_like($1,$4)); }
	| no_in_expr REGEXP text_literal { $$= new Item_func_regex($1,$3); }
	| no_in_expr NOT REGEXP text_literal { $$= new Item_func_not(new Item_func_regex($1,$4)); }
	| no_in_expr IS NULL_SYM	{ $$= new Item_func_isnull($1); }
	| no_in_expr IS NOT NULL_SYM { $$= new Item_func_isnotnull($1); }
	| no_in_expr EQ expr		{ $$= new Item_func_eq($1,$3); }
	| no_in_expr GE expr		{ $$= new Item_func_ge($1,$3); }
	| no_in_expr GT_SYM expr	{ $$= new Item_func_gt($1,$3); }
	| no_in_expr LE expr		{ $$= new Item_func_le($1,$3); }
	| no_in_expr LT expr		{ $$= new Item_func_lt($1,$3); }
	| no_in_expr NE expr		{ $$= new Item_func_ne($1,$3); }
	| no_in_expr '+' expr		{ $$= new Item_func_plus($1,$3); }
	| no_in_expr '-' expr		{ $$= new Item_func_minus($1,$3); }
	| no_in_expr '*' expr		{ $$= new Item_func_mul($1,$3); }
	| no_in_expr '/' expr		{ $$= new Item_func_div($1,$3); }
	| no_in_expr '|' expr		{ $$= new Item_func_bit_or($1,$3); }
	| no_in_expr '&' expr		{ $$= new Item_func_bit_and($1,$3); }
	| no_in_expr '%' expr		{ $$= new Item_func_mod($1,$3); }
	| '(' expr ')'	 		{ $$= $2; }
	| '{' ident expr '}'		{ $$= $3; }
	| simple_expr

/* expressions that begin with 'expr' that does NOT follow AND */
no_and_expr:
	no_and_expr IN_SYM '(' expr_list ')'
	{ $$= new Item_func_in($1,*$4); }
	| no_and_expr NOT IN_SYM '(' expr_list ')'
	  { $$= new Item_func_not(new Item_func_in($1,*$5)); }
	| no_and_expr BETWEEN_SYM no_and_expr AND expr
	  { $$= new Item_func_between($1,$3,$5); }
	| no_and_expr NOT BETWEEN_SYM no_and_expr AND expr
	  { $$= new Item_func_not(new Item_func_between($1,$4,$6)); }
	| no_and_expr OR expr		{ $$= new Item_cond_or($1,$3); }
	| no_and_expr LIKE expr	{ $$= new Item_func_like($1,$3); }
	| no_and_expr NOT LIKE expr	{ $$= new Item_func_not(new Item_func_like($1,$4)); }
	| no_and_expr REGEXP text_literal { $$= new Item_func_regex($1,$3); }
	| no_and_expr NOT REGEXP text_literal { $$= new Item_func_not(new Item_func_regex($1,$4)); }
	| no_and_expr IS NULL_SYM	{ $$= new Item_func_isnull($1); }
	| no_and_expr IS NOT NULL_SYM { $$= new Item_func_isnotnull($1); }
	| no_and_expr EQ expr		{ $$= new Item_func_eq($1,$3); }
	| no_and_expr GE expr		{ $$= new Item_func_ge($1,$3); }
	| no_and_expr GT_SYM expr	{ $$= new Item_func_gt($1,$3); }
	| no_and_expr LE expr		{ $$= new Item_func_le($1,$3); }
	| no_and_expr LT expr		{ $$= new Item_func_lt($1,$3); }
	| no_and_expr NE expr		{ $$= new Item_func_ne($1,$3); }
	| no_and_expr '+' expr		{ $$= new Item_func_plus($1,$3); }
	| no_and_expr '-' expr		{ $$= new Item_func_minus($1,$3); }
	| no_and_expr '*' expr		{ $$= new Item_func_mul($1,$3); }
	| no_and_expr '/' expr		{ $$= new Item_func_div($1,$3); }
	| no_and_expr '|' expr		{ $$= new Item_func_bit_or($1,$3); }
	| no_and_expr '&' expr		{ $$= new Item_func_bit_and($1,$3); }
	| no_and_expr '%' expr		{ $$= new Item_func_mod($1,$3); }
	| '(' expr ')'	 		{ $$= $2; }
	| '{' ident expr '}'		{ $$= $3; }
	| simple_expr

simple_expr:
	simple_ident		
	| literal
	| sum_expr
	| '-' expr %prec NEG	{ $$= new Item_func_neg($2); }
	| NOT expr %prec NEG	{ $$= new Item_func_not($2); }
	| '!' expr %prec NEG	{ $$= new Item_func_not($2); }
	| ABS '(' expr ')'	{ $$= new Item_func_abs($3); }
	| CEILING '(' expr ')'	{ $$= new Item_func_ceiling($3); }
	| FLOOR '(' expr ')'	{ $$= new Item_func_floor($3); }
	| ROUND '(' expr ')'	{ $$= new Item_func_round($3,
				      		new Item_int("0",0,1),0); }
	| ROUND '(' expr ',' expr ')' { $$= new Item_func_round($3,$5,0); }
	| TRUNCATE '(' expr ',' expr ')' { $$= new Item_func_round($3,$5,1); }
	| RAND '(' expr ')'	{ $$= new Item_func_rand($3); }
	| RAND '(' ')'		{ $$= new Item_func_rand(); }
	| EXP '(' expr ')'	{ $$= new Item_func_exp($3); }
	| LOG '(' expr ')'	{ $$= new Item_func_log($3); }
	| LOG10 '(' expr ')'	{ $$= new Item_func_log10($3); }
	| SQRT '(' expr ')'	{ $$= new Item_func_sqrt($3); }
	| POW '(' expr ',' expr ')'
	  { $$= new Item_func_pow($3,$5); }
	| SIGN '(' expr ')'	{ $$= new Item_func_sign($3); }
	| BIT_COUNT '(' expr ')' { $$=new Item_func_bit_count($3); }
	| MOD_SYM '(' expr ',' expr ')'
	  { $$= new Item_func_mod($3,$5); }
	| MIN_SUM '(' expr ',' expr_list ')'
	  { $5->push_front($3); $$= new Item_func_min(*$5); }
	| MAX_SUM '(' expr ',' expr_list ')'
	  { $5->push_front($3); $$= new Item_func_max(*$5); }
	| CONCAT '(' expr_list ')'
	  { $$= new Item_func_concat(* $3); }
	| REVERSE '(' expr ')'  { $$= new Item_func_reverse($3); }
	| REPLACE '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_replace($3,$5,$7); }
	| INSERT '(' expr ',' expr ',' expr ',' expr ')'
	  { $$= new Item_func_insert($3,$5,$7,$9); }
	| LCASE '(' expr ')'	  { $$= new Item_func_lcase($3); }
	| UCASE '(' expr ')'	  { $$= new Item_func_ucase($3); }
	| LENGTH '(' expr ')' 	  { $$= new Item_func_length($3); }
	| STRCMP '(' expr ',' expr ')'
	  { $$= new Item_func_strcmp($3,$5); }
	| LOCATE '(' expr ',' expr ')'
	  { $$= new Item_func_locate($5,$3); }
	| LOCATE '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_locate($5,$3,$7); }
	| INSTR '(' expr ',' expr ')'
	  { $$= new Item_func_locate($3,$5); }
	| POSITION '(' no_in_expr IN_SYM expr ')'
	  { $$ = new Item_func_locate($5,$3); }
	| LEFT '(' expr ',' expr ')'
	  { $$= new Item_func_left($3,$5); }
	| RIGHT '(' expr ',' expr ')'
	  { $$= new Item_func_right($3,$5); }
	| LTRIM '(' expr ')'
	  { $$= new Item_func_ltrim($3,new Item_string(" ",1)); }
	| RTRIM '(' expr ')'
	  { $$= new Item_func_rtrim($3,new Item_string(" ",1)); }
	| TRIM '(' expr ')'
	  { $$= new Item_func_trim($3,new Item_string(" ",1)); }
	| TRIM '(' LEADING opt_pad FROM expr ')'
	  { $$= new Item_func_ltrim($6,$4); }
	| TRIM '(' TRAILING opt_pad FROM expr ')'
	  { $$= new Item_func_rtrim($6,$4); }
	| TRIM '(' BOTH opt_pad FROM expr ')'
	  { $$= new Item_func_trim($6,$4); }
	| TRIM '(' expr FROM expr ')'
	  { $$= new Item_func_trim($5,$3); }

	| SOUNDEX '(' expr ')'
	  { $$= new Item_func_soundex($3); }
	| REPEAT '(' expr ',' expr ')'
	  { $$= new Item_func_repeat($3,$5); }
	| SPACE '(' expr ')'
	  { $$= new Item_func_repeat(new Item_string(" ",1),$3); }
	| SUBSTRING '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_substr($3,$5,$7); }
	| SUBSTRING '(' expr FROM expr FOR_SYM expr ')'
	  { $$= new Item_func_substr($3,$5,$7); }
	| SUBSTRING '(' expr FROM expr ')'
	  { $$= new Item_func_right($3,$5); }
	| SUBSTRING_INDEX '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_substr_index($3,$5,$7); }
	| PASSWORD '(' expr ')'   	  { $$= new Item_func_password($3); }
      	| ENCRYPT '(' expr ')'   	  { $$= new Item_func_encrypt($3); }
	| ENCRYPT '(' expr ',' expr ')'   { $$= new Item_func_encrypt($3,$5); }
	| INTERVAL_SYM '(' expr ',' expr_list ')'
	  { $$= new Item_func_interval($3,* $5); }
	| ELT_FUNC '(' expr ',' expr_list ')'
	  { $$= new Item_func_elt($3, *$5); }
	| FIELD_FUNC '(' expr ',' expr_list ')'
	  { $$= new Item_func_field($3, *$5); }
	| PERIOD_ADD '(' expr ',' expr ')'
	  { $$= new Item_func_period_add($3,$5); }
	| PERIOD_DIFF '(' expr ',' expr ')'
	  { $$= new Item_func_period_diff($3,$5); }
	| TO_DAYS '(' expr ')'
	  { $$= new Item_func_to_days($3); }
	| FROM_DAYS '(' expr ')'
	  { $$= new Item_func_from_days($3); }
	| FROM_UNIXTIME '(' expr ')'
	  { $$= new Item_func_from_unixtime($3); }
	| FROM_UNIXTIME '(' expr ',' expr ')'
	  { $$= new Item_func_date_format(new Item_func_from_unixtime($3),$5); }
	| WEEKDAY '(' expr ')'
	  { $$= new Item_func_weekday(new Item_func_to_days($3),0); }
	| DAY_OF_WEEK '(' expr ')'
	  { $$= new Item_func_weekday(new Item_func_to_days($3),1); }
	| CURDATE '(' ')'
	  { $$= new Item_func_curdate(); }
	| CURTIME '(' ')'
	  { $$= new Item_func_curtime(); }
	| CURTIME '(' expr ')'
	  { $$= new Item_func_curtime($3); }
	| NOW_SYM '(' ')'
	  { $$= new Item_func_now(); }
	| NOW_SYM '(' expr ')'
	  { $$= new Item_func_now($3); }
	| UNIX_TIMESTAMP '(' ')'
	  { $$= new Item_func_unix_timestamp(); }
	| UNIX_TIMESTAMP '(' expr ')'
	  { $$= new Item_func_unix_timestamp($3); }
	| SEC_TO_TIME '(' expr ')'
	  { $$= new Item_func_sec_to_time($3); } 
	| TIME_TO_SEC '(' expr ')'
	  { $$= new Item_func_time_to_sec($3); }
	| DATE_ADD_MM '(' expr ',' expr ')'
	  { $$= new Item_func_date_add_mm($3,$5); }
        | DATE_ADD_INTERVAL '(' expr ',' interval ')'
          { $$= new Item_date_add_interval($3,$5); }
	| USER '(' ')'
	  { $$= new Item_func_user(); }
	| DATABASE '(' ')'
	  { $$= new Item_func_database(); }
	| UNIQUE_USERS '(' text_literal ',' NUM ',' NUM ',' expr_list ')'
	  { $$= new Item_func_unique_users($3,atoi($5),atoi($7), * $9); }
	| ISNULL '(' expr ')'
	  { $$= new Item_func_isnull($3); }
	| IFNULL '(' expr ',' expr ')'
	  { $$= new Item_func_ifnull($3,$5); }
	| IF '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_if($3,$5,$7); }
	| FORMAT '(' expr ',' NUM ')'
	  { $$= new Item_func_format($3,atoi($5)); }
	| DATE_FORMAT_SYM '(' expr ',' expr ')'
	  { $$=new Item_func_date_format($3,$5); }
	| ASCII '(' expr ')'
	  { $$= new Item_func_ascii($3); }
	| CHAR_SYM '(' expr_list ')'
	  { $$= new Item_func_char(*$3); }
	| PI_SYM '(' ')'
	  { $$= new Item_real("PI()",M_PI,6,8); }
	| LAST_INSERT_ID '(' ')'
	  {
	    $$= new Item_int("last_insert_id()",
			     current_thd->insert_id(),21);
	  }
	| ACOS  '(' expr ')'
	  { $$= new Item_func_acos($3); }
	| ASIN  '(' expr ')'
	  { $$= new Item_func_asin($3); }
	| ATAN  '(' expr ')'
	  { $$= new Item_func_atan($3); }
	| ATAN  '(' expr ',' expr ')'
	  { $$= new Item_func_atan($3,$5); }
	| COS  '(' expr ')'
	  { $$= new Item_func_cos($3); }
	| SIN  '(' expr ')'
	  { $$= new Item_func_sin($3); }
	| TAN  '(' expr ')'
	  { $$= new Item_func_tan($3); }
	| COT  '(' expr ')'
	  { $$= new Item_func_div(new Item_int("1",1,1),
			          new Item_func_tan($3)); }
	| VERSION_SYM '(' ')'
	  { $$= new Item_string("version()",server_version,
				strlen(server_version)); }
	| DEGREES '(' expr ')'
	  { $$= new Item_func_units("degrees",$3,180/M_PI,0.0); }
	| RADIANS '(' expr ')'
	  { $$= new Item_func_units("radians",$3,M_PI/180,0.0); }

sum_expr:
	AVG_SUM '(' expr ')'
	  { $$=new Item_sum_avg($3); }
	| SUM_SUM '(' expr ')'
	  { $$=new Item_sum_sum($3); }
	| COUNT_SUM '(' '*' ')'
	  { $$=new Item_sum_count(new Item_int((int32) 0L,1)); }
	| COUNT_SUM '(' expr ')'
	  { $$=new Item_sum_count($3); }
	| MIN_SUM '(' expr ')'
	  { $$=new Item_sum_min($3); }
	| MAX_SUM '(' expr ')'
	  { $$=new Item_sum_max($3); }
	| GROUP_UNIQUE_USERS '(' text_literal ',' NUM ',' NUM ',' expr ')'
	  { $$= new Item_sum_unique_users($3,atoi($5),atoi($7),$9); }
	| STD_SUM '(' expr ')'
	  { $$=new Item_sum_std($3); }
	| BIT_OR  '(' expr ')'
	  { $$=new Item_sum_or($3); }
	| BIT_AND  '(' expr ')'
	  { $$=new Item_sum_and($3); }

expr_list:
	{ Lex->expr_list.push_front(new List<Item>); }
	expr_list2
	{ $$= Lex->expr_list.pop(); }

expr_list2:
	expr { Lex->expr_list.head()->push_back($1); }
	| expr_list2 ',' expr { Lex->expr_list.head()->push_back($3); }

opt_pad:
	/* empty */ { $$=new Item_string(" ",1); }
	| expr	    { $$=$1; }

join_table_list:
	'(' join_table_list ')'	{ $$=$2; }
	| join_table		{ $$=$1; }
	| join_table_list ',' join_table { $$=$3 }
	| join_table_list JOIN join_table { $$=$3 }
	| join_table_list CROSS JOIN join_table { $$=$4 }
	| join_table_list LEFT opt_outer JOIN join_table ON expr
	  { add_left_join_on($1,$5,$7); $$=$5; }
	| join_table_list LEFT opt_outer JOIN join_table
	  { Lex->table1=$1->name; Lex->table2=$5->name; }
	  USING '(' using_list ')'
	  { add_left_join_on($1,$5,$9); $$=$5; }
	| join_table_list NATURAL LEFT opt_outer JOIN join_table
	  { add_left_join_natural($1,$6); $$=$6; }

join_table:
        SIDENT
	  { if (!($$=add_table_to_list($1,NULL))) return 0; }
        | SIDENT table_alias ident
          { if (!($$=add_table_to_list($1, $3))) return 0; }
	| '{' ident join_table LEFT OUTER JOIN join_table ON expr '}'
	  { add_left_join_on($3,$7,$9); $$=$7; }

opt_outer:
	/* empty */	{}
	| OUTER		{}

using_list:
	ident
	  { if (!($$= new Item_func_eq(new Item_field(Lex->table1,$1),
				       new Item_field(Lex->table2,$1))))
	      return 0;
	  }
	| using_list ',' ident
	  {
	    if (!($$= new Item_cond_and(new Item_func_eq(new Item_field(Lex->table1,$3), new Item_field(Lex->table2,$3)), $1)))
	      return 0;
	  }

interval:
	INTERVAL_SYM expr YEAR_SYM { $$=new Item_interval($2,Item_interval::YEAR);}
	| INTERVAL_SYM expr MONTH_SYM { $$=new Item_interval($2,Item_interval::MONTH);}
	| INTERVAL_SYM expr DAY_SYM { $$=new Item_interval($2,Item_interval::DAY);}
	| INTERVAL_SYM expr HOUR_SYM { $$=new Item_interval($2,Item_interval::HOUR);}| INTERVAL_SYM expr MINUTE_SYM { $$=new Item_interval($2,Item_interval::MINUTE);}
	| INTERVAL_SYM expr SECOND_SYM { $$=new Item_interval($2,Item_interval::SECOND);}
	| INTERVAL_SYM expr YEAR_MONTH_SYM { $$=new Item_interval($2,Item_interval::YEAR_MONTH);}
	| INTERVAL_SYM expr DAY_HOUR_SYM { $$=new Item_interval($2,Item_interval::DAY_HOUR);}
	| INTERVAL_SYM expr DAY_MINUTE_SYM { $$=new Item_interval($2,Item_interval::DAY_MINUTE);}
	| INTERVAL_SYM expr DAY_SECOND_SYM { $$=new Item_interval($2,Item_interval::DAY_SECOND);}
	| INTERVAL_SYM expr HOUR_MINUTE_SYM { $$=new Item_interval($2,Item_interval::HOUR_MINUTE);}
	| INTERVAL_SYM expr HOUR_SECOND_SYM { $$=new Item_interval($2,Item_interval::HOUR_SECOND);}
	| INTERVAL_SYM expr MINUTE_SECOND_SYM { $$=new Item_interval($2,Item_interval::MINUTE_SECOND);}


table_alias:
	/* empty */
	| AS
	| EQ

where_clause:
	/* empty */  { Lex->where= 0; } 
	| WHERE expr { Lex->where= $2; }

having_clause:
	/* empty */
	| HAVING { Lex->create_refs=1; } expr
	{ Lex->having= $3; Lex->create_refs=0; }

/*
** group by statement in select
*/

group_clause:
	/* empty */
	| GROUP BY group_list

group_list:
	group_list ',' group_ident order_dir
		{ if (add_group_to_list($3,(bool) $4)) return 0; }
	| group_ident order_dir
		{ if (add_group_to_list($1,(bool) $2)) return 0; }

/*
** Order by statement in select
*/

order_clause:
	/* empty */
	| ORDER_SYM BY order_list

order_list:
	order_list ',' order_ident order_dir
	  { if (add_order_to_list($3,(bool) $4)) return 0; }
	| order_ident order_dir
	  { if (add_order_to_list($1,(bool) $2)) return 0; }

order_dir:
	/* empty */ { $$ =  1; }
	| ASC  { $$ =  1; }
	| DESC { $$ =  0; }


limit_clause:
	/* empty */
	{
	  Lex->select_limit= current_thd->default_select_limit;
	  Lex->offset_limit= 0L;
	}
	| LIMIT ULONG_NUM
	  { Lex->select_limit= $2; Lex->offset_limit=0L; }
	| LIMIT ULONG_NUM ',' ULONG_NUM
	  { Lex->select_limit= $4; Lex->offset_limit=$2; }

ULONG_NUM:
	NUM { $$= strtoul($1,NULL,10); }
	| REAL_NUM { $$= strtoul($1,NULL,10); }

ULONGLONG_NUM:
	NUM	   { $$= (ulonglong) strtoul($1,NULL,10); }
	| LONG_NUM { $$= strtoull($1,NULL,10); }
	| REAL_NUM { $$= strtoull($1,NULL,10); }

procedure_clause:
	/* empty */
	| PROCEDURE ident			/* Procedure name */
	  {
	    if (add_proc_to_list(new Item_field(NULL,$2)))
	      return 0;
	  }
	  '(' procedure_list ')'


procedure_list:
	procedure_list ',' procedure_item
	| procedure_item

procedure_item:
	  remember_name expr
	  {
	    if (add_proc_to_list($2))
	      return 0;
	    if (!$2->name)
	      $2->set_name($1,(uint) ((char*) Lex->tok_end - $1));
	  }

opt_into:
	INTO OUTFILE TEXT_STRING 
	{
	  if (!(Lex->exchange= new sql_exchange($3)))
	    return 0;
	}
	opt_field_term opt_line_term

/*
** Drop : delete tables or index
*/

drop:
	DROP TABLE_SYM table_list
	{
	  Lex->sql_command = SQL_DROP_TABLE;
	}
	| DROP INDEX ident {}
	  { Lex->sql_command= SQL_DROP_INDEX; }
	| DROP DATABASE ident
	  { Lex->sql_command= SQL_DROP_DB; Lex->name=$3; }

table_list:
	table
	| table_list ',' table

table:
	SIDENT { if (!add_table_to_list($1,NULL)) return 0; }

/*
** Insert : add new data to table
*/

insert: 
	INSERT { Lex->sql_command = SQL_INSERT; } insert2

replace: 
	REPLACE { Lex->sql_command = SQL_REPLACE; } insert2

insert2:
	INTO table
	{
	  current_thd->field_list.empty();
	}
	opt_field_spec insert_values

insert_values:
	VALUES '(' values ')' {}
	| SELECT_SYM
	  {
	    LEX *lex=Lex;
	    lex->where=lex->having=0;
	    lex->select_limit=current_thd->default_select_limit;
	    lex->offset_limit=0L;
	    lex->options=0;
	    lex->sql_command = (lex->sql_command == SQL_INSERT ?
		 		SQL_INSERT_SELECT : SQL_REPLACE_SELECT);
	  }
	  select_options select_item_list select_from {}

opt_field_spec:
	/* empty */	  { }
	| '(' fields ')'  { }

fields:
	fields ',' insert_ident	{ current_thd->field_list.push_back($3); }
	| insert_ident		{ current_thd->field_list.push_back($1); }


values:
	values ','  expr	{ if (add_value_to_list($3)) return 0; }
	| expr			{ if (add_value_to_list($1)) return 0; }


/* Update rows in a table */

update:
	UPDATE_SYM table SET update_list where_clause
	{ Lex->sql_command = SQL_UPDATE; }

update_list:
	update_list ',' simple_ident EQ expr
	{
	  if (add_item_to_list($3) || add_value_to_list($5))
	    return 0;
	}
	| simple_ident EQ expr
	  {
	    if (add_item_to_list($1) || add_value_to_list($3))
	      return 0;
	  }


/* Delete rows from a table */

delete:
	DELETE_SYM FROM table where_clause
	{ Lex->sql_command= SQL_DELETE; }


/* Show things */

show:	SHOW { Lex->wild=0;} show_param

show_param:
	DATABASES wild
	  { Lex->sql_command= SQL_SHOW_DATABASES; }
	| TABLES opt_db wild
	  { Lex->sql_command= SQL_SHOW_TABLES; }
	| COLUMNS FROM ident opt_db wild
	  {
	    Lex->sql_command= SQL_SHOW_FIELDS;
	    if (!add_table_to_list($3,NULL))
	      return 0;
	  }
	| KEYS FROM ident opt_db
	  {
	    Lex->sql_command= SQL_SHOW_KEYS;
	    if (!add_table_to_list($3,NULL))
	      return 0;
	  }
	| INDEX FROM ident opt_db
	  {
	    Lex->sql_command= SQL_SHOW_KEYS;
	    if (!add_table_to_list($3,NULL))
	      return 0;
	  }

opt_db:
	/*NULL */    { Lex->db = current_thd->db; }
	| FROM SIDENT { Lex->db = $2; }

wild:
	/* empty */
	| LIKE text_string { Lex->wild= $2; }

/* A Oracle compatible synonym for show */
describe:
	describe_command SIDENT
	{
	  Lex->wild=0;
	  Lex->sql_command=SQL_SHOW_FIELDS;
	  Lex->db=current_thd->db;
	  if (!add_table_to_list($2,NULL))
	    return 0;
	}
	opt_describe_column
	| describe_command select { Lex->options|= SELECT_DESCRIBE };


describe_command:
	DESC
	| DESCRIBE

opt_describe_column:
	/* empty */	{}
	| text_string	{ Lex->wild= $1; }
	| ident		{ Lex->wild= new String($1); }


/* change database */

use:	USE_SYM SIDENT	{ Lex->sql_command=SQL_CHANGE_DB; Lex->db=$2; }

/* import, export of files */

load:	LOAD DATA_SYM INFILE TEXT_STRING 
	{
	  Lex->sql_command= SQL_LOAD;
	  if (!(Lex->exchange= new sql_exchange($4)))
	    return 0;
	  current_thd->field_list.empty();
	}
	opt_duplicate INTO TABLE_SYM SIDENT opt_field_term opt_line_term
	opt_ignore_lines opt_field_spec
	{
	  if (!add_table_to_list($9,NULL))
	    return 0;
	}
	  
opt_duplicate:
	/* empty */	{ Lex->duplicates=DUP_ERROR; }
	| REPLACE	{ Lex->duplicates=DUP_REPLACE; }
	| IGNORE_SYM	{ Lex->duplicates=DUP_IGNORE; }

opt_field_term:
	/* empty */
	| COLUMNS field_term_list

field_term_list:
	field_term_list field_term
	| field_term

field_term:
	TERMINATED BY text_string { Lex->exchange->field_term= $3;}
	| OPTIONALLY ENCLOSED BY text_string
	  { Lex->exchange->enclosed= $4; Lex->exchange->opt_enclosed=1;}
	| ENCLOSED BY text_string { Lex->exchange->enclosed= $3;}
	| ESCAPED BY text_string  { Lex->exchange->escaped= $3;}

opt_line_term:
	/* empty */
	| LINES line_term_list

line_term_list:
	line_term_list line_term
	| line_term

line_term:
	TERMINATED BY text_string { Lex->exchange->line_term= $3;}
	| STARTING BY text_string { Lex->exchange->line_start= $3;}

opt_ignore_lines:
	/* empty */
	| IGNORE_SYM NUM LINES
	  { Lex->exchange->skip_lines=atol($2); }

/* Common definitions */

text_literal:
	TEXT_STRING { $$ = new Item_string((char*) $1,Lex->yytoklen); }

text_string:
	TEXT_STRING { $$=  new String($1,Lex->yytoklen); }

literal:
	text_literal	{ $$ =	$1; }
	| NUM		{ $$ =	new Item_int((int32) atol($1),Lex->yytoklen); }
	| LONG_NUM	{ $$ =	new Item_int($1); }
	| REAL_NUM	{ $$ =	new Item_real($1); }
	| NULL_SYM	{ $$ =	new Item_null();
		 	  Lex->next_state=STATE_OPERATOR_OR_IDENT;}
	| HEX_NUM	{ $$ =  new Item_varbinary((char*) $1,Lex->yytoklen); }
	| DATE_SYM text_literal { $$ = $2; }
	| TIME_SYM text_literal { $$ = $2; }
	| TIMESTAMP text_literal { $$ = $2; }

/**********************************************************************
** Createing different items.
**********************************************************************/

insert_ident:
	simple_ident	 { $$=$1; }
	| table_ident	 { $$=$1; }

table_ident:
	ident '.' '*'  { $$ = new Item_field($1,"*"); }
	| ident '.' ident '.' '*'  { $$ = new Item_field($3,"*"); }

group_ident:
	simple_ident   { $$=$1; }
	| NUM	       { $$ = new Item_int($1); }
	| text_literal { $$=$1; }

order_ident:
	simple_ident { $$=$1; }
	| NUM	     { $$ = new Item_int($1); }
	| text_literal { $$=$1; }

simple_ident:
	ident
	{ $$ = !Lex->create_refs ? (Item*) new Item_field(NULL,$1) : (Item*) new Item_ref(NULL,$1); }
	| ident '.' ident
	{ $$ = !Lex->create_refs ? (Item*) new Item_field($1,$3) : (Item*) new Item_ref($1,$3); }
	| '.' ident '.' ident
	{ $$ = !Lex->create_refs ? (Item*) new Item_field($2,$4) : (Item*) new Item_ref($2,$4); }
	| ident '.' ident '.' ident
	{ $$ = !Lex->create_refs ? (Item*) new Item_field($3,$5) : (Item*) new Item_ref($3,$5); }


SIDENT:
	ident	    { $$=$1;}
	| ident '.' ident { $$=$3;}		/* Skipp schema name */
	| '.' ident { $$=$2;}			/* For Delphi */

ident:  IDENT 	    { $$=$1; }
	| keyword
	{
	  LEX *lex=Lex;
	  $$=sql_strmake((char*) Lex->tok_start, (uint) (Lex->ptr -
							 Lex->tok_start));
	  Lex->next_state=STATE_OPERATOR_OR_IDENT;
	}

/* Keyword that we allow for identifiers */

keyword:
	TIME_SYM	{}
	| DATE_SYM	{}
	| TIMESTAMP	{}
	| TEXT_SYM	{}
	| BIT_SYM	{}
	| ENUM		{}
	| NO_SYM	{}
	| ACTION	{}
	| CHECK_SYM	{}
	| YEAR_SYM	{}
	| MONTH_SYM	{}
	| DAY_SYM	{}
	| HOUR_SYM	{}
	| MINUTE_SYM	{}
	| SECOND_SYM	{}


/* Option functions */

set:
	SET opt_option
	{
	  Lex->sql_command= SQL_SET_OPTION;
	  Lex->options=current_thd->options;
	  Lex->select_limit=current_thd->default_select_limit;
	}
	option_value_list

opt_option:
	/* empty */ {}
	| OPTION {}

option_value_list:
	option_value
	| option_value_list ',' option_value

option_value:
	set_option EQ NUM
	{
	  if (atoi($3) == 0)
	    Lex->options&= ~$1;
	  else
	    Lex->options|= $1;	    
	}
	| SQL_SELECT_LIMIT EQ ULONG_NUM
	{
	  Lex->select_limit= $3;
	}
	| TIMESTAMP EQ ULONG_NUM
	{
	  current_thd->set_time((time_t) $3);
	}
	| TIMESTAMP EQ DEFAULT
	{
	  current_thd->user_time=0;
	}
	| LAST_INSERT_ID EQ ULONGLONG_NUM
	{
	  current_thd->insert_id($3);
	}
	| CHAR_SYM SET IDENT
	{
	  CONVERT *tmp;
	  if (!(tmp=get_convert_set($3)))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET,MYF(0),$3);
	    return 0;
	  }
	  current_thd->convert_set=tmp;
	}
	| CHAR_SYM SET DEFAULT
	{
	  current_thd->convert_set=0;
	}
	
set_option:
	SQL_BIG_TABLES		{ $$= OPTION_BIG_TABLES; }
	| SQL_BIG_SELECTS	{ $$= OPTION_BIG_SELECTS; }
	| SQL_LOG_OFF		{ $$= OPTION_LOG_OFF; }

/* Lock function */

lock:
	LOCK_SYM table_or_tables
	{
	  Lex->sql_command=SQL_LOCK_TABLES;
	}
	table_lock_list

table_or_tables:
	TABLE_SYM
	| TABLES

table_lock_list:
	table_lock
	| table_lock_list ',' table_lock

table_lock:
	SIDENT lock_option
	{ if (!add_table_to_list($1,NULL,$2)) return 0; }
	| SIDENT table_alias ident lock_option
	  { if (!add_table_to_list($1, $3, $4)) return 0; }

lock_option:
	READ_SYM 	{ $$=0; }
	| WRITE_SYM	{ $$=1; }


unlock:
	UNLOCK_SYM table_or_tables { Lex->sql_command=SQL_UNLOCK_TABLES; }


/* Dummy functions */

grant:
	GRANT grant_privileges ON SIDENT TO_SYM user_list grant_option
	{
	  Lex->sql_command = SQL_GRANT;
	}

grant_privileges:
	grant_privilege_list
	| ALL PRIVILEGES
	| ALL

grant_privilege_list:
	grant_privilege
	| grant_privilege_list ',' grant_privilege

grant_privilege:
	| SELECT_SYM
	| INSERT opt_column_list
	| UPDATE_SYM opt_column_list
	| DELETE_SYM
	| REFERENCES opt_column_list
	| USAGE

user_list:
	ident {}
	| user_list ',' ident {}

opt_column_list:
	/* empty */ {}
	| '(' column_list ')' {}

column_list:
	ident {}
	| column_list ',' ident {}

grant_option:
	/* empty */ {}
	| WITH GRANT OPTION {}
