/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

#include "mysys_priv.h"

	/* Seek to position in file */
	/*ARGSUSED*/

ulong my_seek(File fd, ulong pos, int whence, myf MyFlags)
{
  reg1 off_t newpos;
  DBUG_ENTER("my_seek");
  DBUG_PRINT("my",("Fd: %d  Pos: %lu  Whence: %d  MyFlags: %d",
		   fd, pos, whence, MyFlags));
  newpos=lseek(fd, (off_t) pos, whence);
  if ((off_t) newpos == (off_t) -1)
  {
    my_errno=errno;
    DBUG_PRINT("error",("lseek: %lu, errno: %d",newpos,errno));
    DBUG_RETURN(MY_FILEPOS_ERROR);
  }
  DBUG_RETURN((ulong) newpos);
} /* my_seek */


	/* Tell current position of file */
	/* ARGSUSED */

ulong my_tell(File fd, myf MyFlags)
{
  off_t pos;
  DBUG_ENTER("my_tell");
  DBUG_PRINT("my",("Fd: %d  MyFlags: %d",fd, MyFlags));
#ifdef HAVE_TELL
  pos=tell(fd);
#else
  pos=lseek(fd, 0L, MY_SEEK_CUR);
#endif
  if (pos == (off_t) -1)
    my_errno=errno;
  DBUG_PRINT("exit",("pos: %lu",pos));
  DBUG_RETURN((ulong) pos);
} /* my_tell */
