/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */
/* Return error-text for system error messages and nisam messages */

#include <global.h>
#include <my_sys.h>
#include <m_string.h>
#include <errno.h>

static int get_options(int *argc,char **argv[]);
static void print_info(string progname,int version);
static char *get_ha_error_msg(int code);

typedef struct ha_errors {
  int errcode;
  char *msg;
} HA_ERRORS;

static int verbose=0,print_all_codes=0;
static char *progname;
static HA_ERRORS ha_errlist[]=
{
  { 120,"Didn't find key on read or update" },
  { 121,"Dupplicate key on write" },
  { 123,"Uppdate with is recoverable" },
  { 124,"Wrong index given to function" },
  { 126,"Indexfile is crashed / Wrong file format" },
  { 127,"Record-file is crashed" },
  { 131,"Command not suported by database" },
  { 132,"old databasfile" },
  { 133,"No record read before update" },
  { 134,"Record was already deleted (or record file crashed)" },
  { 135,"No more room in recordfile" },
  { 136,"No more room in indexfile" },
  { 137,"No more records (read after end of file)" },
  { 138,"Unsupported extension used for table" },
  { 0,NullS },
};

int main(int argc,char *argv[])
{
  int error,code,found;
  char *msg, *this_error;
  HA_ERRORS *ha_err_ptr;
  MY_INIT(argv[0]);

  if (get_options(&argc,&argv))
    exit(1);

  error=0;
#ifdef HAVE_SYS_ERRLIST
  if (print_all_codes)
  {
    for (code=1 ; code < sys_nerr ; code++)
    {
      if (sys_errlist[code][0])
      {						/* Skipp if no error-text */
	printf("%3d = %s\n",code,sys_errlist[code]);
      }
    }
    for (ha_err_ptr=ha_errlist ; ha_err_ptr->errcode ;ha_err_ptr++)
      printf("%3d = %s\n",ha_err_ptr->errcode,ha_err_ptr->msg);
  }
  else
#endif
  {
    for ( ; argc-- > 0 ; argv++)
    {
      found=0;
      code=atoi(*argv);
      msg = strerror(code);
      if (msg)
      {
	found=1;
	if (verbose)
	  printf("%3d = %s\n",code,msg);
	else
	  puts(msg);
      }
      if (!(msg=get_ha_error_msg(code)))
      {
	if (!found)
	{
	  fprintf(stderr,"Illegal error code: %d\n",code);
	  error=1;
	}
      }
      else
      {
	if (verbose)
	  printf("%3d = %s\n",code,msg);
	else
	  puts(msg);
      }
    }
  }
  exit(error);
  return error;
}


static int get_options(argc,argv)
register int *argc;
register char **argv[];
{
  int version,help;
  char *pos;

  progname= (*argv)[0];
  help=0;

  while (--*argc >0 && *(pos = *(++*argv)) == '-' ) {
    while (*++pos)
    {
      version=0;
      switch (*pos) {
#ifdef HAVE_SYS_ERRLIST
      case 'a':
	print_all_codes=1;
	break;
#endif
      case 'v':
      	verbose=1;
      	break;
      case 'V':
	version=1;
      case 'I':
      case '?':
	if (!help)
	{
	  print_info(progname,version);
	  help=1;
	}
	break;
      default:
	fprintf(stderr,"illegal option: -%c\n",*pos);
	return(1);
      }
    }
  }
  if (!*argc && ! help && ! print_all_codes)
    print_info(progname,0);
  return(*argc == 0 && ! print_all_codes);
} /* get_options */


	/* The actual jobb is done here */

static void print_info(name,version)
string name;
int version;
{
  printf("%s  Ver 1.3 for %s at %s\n",name,SYSTEM_TYPE,MACHINE_TYPE);
  puts("TCX Datakonsult AB, by Monty\n");
  if (version)
    return;
  puts("Prints error message for system error code and database error code");
  puts("");
#ifdef HAVE_SYS_ERRLIST
  printf("Usage: %s [-?avIV] [errorcodes]\n",name);
  puts("");

  puts("Options: -? or -I \"Info\"  -a \"all\" -v \"verbose\"  -V \"Version\"");
#else
  printf("Usage: %s [-?vIV] [errorcodes]\n",name);
  puts("");

  puts("Options: -? or -I \"Info\" -v \"verbose\"  -V \"Version\"");
#endif
  return;
}

static char *get_ha_error_msg(code)
int code;
{
  HA_ERRORS *ha_err_ptr;

  for (ha_err_ptr=ha_errlist ; ha_err_ptr->errcode ;ha_err_ptr++)
    if (ha_err_ptr->errcode == code)
      return ha_err_ptr->msg;
  return NullS;
}
