/* Copyright:  GPL */
/*
  Witten by joost witteveen;  
  read_pkginfo function by Tom Lees, run_menumethods by both.
  
  */

#include "update-menus.h"
#include <fstream.h>
#include <set>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <ctype.h>
#include <dirent.h>
#include <signal.h>
#include <syslog.h>
#include <errno.h>
#include <procbuf.h>

int debug=0, verbose=0;
set <String, less<String> > installed_packages;
set <String, less<String> > menufiles_processed;
translateinfo *transinfo;
configinfo     config;

DIR *open_dir_check(String dirname){
  struct stat st;
  dirname+='\0';
  stat (&(dirname[0]), &st);
  if (!S_ISDIR (st.st_mode))
    throw dir_error_read(&(dirname[0]));

  return opendir (&(dirname[0]));
}
bool executable(const char *s){
  struct stat st;
  stat (s, &st);
  return (((st.st_mode & S_IXOTH) || 
	   ((st.st_mode & S_IXGRP) && st.st_gid == getegid ()) || 
	   ((st.st_mode & S_IXUSR) && st.st_uid == geteuid ())) && 
	  (S_ISREG(st.st_mode) || S_ISLNK(st.st_mode)));
}

/////////////////////////////////////////////////////
//  menuentry:
//

bool menuentry::test_installed(String filename){
  if(filename.contains("local.",0))
    return true;
  else
    return installed_packages.find(filename)!=installed_packages.end();
}

bool menuentry::check_install(parsestream &i){
  String name, val;

  name=i.get_name();
  if(name!=COND_PACKAGE)
    throw unknown_cond_package(&i);
  i.skip_char('(');
  val=i.get_name();
  if(!test_installed(val)){
    i.skip_line();
    throw cond_inst_false();
  }
  i.skip_char(')');
  return true;
}
menuentry::menuentry(parsestream &i, const String &filename){
  char c;
  c=i.get_char();
  if(c=='?'){
    String name, val;
    //new format menuentry
    
    //read available info
    check_install(i);
    i.skip_space();
    i.skip_char(':');
    //read menuentry:
    try{
      do{
	name=i.get_name();
	val=i.get_eq_Stringconst();
	data[name]=val;
	c=i.get_char();
	i.put_back(c);
      }while(c);
    }
    catch(endofline){};
    i.skip_line();
  }else{
    //old format menuentry
    if(!test_installed(filename)){
      i.skip_line();
      throw cond_inst_false();
    }
    i.put_back(c);
    data[NEEDS_VAR]  =i.get_Stringconst();
    data[SECTION_VAR]=i.get_Stringconst();
    i.get_Stringconst(); //id is unused
    data[ICON_VAR]   =i.get_Stringconst();
    data[TITLE_VAR]  =i.get_Stringconst();
    i.skip_space();
    data[COMMAND_VAR]=i.get_line();
  }
}

void menuentry::output(vector<String> &s){
  String t;
  map<String, String, less<String> >::iterator i;
  if((i=data.begin())!=data.end())
    while (true){
      t+=String((*i).first) + "=\"" + 
	 escape_String((*i).second,"\"\n") + "\"";
      i++;
      if(i==data.end()){
	break;
      } else
	t+=" ";
    }
  t+="\n";
  config.report(String("ADDING")+t,configinfo::report_debug);
  s.push_back(t);
}
void menuentry::output_compat(vector<String> &s){
  String t,icon;
  icon=data[ICON_VAR];
  if(icon=="")
    icon="none";
  t=data[NEEDS_VAR]  +" "
   +data[SECTION_VAR]+" id"
   +cppesc_String(data[TITLE_VAR])+" "  
   +icon   +" \""
   +data[TITLE_VAR]  +"\" "
   +escape_String(data[COMMAND_VAR],"\n")+"\n";
  config.report(String("ADDING")+t,configinfo::report_debug);
  s.push_back(t);
}
ostream &menuentry::debugoutput(ostream &o){
  map<String, String, less<String> >::iterator i;

  o<<"MENUENTRY:"<<endl;
  for(i=data.begin(); i!=data.end(); i++)
    o<<"  data["<<(*i).first<<"]="<<(*i).second<<endl;
  return o;
}

/////////////////////////////////////////////////////
//  configinfo
//
configinfo::configinfo(){
  verbosity=report_normal;
  method=method_stderr;
}
void configinfo::parse_def(const String &var, parsestream &p){
  String s;
  s=p.get_Stringconst();
  if(var=="verbosity"){
    if     (s=="quiet")   verbosity=report_quiet;
    else if(s=="normal")  verbosity=report_normal;
    else if(s=="verbose") verbosity=report_verbose;
    else if(s=="debug")   verbosity=report_debug;
    else throw def_error();
  } else if(var=="method"){
    if     (s=="stdout")  method=method_stdout;
    else if(s=="stderr")  method=method_stderr;
    else if(s=="syslog") { 
      method=method_syslog;
      String facility;
      String priority;
      facility=p.get_Stringconst();
      p.skip_char('.');
      priority=p.get_Stringconst();
           if(facility=="auth")       syslog_facility=LOG_AUTH;
      else if(facility=="authpriv")   syslog_facility=LOG_AUTHPRIV;
      else if(facility=="authcron")   syslog_facility=LOG_CRON;
      else if(facility=="authdaemon") syslog_facility=LOG_AUTHPRIV;
      else if(facility=="authkern")   syslog_facility=LOG_KERN;
      else if(facility=="authlocal0") syslog_facility=LOG_LOCAL0;
      else if(facility=="authlocal1") syslog_facility=LOG_LOCAL1;
      else if(facility=="authlocal2") syslog_facility=LOG_LOCAL2;
      else if(facility=="authlocal3") syslog_facility=LOG_LOCAL3;
      else if(facility=="authlocal4") syslog_facility=LOG_LOCAL4;
      else if(facility=="authlocal5") syslog_facility=LOG_LOCAL5;
      else if(facility=="authlocal6") syslog_facility=LOG_LOCAL6;
      else if(facility=="authlocal7") syslog_facility=LOG_LOCAL7;
      else if(facility=="authlpr")    syslog_facility=LOG_LPR;
      else if(facility=="authmail")   syslog_facility=LOG_MAIL;
      else if(facility=="authnews")   syslog_facility=LOG_NEWS;
      else if(facility=="authsyslog") syslog_facility=LOG_SYSLOG;
      else if(facility=="authuser")   syslog_facility=LOG_USER;
      else if(facility=="authuucp")   syslog_facility=LOG_UUCP;
      else throw def_error();

	   if(priority=="emerg")      syslog_priority=LOG_EMERG;
      else if(priority=="alert")      syslog_priority=LOG_ALERT;
      else if(priority=="crit")       syslog_priority=LOG_CRIT;
      else if(priority=="err")        syslog_priority=LOG_ERR;
      else if(priority=="warning")    syslog_priority=LOG_WARNING;
      else if(priority=="notice")     syslog_priority=LOG_NOTICE;
      else if(priority=="info")       syslog_priority=LOG_INFO;
      else if(priority=="debug")      syslog_priority=LOG_DEBUG;
      else throw def_error();
    }
    else throw def_error();
  }
  else throw def_error();
}

void configinfo::update(String filename){
  parsestream p(filename);
  try{
    while(true){
      String var;
      var=p.get_name();
      p.skip_char('=');
      parse_def(var,p);
      p.skip_line();
    }
  } catch (endoffile){};
}
void configinfo::report(const String &message,
			verbosity_type v){
  if(v<=verbosity){
    switch(method){
    case method_stdout:
      cout<<message<<endl;
      break;
    case method_stderr:
      cerr<<message<<endl;
      break;
    case method_syslog:
      openlog("update-menus",LOG_PID,syslog_facility);
      syslog(syslog_priority,&(message[0]));
      closelog();
    }
  }
}
/////////////////////////////////////////////////////
//  translate stuff
//

trans_class::trans_class(const String &m,
			 const String &r,
			 const String &rv){
  match=m;
  replace=r;
  replace_var=rv;
}

bool  trans_class::check(String &s){
  config.report(String("checking ")+match+" < "+s,configinfo::report_debug);
  return match.contains(s,0);
}

ostream &trans_class::debuginfo(ostream &o){
  o<<", match="<<match<<", replace="<<replace<<", replace_var="<<replace_var;
  return o;
}

void translate::process( menuentry &m,
			const String &v){
  if(v==match)
    m.data[replace_var]=replace;
}
void subtranslate::process( menuentry &m,
			 const String &v){
  if(v.contains(match,0)){
    m.data[replace_var]=replace;
  }
}

void substitute::process( menuentry &m,
		   const String &v){
  String s,*t;
  if(v.contains(match,0)){
    t=&(m.data[replace_var]);
    if(t->length()>=replace.length())
      *t=replace+t->after((int)match.length()-1);
  }
}

void translateinfo::init(parsestream &i){
  String name, match, replace, match_var, replace_var;
  Regex ident("[a-zA-Z_][a-zA-Z0-9_]*");

    config.report(String("reading translate info in ")+i.filename(),
		    configinfo::report_verbose);
  try{
    name=i.get_name(ident);
    config.report(String("name=")+name,
		      configinfo::report_debug);
    i.skip_space();
    match_var=i.get_name(ident);
    config.report(String("match_var=")+match_var,
		    configinfo::report_debug);
    i.skip_space();
    i.skip_char('-');
    i.skip_char('>');
    i.skip_space();
    replace_var=i.get_name(ident);
    i.skip_line();
    while(true){
      pair<const String, trans_class *> p;

      i.skip_space();
      match=i.get_Stringconst();
      if(match==ENDTRANSLATE_TRANS){
	i.skip_line();
	break;
      }
      if(match[0]=='#'){
	i.skip_line();
	continue;
      }
      i.skip_space();
      replace=i.get_Stringconst();
      (String)p.first=match;
      if(name=TRANSLATE_TRANS)
	p.second=new translate(match,replace,replace_var);
      if(name=SUBTRANSLATE_TRANS)
	p.second=new subtranslate(match,replace,replace_var);
      if(name=SUBSTITUTE_TRANS)
	p.second=new substitute(match,replace,replace_var);
      trans[match_var].insert(p);
      i.skip_line();
    }
  }
  catch (endoffile){}
}

translateinfo::translateinfo(parsestream &i){
  init(i);
}
translateinfo::translateinfo(const String &filename){
  config.report(String("attempting to open ")+filename+".. ",
		configinfo::report_debug);
  parsestream ps(filename);

  init(ps);
}

void translateinfo::process(menuentry &m){
  map<String, trans_map, less<String> >::iterator i;
  trans_map::iterator j;
  String *match;
  for(i=trans.begin(); i!=trans.end(); i++){
    match=&m.data[(*i).first];
    j=(*i).second.upper_bound(*match);
    config.report(String("translate: var[")+*match+"]",
			 configinfo::report_debug);
    do{
      j--;
      (*j).second->process(m,*match);
    } while((*j).second->check(*match)&&
	    (j!=(*i).second.begin()));
    
  }
}
void translateinfo::debuginfo(){
  map<String, trans_map, less<String> >::iterator i;
  trans_map::iterator j;
  for(i=trans.begin(); i!=trans.end(); i++){
  config.report(String("TRANS: [")+(*i).first+"]",
		configinfo::report_debug);
    for(j=(*i).second.begin();
	j!=(*i).second.end();
	j++){
      config.report(String("key=")+(*j).first,configinfo::report_debug);
      (*j).second->debuginfo(cerr);
    }
  } 
}
/////////////////////////////////////////////////////
//  Installed Package Status:
//

void read_pkginfo (const char *statusfile)
  //this procedure written by Tom Lees, originally in pure C.
{
  FILE *status;
  char tmp[MAX_LINE], tmp2[MAX_LINE] = "", *s, *s2;
  int i;
  
  if(!(status = fopen (statusfile, "r")))
    throw ferror_read(statusfile);
  config.report(String("Reading installed packages..."),
		configinfo::report_verbose);
  while (!feof (status)){
    fgets (tmp, MAX_LINE, status);
    if (strlen (tmp) == 0)
      continue;
    if (tmp[strlen (tmp) - 1] == '\n')
      tmp[strlen (tmp) - 1] = '\0';
    for (i = strlen (tmp); i >= 0 && tmp[i] == ' '; i--) ;
    tmp[i] = '\0';
    for (s = tmp; *s == ' '; s++) ;
    if (strlen (s) == 0)
      continue;
    
    if (!strncmp (s, "Package: ", 9))
	strcpy (tmp2, s + 9);
    else if (!strncmp (s, "Status: ", 8) && strlen (tmp2) != 0) {
      for (s2 = s + 8; *s2 == ' '; s2++) ;
      for (; *s2 != ' ' && *s2 != '\0'; s2++) ;
      for (; *s2 == ' '; s2++) ;
      if (strncmp (s2, "ok ", 3))
	continue;
      for (s2 += 3; *s2 == ' '; s2++) ;
      if (!strcmp (s2, "installed"))
	installed_packages.insert(tmp2);
    }
  }
  fclose (status);
}

void read_menufile(const char *filename,
		   const String &shortfilename,
		   vector<String> &menudata,
		   vector<String> &menudata_compat){
  bool wrote_filename=false;
  parsestream *i;
  procbuf pr;
  istream *pipe_istr;

  config.report(String("Reading menuentryfile ")+filename,
		configinfo::report_debug);
  try{
    if(executable(filename)){
      pr.open(filename,ios::in);
      pipe_istr=new istream(&pr);
      i=new parsestream(*pipe_istr);
    }
    else
      i=new parsestream(filename);
    while(i->good()){
      try{
	menuentry m(*i,shortfilename);
	if(transinfo)
	  transinfo->process(m);
	if(!wrote_filename){
	  menudata.push_back(String("!F ") + filename + "\n");
	  wrote_filename=true;
	}
	m.output(menudata);
	m.output_compat(menudata_compat);
      }
      catch(cond_inst_false){}
    }
    if(executable(filename)){
      delete pipe_istr;
      pr.close();
    }
    delete i;
  }
  catch(endoffile p){}
}

void read_menufilesdir(const String &dirname,
		       vector<String> &menudata,
		       vector<String> &menudata_compat){
  
  struct stat st;
  DIR *dir;
  struct dirent *entry;
  String name;
  config.report(String("Reading menuentryfiles  in ")+dirname,
		configinfo::report_debug);
  dir=open_dir_check(dirname);
  while((entry=readdir(dir))){
    name=String(entry->d_name);
    if((name!="README")&&(name!="core")&&(name[0]!='.'))
      if(menufiles_processed.find(name)==menufiles_processed.end()){
	menufiles_processed.insert(name);
	name=dirname+name;
	stat(&(name[0]),&st);
	if(S_ISREG(st.st_mode)||S_ISLNK(st.st_mode))
	  read_menufile(&(name[0]),entry->d_name,
			menudata,menudata_compat);
      }
    
  }
}

void run_menumethod(char *methodname,
		    const vector<String> &menudata,
		    const vector<String> &menudata_compat){
  ifstream m(methodname);
  char s[MAX_LINE];
  const char *str;
  const vector<String> *md;
  FILE *p;
  unsigned int i;

  if(!m)
    throw ferror_read(methodname);

  m.get(s,sizeof(s));
  if(strncmp(s,MENU1_INSTALLER,strlen(MENU1_INSTALLER)))
    md=&menudata_compat;
  else
    md=&menudata;
  config.report(String("Udate-menus: Running method:")+methodname,
		configinfo::report_verbose);  
  strcat(methodname," -f --stdin ");
  if((p=popen(methodname, "w"))){
    signal(SIGPIPE,SIG_IGN);
    for(i=0;i!=md->size();i++){
      str=(*md)[i];
      write(fileno(p),str,strlen(str));
    }
    pclose(p);
    signal(SIGPIPE,SIG_DFL);
  }
}

void run_menumethoddir (const String &dirname,
			const vector<String> &menudata,
			const vector<String> &menudata_compat){
  struct stat st;
  DIR *dir;
  struct dirent *entry;
  char *s, tmp[MAX_LINE];

  config.report(String("running menu-methods in ")+dirname,
		configinfo::report_verbose);
  dir=open_dir_check(dirname);
  while ((entry = readdir (dir)) != NULL){
    if (!strcmp (entry->d_name, "README"))
      continue;
    for (s = entry->d_name; *s != '\0'; s++)
      if (!(isalnum (*s) || (*s == '_') || (*s == '-')))
	break;
    if (*s != '\0')
      continue;
    
    sprintf (tmp, "%s/%s", &(dirname[0]), entry->d_name);
    stat (tmp, &st);
    
    // Do we have execute permissions? 
    if (((st.st_mode & S_IXOTH) || 
	 ((st.st_mode & S_IXGRP) && st.st_gid == getegid ()) || 
	 ((st.st_mode & S_IXUSR) && st.st_uid == geteuid ())) && 
	(S_ISREG(st.st_mode) || S_ISLNK(st.st_mode)))
      run_menumethod(tmp,menudata,menudata_compat);
  }
  closedir (dir);
}

int kill_other_updatemenus(){

  struct stat st_other;
  struct stat st_self;
  String s,t;
  
  if(!getuid()){
    {
      ifstream f(UPMEN_LOCKFILE);
      if(!f){
	config.report(String("Update-menus: No other update-menus programme running. Good."),
		      configinfo::report_verbose);
	return 0;
      }
      parsestream p(f);
      p.set_filename(UPMEN_LOCKFILE);
      t=p.get_Stringconst();
    }
    s="/proc/"+t+"/exe";
    stat(&(s[0]),&st_other);
    s="/proc/"+itoString(getpid())+"/exe";
    stat(&(s[0]),&st_self);
    if((st_self.st_dev==st_other.st_dev)&&
       (st_self.st_ino==st_other.st_ino)){
      int other_pid=Stringtoi(t);
      config.report(String("Update-menus: another update-menus is running (pid=")
		    +itoString(other_pid)+"), killing it."
		    ,configinfo::report_verbose);
      kill(other_pid,SIGKILL);
      return 1;
    }else
      config.report(String("Update-menus: A process with same pid as in "
			   UPMEN_LOCKFILE
			   " is running, but appears to have different executable image. Ignoring it.")
		    ,configinfo::report_verbose);
  }
  return 0;
}

void create_lock(){
  
  if(!getuid()){
    ofstream of(UPMEN_LOCKFILE);
    of<<getpid();
    if(!of.good()){
      config.report("Update-menu: cannot write to lockfile "
		    UPMEN_LOCKFILE". Aborting.",
		    configinfo::report_normal);
      exit(1);
    }
  }
}

void remove_lock(){
  if(!getuid()){
    if(unlink(UPMEN_LOCKFILE))
      config.report("Update-menus: Cannot remove lockfile "UPMEN_LOCKFILE,
		    configinfo::report_normal);
  }
}

int check_dpkglock(){
  //return 1 if DPKG_LOCKFILE is locked
  int fd;
  struct flock fl;
  char buf[MAX_LINE];
  if(getuid()){
    if(verbose)
      cerr<<"update-menus run by user -- cannot determine if dpkg is locking"<<endl
	  <<DPKG_LOCKFILE<<": assuming there is no lock"<<endl;
    return 0;
  }
  fd=open(DPKG_LOCKFILE, O_RDWR|O_CREAT|O_TRUNC, 0660);
  if(fd==-1)
    return 1;
  fl.l_type= F_WRLCK;
  fl.l_whence= SEEK_SET;
  fl.l_start= 0;
  fl.l_len= 1;
  if (fcntl(fd,F_SETLK,&fl) == -1) {
    close(fd);
    if (errno == EWOULDBLOCK || errno == EAGAIN || errno == EACCES)
      return 1;
    cerr<<"update-menus: Thank you for installing this test version of the menu package."<<endl
	<<"update-menus: Unfortunately, I encountered an unknown errno (="
	<<errno<<")."<<endl
	<<"update-menus: Could you please be so kind as to email joostje@debian.org"<<endl
	<<"update-menus: the errno (="<<errno<<") with a discription of what you did to"<<endl
	<<"update-menus: trigger this. Thanks very much."<<endl
	<<"Press enter"<<endl;
    cin.get(buf,sizeof(buf));
    return 1;
  }
  fl.l_type= F_UNLCK;
  fl.l_whence= SEEK_SET;
  fl.l_start= 0;
  fl.l_len= 1;
  if (fcntl(fd,F_SETLK,&fl) == -1){
    cerr<<"update-menus: ?? Just locked the dpkg status database to see if another dpkg"<<endl
	<<"update-menus: Was running. Now I cannot unlock it! Aborting"<<endl;
    exit(1);
  }
  close(fd);
  return 0;
}

void wait_dpkg(){
  
  int child;
  int other;

  other=kill_other_updatemenus();

  if(check_dpkglock()){
    if((child=fork())){
      exit(0);
    }else{
      create_lock();
      if((!other)||verbose){
	cerr<<"Update-menus: waiting for dpkg to finish (forking to background)"<<endl
	    <<"Update-menus: (checking "DPKG_LOCKFILE")"<<endl;
      }
      while(check_dpkglock())
	sleep(2);
      if(debug)
	cerr<<"Update-menus: Dpkg lock on lockfile disapeared, generate menufiles"<<endl;
    }
  } else{
    create_lock();
    if(verbose)
      cerr<<"Update-menus: Dpkg not locking dpkg status area. Good."<<endl;
  }
}

void parse_params(char **argv){
  while(*(++argv)){
    if(String("-d")==*argv)
      config.set_verbosity(configinfo::report_debug);
    if(String("-v")==*argv)
      config.set_verbosity(configinfo::report_verbose);
    if(String("-h")==*argv){
      cerr<<"update-menus: update the various window-manager config files (and"<<endl
	  <<"  dwww, and pdmenu) after menuentry files were changed."<<endl
	  <<"Usage: update-menus [options] "<<endl
	  <<"    -v  be verbose about what is going on"<<endl
	  <<"    -d  debugging (loads of unintelligible output)"<<endl;
	exit(1);
    }
  }
}
void read_userconfiginfo(){
  //Because of gcc-2.7.2.1 internal compiler errors, had to split this up.
  //(well, not sure of the configinfo stuff, but translateinfo failed)
  if(getuid()){
    try{
      config.update(String(getenv("HOME"))+"/"+USERCONFIG);
    } catch(ferror_open d){};
  };
}
void read_rootconfiginfo(){
  if(!transinfo){
    try{
      config.update(CONFIG_FILE);
    }catch (ferror_open d){};
  }
}

void read_usertranslateinfo(){
  //Because of gcc-2.7.2.1 internal compiler errors, had to split this up.
  if(getuid()){
    try{
      transinfo=new translateinfo(String(getenv("HOME"))+"/"+USERTRANSLATE);
    } catch(ferror_open d){};
  };
}
void read_roottranslateinfo(){
  if(!transinfo){
    try{
      transinfo=new translateinfo(TRANSLATE_FILE);
    }catch (ferror_open d){};
  }
}
main (int, char **argv){
  vector<String> menudata, menudata_compat;
  String dummy;
  
  debug=0;
  try{
    //  read_userconfiginfo();
    read_rootconfiginfo();
    parse_params(argv);
    wait_dpkg();
    read_pkginfo(DPKG_STATUSFILE);
    transinfo=NULL;

    read_usertranslateinfo();
    read_roottranslateinfo();
    if(debug)
      transinfo->debuginfo();
    if(getuid()){
      try{
	read_menufilesdir(String(getenv("HOME"))+"/"+USERMENUS,
			  menudata, menudata_compat);
      }
      catch(dir_error_read d){dummy=d.name;};
    }
    
    read_menufilesdir(CONFIGMENUS, menudata, menudata_compat);
    read_menufilesdir(PACKAGEMENUS, menudata, menudata_compat);
    read_menufilesdir(MENUMENUS, menudata, menudata_compat);
    //menudata+='\0';
    //menudata_compat+='\0';

    if(getuid()){
      try{
	run_menumethoddir(String(getenv("HOME"))+"/"+USERMETHODS,
			  menudata,menudata_compat);
      }
      catch(dir_error_read d){
	dummy=d.name;
	run_menumethoddir(MENUMETHODS, menudata, menudata_compat);	
      }
    } else
      run_menumethoddir(MENUMETHODS, menudata, menudata_compat);
  }
  catch(endoffile p){        p.report(cerr); }
  catch(endofline p){        p.report(cerr); }
  catch(char_expected p){    p.report(cerr); }
  catch(char_unexpected p){  p.report(cerr); }
  catch(def_error p){        p.report(cerr); }

  catch(unknown_cond_package p){  p.report(cerr); }
  //  catch (ferror_read f){
  //    cerr<<"Cannot open file "<<f.name<<" for reading"<<endl;
  //  }
  //  catch (dir_error_read d){
  //    cerr<<"Cannot open directory "<<d.name<<" for reading"<<endl;
  //  }
  //catch (informed_fatal){
  //  cerr<<"Aborting."<<endl;
  //  }

  remove_lock();
}

