/*
 * lftp and utils
 *
 * Copyright (c) 1996-1997 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* this is not very useful, just a proof of concept */

#include <config.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "LocalAccess.h"
#include "ProtoList.h"
#include "xmalloc.h"
#include "xstring.h"
#include "misc.h"

void LocalAccess::ClassInit()
{
   new Protocol("file",LocalAccess::New);
}

void LocalAccess::Init()
{
   done=true;
   error_code=OK;
   stream=0;
   xfree(home);
   home=xstrdup(getenv("HOME"));
}

LocalAccess::LocalAccess() : FileAccess()
{
   Init();
}
LocalAccess::LocalAccess(const LocalAccess *o) : FileAccess((const FileAccess *)o)
{
   Init();
}
LocalAccess::~LocalAccess()
{
   if(stream)
      delete stream;
}

void LocalAccess::errno_handle()
{
   xfree(last_error_resp);
   last_error_resp=xstrdup(strerror(errno));
}

int LocalAccess::Done()
{
   if(error_code<0)
      return error_code;
   if(done)
      return OK;
   switch(mode)
   {
   case(CLOSED):
      return OK;
   case(CHANGE_DIR):
   case(REMOVE):
   case(REMOVE_DIR):
   case(MAKE_DIR):
   case(RENAME):
      return IN_PROGRESS;
   }
   return IN_PROGRESS;
}

int LocalAccess::Do()
{
   if(error_code<0)
      return STALL;
   int m=STALL;
   switch(mode)
   {
   case(CLOSED):
      return m;
   case(LONG_LIST):
      if(stream==0)
      {
	 char cmd[10+xstrlen(file)];
	 if(file)
	    sprintf(cmd,"ls -l %s",file);
	 else
	    sprintf(cmd,"ls -l");
	 InputFilter *f_stream=new InputFilter(cmd);
	 f_stream->SetCwd(cwd);
	 stream=f_stream;
	 real_pos=0;
	 m=MOVED;
      }
      if(stream->getfd()==-1)
      {
	 if(stream->error())
	 {
	    error_code=FATAL;
	    //FIXME
	    return MOVED;
	 }
	 block+=TimeOut(1000);
	 return m;
      }
      stream->Kill(SIGCONT);
      block+=PollVec(stream->getfd(),POLLIN);
      return m;
   case(CHANGE_DIR):
      if(access(file,X_OK)==-1)
      {
	 errno_handle();
	 error_code=NO_FILE;
      }
      else
      {
	 xfree(cwd);
	 cwd=xstrdup(file);
      }
      done=true;
      return MOVED;
   case(REMOVE):
      if(remove(dir_file(cwd,file))==-1)
      {
	 errno_handle();
	 error_code=NO_FILE;
      }
      done=true;
      return MOVED;
   case(REMOVE_DIR):
      if(rmdir(dir_file(cwd,file))==-1)
      {
	 errno_handle();
	 error_code=NO_FILE;
      }
      done=true;
      return MOVED;
   case(RENAME):
   {
      char *cwd_file1=xstrdup(dir_file(cwd,file1));
      if(rename(dir_file(cwd,file),cwd_file1)==-1)
      {
	 errno_handle();
	 error_code=NO_FILE;
      }
      xfree(cwd_file1);
      done=true;
      return MOVED;
   }
   case(MAKE_DIR):
      if(mkdir(dir_file(cwd,file),0755)==-1)
      {
	 errno_handle();
	 error_code=NO_FILE;
      }
      done=true;
      return MOVED;
   case(RETRIEVE):
      if(stream==0)
      {
	 stream=new FileStream(dir_file(cwd,file),O_RDONLY);
	 real_pos=-1;
	 m=MOVED;
      }
      if(stream->getfd()==-1)
      {
	 if(stream->error())
	 {
	    error_code=FATAL;
	    //FIXME
	    return MOVED;
	 }
	 block+=TimeOut(1000);
	 return m;
      }
      stream->Kill(SIGCONT);
      block+=PollVec(stream->getfd(),POLLIN);
      return m;
   case(STORE):
      return m;
   }
   return m;
}

int LocalAccess::Read(void *buf,int size)
{
   if(error_code<0)
      return error_code;
   if(stream==0)
      return DO_AGAIN;
   int fd=stream->getfd();
   if(fd==-1)
      return DO_AGAIN;
   if(real_pos==-1)
   {
      if(lseek(fd,pos,SEEK_SET)==-1)
	 real_pos=0;
      else
	 real_pos=pos;
   }
   stream->Kill(SIGCONT);
read_again:
   int res=Poll(fd,POLLIN);
   if(res&(POLLIN|POLLNVAL))
   {
      int res=read(fd,buf,size);
      if(res<0)
      {
	 saved_errno=errno;
	 return SEE_ERRNO;
      }
      if(res==0)
	 return res;
      real_pos+=res;
      if(real_pos<=pos)
	 goto read_again;
      int shift;
      if((shift=pos+res-real_pos)>0)
      {
	 memmove(buf,(char*)buf+shift,size-shift);
	 res-=shift;
      }
      pos+=res;
      return(res);
   }
   if(res)
   {
      // looks like eof
      return 0;
   }
   return DO_AGAIN;
}

int LocalAccess::Write(const void *buf,int size)
{
   if(error_code<0)
      return error_code;
   if(stream==0)
      return DO_AGAIN;
   int fd=stream->getfd();
   if(fd==-1)
      return DO_AGAIN;
   if(real_pos==-1)
   {
      if(lseek(fd,pos,SEEK_SET)==-1)
	 real_pos=0;
      else
	 real_pos=pos;
      if(real_pos<pos)
      {
	 error_code=STORE_FAILED;
	 return error_code;
      }
   }
   stream->Kill(SIGCONT);
   int res=Poll(fd,POLLOUT);
   if(res&(POLLOUT|POLLNVAL))
   {
      int res=write(fd,buf,size);
      if(res>=0)
	 return res;
      saved_errno=errno;
      return SEE_ERRNO;
   }

   return 0;
}

int LocalAccess::StoreStatus()
{
   if(error_code<0)
      return error_code;

   return OK;
}

void LocalAccess::Close()
{
   done=false;
   error_code=OK;
   if(stream)
   {
      delete stream;
      stream=0;
   }
   FileAccess::Close();
}

bool LocalAccess::SameLocationAs(FileAccess *fa,int)
{
   if(!SameProtoAs(fa))
      return false;
   LocalAccess *o=(LocalAccess*)fa;
   
   if(xstrcmp(home,o->home))
      return false;

   return !xstrcmp(cwd,o->cwd);
}
