unit SWVSKey;

interface

uses
	SwordAPI, SWKey, Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
	TSWVerseKey = class(TSWKey)
	private
	protected
		function GetTestament: integer;
          function GetBook: integer;
          function GetChapter: integer;
          function GetVerse: integer;
          procedure SetTestament(ival: integer);
          procedure SetBook(ival: integer);
          procedure SetChapter(ival: integer);
          procedure SetVerse(ival: integer);
		function  GetAutoNormalize: Boolean;
		procedure SetAutoNormalize(ival: Boolean);

	public
		constructor Create(AOwner:TComponent); override;
		property Testament: integer read GetTestament write SetTestament;
		property Book: integer read GetBook write SetBook;
		property Chapter: integer read GetChapter write SetChapter;
		property Verse: integer read GetVerse write SetVerse;
		property AutoNormalize: Boolean read GetAutoNormalize write SetAutoNormalize;
		procedure Normalize;
	published
	end;


procedure Register;

implementation


constructor TSWVerseKey.Create(AOwner:TComponent);
begin
	inherited Create(AOwner);
     KeyType := 'VerseKey';
end;


function TSWVerseKey.GetTestament: integer;
begin
	GetTestament := VerseKeyGetTestament(hswkey);
end;


function TSWVerseKey.GetBook: integer;
begin
	GetBook := VerseKeyGetBook(hswkey);
end;


function TSWVerseKey.GetChapter: integer;
begin
	GetChapter := VerseKeyGetChapter(hswkey);
end;


function TSWVerseKey.GetVerse: integer;
begin
	GetVerse := VerseKeyGetVerse(hswkey);
end;


procedure TSWVerseKey.SetTestament(ival: integer);
begin
	VerseKeySetTestament(hswkey, ival);
end;


procedure TSWVerseKey.SetBook(ival: integer);
begin
	VerseKeySetBook(hswkey, ival);
end;


procedure TSWVerseKey.SetChapter(ival: integer);
begin
	VerseKeySetChapter(hswkey, ival);
end;


procedure TSWVerseKey.SetVerse(ival: integer);
begin
	VerseKeySetVerse(hswkey, ival);
end;


function TSWVerseKey.GetAutoNormalize: Boolean;
begin
	GetAutoNormalize := Boolean(VerseKeyGetAutoNormalize(hswkey));
end;


procedure TSWVerseKey.SetAutoNormalize(ival: Boolean);
begin
	VerseKeySetAutoNormalize(hswkey, integer(ival));
end;


procedure TSWVerseKey.Normalize;
begin
	VerseKeyNormalize(hswkey);
end;


procedure Register;
begin
	RegisterComponents('SWORD', [TSWVerseKey]);
end;

end.
