/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  202, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* moon.strongswan.org */
  2, X'6d6f6f6e2e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* sun.strongswan.org */
  2, X'73756e2e7374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=sun.strongswan.org' */
  202, X'da9c6fa72dc33363ac09b99af29085bedd48dc27'
 );

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b53082029da003020102020100300d06092a864886f70d01010405003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303131303134355a170d3134303930383131303134355a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381af3081ac300f0603551d130101ff040530030101ff300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d010104050003820101009ad74e3e60592dfb9b21c78628bd76b63090c1720c74bf94753cad6fddadc9c776eb39d3bfaa52136bf528840078386308fcf79503bd3d1ad6c15ac38e10c846bff7888a03cfe7fa0e644b522b2af5aedf0bbc508dc48330a180757772771095059b2be148f58dc0c753b59e9d6bfb02e9b685a928a284531b187313fd2b835bc9ea27d0020739a8d485e88bdede9a45cde6d28ed553b0e8e92dabf877bed59abf9d151f15e4f2d00b5e6e49fcb665293d2296697926c2954dae367542ef6e98053e76d2728732f6ce69f284f0b856aa6c2823a9ee29b280a66f50828f9b5cf27f84feca3c31c24897db156c7a833768ab306f51286457a51f09dd53bbb4190f'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=sun.strongswan.org */
  1, 1, X'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');

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 5
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, CN=sun.strongswan.org' */
  1, X'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');

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 4
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 5
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_SUN', 'PH_IP_MOON'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, mobike
) VALUES (
  'net-net', 1, 4, 3, 0
);

INSERT INTO child_configs (
  name, updown
) VALUES (
  'net-net', 'ipsec _updown iptables'
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES (
  7, X'0a020000', X'0a02ffff'
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 0
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 1, 1
);

