/*
SMS Server Tools
Copyright (C) 2000 Stefan Frings

This program is free software unless you got it under another license directly
from the author. You can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software Foundation.
Either version 2 of the License, or (at your option) any later version.

http://www.isis.de/members/~s.frings
mailto:s.frings@mail.isis.de
*/

#include <stdio.h>

#ifndef EXTRAS_H
#define EXTRAS_H

/* Moves a file into another directory. Returns 1 if success. */

int movefile(const char* const filename, const char* const directory);


/* removes ctrl chars at the beginning and the end of the text and removes */
/* \r in the text. */

void cutspaces(char* const text);


/* Checks if the text contains only numbers. */

int is_number(const char* const text);


/* Gets the first file that is not locked in the directory. Returns 0 if 
   there is no file. Filename is the filename including the path. 
   Additionally it cheks if the file grows at the moment to prevent
   that two programs acces the file at the same time. */
   
int getfile(const char* const dir, char* const filename);


/* Replacement for system() wich can be breaked. See man page of system() */

int my_system(const char* const command);

/* Create and remove a PID file */

void write_pid(const char* filename);

void remove_pid(const char* filename);


// Other functions

void swapchars(char* string); /* Swaps every second character */

#endif
