/*
#ident	"@(#)smail/src:RELEASE-3_2_0_114:standalone.c,v 1.4 2000/05/04 04:08:47 woods Exp"
 */

#include <stdio.h>
#include <varargs.h>
#include <sys/types.h>

#include "smail.h"
#include "extern.h"

/*
 * get_local_year stub for get_local_year in sysdep.c
 */
int
get_local_year()
{
      return 1915;
}

/*
 * define panic, fatal and write_log here, rather than
 * using the external routines.  We are testing and just want
 * the information displayed, not logged.
 */
/*VARARGS2*/
void
panic(exitcode, fmt, va_alist)
    int exitcode;			/* call exit(exitcode) */
    char *fmt;				/* printf(3) format */
    va_dcl                              /* arguments for printf */
{
    va_list ap;

    va_start(ap);
    (void)fprintf(stderr, "PANIC(%d): ", exitcode);
    (void)vfprintf(stderr, fmt, ap);
    putc('\n', stderr);			/* fatal messages not \n terminated */
    va_end(ap);

    return_to_sender = TRUE;
    exit(exitcode);
}

/*VARARGS2*/
void
write_log(log, fmt, va_alist)
    int log;				/* TRUE if to write global log file */
    char *fmt;				/* printf(3) format */
    va_dcl                              /* arguments for printf */
{
    va_list ap;

    va_start(ap);
    (void)vfprintf(stderr, fmt, ap);
    putc('\n', stderr);
    va_end(ap);
}
