/*	SCCS Id: @(#)gnglyph.h	3.3	2000/07/16	*/
/* Copyright (C) 1998 by Erik Andersen <andersee@debian.org> */
/* NetHack may be freely redistributed.  See license for details. */

#ifndef GnomeHackGlyph_h
#define GnomeHackGlyph_h

#include "config.h"
#include "global.h"

/* the prototypes in system headers contain useless argument names
   that trigger spurious warnings if gcc's `-Wshadow' option is used */
#undef index
#define index _hide_index_
#define time  _hide_time_

#include <gdk_imlib.h>
#include <gdk/gdk.h>

#undef index
#define index strchr
#undef time


extern short glyph2tile[];     /* From tile.c */

typedef struct {
  GdkImlibImage* im;
  int            count;
  int            width;
  int            height;
} GHackGlyphs;

extern int            ghack_init_glyphs( const char *);
extern void           ghack_free_glyphs( void);
extern void           ghack_dispose_glyphs( void);
extern int            ghack_glyph_count( void);
extern GdkImlibImage* ghack_image_from_glyph( int, gboolean);
extern int            ghack_glyph_height( void);
extern int            ghack_glyph_width( void);

#if defined(FILE_AREAS)
#define TILESETDIR FILE_AREA_SHARE
#elif defined(HACKDIR)
#define TILESETDIR HACKDIR
#else
#   error HACKDIR is not defined!
#endif

#endif  /* GnomeHackGlyph_h */
