#include "qaudio-p.h"


QAuServer::QAuServer()
{
	nas = AuOpenServer(NULL, 0, NULL, 0, NULL, NULL);
	if (nas) {
		// Ask Qt for async messages...
		sn=new QSocketNotifier(AuServerConnectionNumber(nas),
			QSocketNotifier::Read);
		QObject::connect(sn, SIGNAL(activated(int)),
			this, SLOT(dataReceived()));
	}
}

QAuServer::~QAuServer()
{
	delete sn;
}

void QAuServer::play(const char* filename, double volume_percent)
{
	if (nas) {
		AuFixedPoint volume=AuFixedPointFromFraction(volume_percent, 100);
		// AuSoundPlaySynchronousFromFile(nas, filename, 50);
		AuSoundPlayFromFile(nas, filename, AuNone, volume, NULL, NULL, NULL, NULL, NULL, NULL);
		startTimer(0);
		//dataReceived();
	}
}

bool QAuServer::okay()
{
	return !!nas;
}

void QAuServer::timerEvent(QTimerEvent *)
{
	dataReceived();
	killTimers();
}

void QAuServer::dataReceived()
{
	AuHandleEvents(nas);
}

#include "qaudio-p.moc"
