
#include <stdio.h>
#include <stdarg.h>

#include "config.h"
#include "debug.h"


void OSI_DEBUG( const char *file, const char *function,
                const int line, char *message, ... )
{
#ifdef DEBUG
    va_list params;

    fprintf( stderr, "osiris[%s:%s: line(%d)]:", file, function, line );

    va_start( params, message );
    vfprintf( stderr, message, params );
    va_end( params );

    fprintf( stderr, "\n" );
#endif
}

