/*
 *  Copyright 2001-2005 Internet2
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cxxtest/TestSuite.h>

#include <saml/saml.h>

using namespace saml;
using namespace std;

class SAMLArtifactCreationTest : public CxxTest::TestSuite
{
public:
    string providerIdStr;
    string handle;
    void setUp() {
        if (handle.empty()) {
            providerIdStr = "https://idp.org/SAML";
            SAMLIdentifier::generateRandomBytes(handle,20);
        }
    }
    void testSAMLArtifactType0001(void) {
        TS_TRACE("artifact type 0x0001 (with random sourceId)");
        string sourceId;
        SAMLIdentifier::generateRandomBytes(sourceId,20);
        auto_ptr<SAMLArtifact> artifact1(new SAMLArtifactType0001(sourceId,handle));
        printResults(artifact1.get());

        TS_TRACE("artifact type 0x0001 (with computed sourceId)");
        sourceId = SAMLArtifactType0001::generateSourceId(providerIdStr.c_str());
        auto_ptr<SAMLArtifact> artifact2(new SAMLArtifactType0001(sourceId,handle));
        printResults(artifact2.get(),providerIdStr.c_str());
    }

    void testSAMLArtifactType0002(void) {
        TS_TRACE("artifact type 0x0002");
        auto_ptr<SAMLArtifact> artifact(new SAMLArtifactType0002(providerIdStr,handle));
        printResults(artifact.get(),providerIdStr.c_str());
    }

    void printResults(SAMLArtifact* artifact, const char* str=NULL) {
        TS_ASSERT(artifact);
    
        // print heading:
        cout << "Artifact Type " << SAMLArtifact::toHex(artifact->getTypeCode());
        cout << " (size = " << artifact->getBytes().size() << ")" << endl;
    
        // print URI:
        if (str) { 
          cout << "URI:     " << str << endl; 
        }
        else {
          cout << "URI:     NONE" << endl; 
        }
    
        // print hex-encoded artifact:
        cout << "Hex:     " << SAMLArtifact::toHex(artifact->getBytes()) << endl;
    
        // print base64-encoded artifact:
        cout << "Base64:  " << artifact->encode() << endl;
    
        // print ruler:
        cout <<  "         ----------------------------------------------------------------------" << endl;
        cout <<  "         1234567890123456789012345678901234567890123456789012345678901234567890" << endl;
        cout <<  "                  1         2         3         4         5         6         7" << endl;
        cout <<  "         ----------------------------------------------------------------------" << endl;
    }
};
