/*
 *  Copyright 2001-2005 Internet2
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* SAMLBinding.cpp - SAML binding base class

   Scott Cantor
   6/3/02

   $History:$
*/

#include "internal.h"

using namespace saml;
using namespace std;

const XMLCh SAMLBinding::SOAP[] = // urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding
{
    chLatin_u, chLatin_r, chLatin_n, chColon, chLatin_o, chLatin_a, chLatin_s, chLatin_i, chLatin_s, chColon,
    chLatin_n, chLatin_a, chLatin_m, chLatin_e, chLatin_s, chColon, chLatin_t, chLatin_c, chColon,
    chLatin_S, chLatin_A, chLatin_M, chLatin_L, chColon, chDigit_1, chPeriod, chDigit_0, chColon,
    chLatin_b, chLatin_i, chLatin_n, chLatin_d, chLatin_i, chLatin_n, chLatin_g, chLatin_s, chColon,
    chLatin_S, chLatin_O, chLatin_A, chLatin_P, chDash, chLatin_b, chLatin_i, chLatin_n, chLatin_d, chLatin_i, chLatin_n, chLatin_g, chNull
};

SAMLBinding* SAMLBinding::getInstance(const XMLCh* binding, const DOMElement* e)
{
    return getInstance(binding,DEFAULT_SOAPBINDING_PROVIDER,e);
}

SAMLBinding* SAMLBinding::getInstance(const XMLCh* binding, const char* type, const DOMElement* e)
{
    IPlugIn* p=SAMLConfig::getConfig().getPlugMgr().newPlugin(type,binding,e);
    SAMLBinding* b=dynamic_cast<SAMLBinding*>(p);
    if (b)
        return b;
    delete b;
    throw UnsupportedExtensionException("factory returned plugin type other than SAMLBinding");
}
