/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: paravertalignitem.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:08:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SVX_PARAVERTALIGNITEM_HXX
#define _SVX_PARAVERTALIGNITEM_HXX

// include ---------------------------------------------------------------

#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _SVX_SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
namespace binfilter {

// class SvxParaVertAlignItem ----------------------------------------------

/* [Description]

	This item defines the character alignment in the lines of a paragraph.
 	Currently the alignment can be none (i.e. baseline), top, center or bottom.

*/

class SvxParaVertAlignItem : public SfxUInt16Item
{
public:
	enum { AUTOMATIC, BASELINE, TOP, CENTER, BOTTOM };
	TYPEINFO();

	SvxParaVertAlignItem( sal_uInt16 nValue = 0,
					   const sal_uInt16 nId = ITEMID_PARAVERTALIGN );

//STRIP001 	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;
//STRIP001 	virtual SfxPoolItem*	Create(SvStream &, USHORT) const;
//STRIP001 	virtual SvStream& 		Store(SvStream & rStrm, USHORT nIVer) const;
	virtual USHORT			GetVersion( USHORT nFileVersion ) const;

//STRIP001 	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
//STRIP001 									SfxMapUnit eCoreMetric,
//STRIP001 									SfxMapUnit ePresMetric,
//STRIP001 									String &rText,
//STRIP001                                     const IntlWrapper * = 0 ) const;

//STRIP001 	virtual sal_Bool PutValue( const ::com::sun::star::uno::Any& rVal,
//STRIP001 									BYTE nMemberId );
//STRIP001 	virtual sal_Bool QueryValue( ::com::sun::star::uno::Any& rVal,
//STRIP001 								BYTE nMemberId ) const;

	inline SvxParaVertAlignItem& operator=( const SvxParaVertAlignItem& rItem )
	{
		SetValue( rItem.GetValue() );
		return *this;
	}

//STRIP001 	virtual int 			 operator==( const SfxPoolItem& ) const;

};

}//end of namespace binfilter
#endif

