/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: filedlghelper.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:17:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _FILEDLGHELPER_HXX
#define _FILEDLGHELPER_HXX

#ifndef  _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef  _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_TEMPLATEDESCRIPTION_HPP_
#include <com/sun/star/ui/dialogs/TemplateDescription.hpp>
#endif
#ifndef  _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _ERRCODE_HXX
#include <tools/errcode.hxx>
#endif

#ifndef _SV_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif
#ifndef _SV_GRAPH_HXX
#include <vcl/graph.hxx>
#endif

#ifndef  _SFXDEFS_HXX
#include <bf_sfx2/sfxdefs.hxx>
#endif
#ifndef  _SFX_SFXUNO_HXX
#include <bf_sfx2/sfxuno.hxx>
#endif

//-----------------------------------------------------------------------------

namespace com
{
    namespace sun
    {
        namespace star
        {
            namespace ui
            {
                namespace dialogs
                {
    				class XFilePicker;
				    class XFilePickerListener;
                    struct FilePickerEvent;
                }
            }
        }
    }
}
class SfxItemSet;
class SvStringsDtor;
class Window;
namespace binfilter {
class SfxObjectFactory;

//-----------------------------------------------------------------------------
/*
#define WB_PATH 				0x00100000L
#define WB_OPEN 				0x00200000L
#define WB_SAVEAS				0x00400000L
#define WB_PASSWORD 			0x01000000L
#define WB_READONLY 			0x02000000L
*/

#define SFXWB_INSERT			( 0x04000000L | WB_OPEN )   // ((WinBits)0x00200000)
#define SFXWB_PASSWORD			WB_PASSWORD                 // ((WinBits)0x01000000)
#define SFXWB_READONLY			WB_READONLY                 // ((WinBits)0x02000000)
#define SFXWB_PATHDIALOG		WB_PATH                     // ((WinBits)0x00100000)
#define SFXWB_CLASSPATH			( 0x08000000L | SFXWB_PATHDIALOG )
#define SFXWB_SHOWALLFOLDER		0x10000000L		// alle Ordner auch Mail/News/...
#define SFXWB_MULTISELECTION	0x20000000L		// Multiselection an
#define SFXWB_NOREMOTE          0x40000000L
#define SFXWB_SHOWVERSIONS		0x80000000L  	// Versionsauswahl anzeigen

#define SFXWB_GRAPHIC           0x00800000L     // FileOpen with link and preview box
#define SFXWB_SHOWSTYLES        0x01000000L     // FileOpen with link and preview box and styles

#define SFXWB_EXPORT            ( 0x040000000L | WB_SAVEAS )    // Export dialog

#define FILEDIALOG_FILTER_ALL   "*.*"

#define FILE_OPEN_SERVICE_NAME      "com.sun.star.ui.dialogs.FilePicker"
#define FOLDER_PICKER_SERVICE_NAME  "com.sun.star.ui.dialogs.FolderPicker"

namespace sfx2
{
	#define TEMPL_DESCR( name )	::com::sun::star::ui::dialogs::TemplateDescription::name
	enum
	{
		FILEOPEN_SIMPLE									= TEMPL_DESCR( FILEOPEN_SIMPLE ),
		FILESAVE_SIMPLE									= TEMPL_DESCR( FILESAVE_SIMPLE ),
		FILESAVE_AUTOEXTENSION_PASSWORD					= TEMPL_DESCR( FILESAVE_AUTOEXTENSION_PASSWORD ),
		FILESAVE_AUTOEXTENSION_PASSWORD_FILTEROPTIONS	= TEMPL_DESCR( FILESAVE_AUTOEXTENSION_PASSWORD_FILTEROPTIONS ),
		FILESAVE_AUTOEXTENSION_SELECTION 				= TEMPL_DESCR( FILESAVE_AUTOEXTENSION_SELECTION ),
		FILESAVE_AUTOEXTENSION_TEMPLATE 				= TEMPL_DESCR( FILESAVE_AUTOEXTENSION_TEMPLATE ),
		FILEOPEN_LINK_PREVIEW_IMAGE_TEMPLATE 			= TEMPL_DESCR( FILEOPEN_LINK_PREVIEW_IMAGE_TEMPLATE ),
		FILEOPEN_PLAY 									= TEMPL_DESCR( FILEOPEN_PLAY ),
		FILEOPEN_READONLY_VERSION						= TEMPL_DESCR( FILEOPEN_READONLY_VERSION ),
		FILEOPEN_LINK_PREVIEW							= TEMPL_DESCR( FILEOPEN_LINK_PREVIEW ),
		FILESAVE_AUTOEXTENSION							= TEMPL_DESCR( FILESAVE_AUTOEXTENSION )
	};
}

//*****************************************************************************
// SfxUrlDialog
//*****************************************************************************

#if _SOLAR__PRIVATE
#ifndef DONT_USE_FILE_DIALOG_SERVICE

//STRIP001 class SfxUrlDialog : public ModalDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 	Edit			aEdit;
//STRIP001 	OKButton		aOk;
//STRIP001 	CancelButton	aCancel;
//STRIP001 
//STRIP001 public:
//STRIP001 					SfxUrlDialog( Window* pParent );
//STRIP001 
//STRIP001 	String			GetUrl() const { return aEdit.GetText(); }
//STRIP001 	void 			SetUrl( const String& rUrl ) { aEdit.SetText( rUrl ); }
//STRIP001 };

#endif
#endif

//-----------------------------------------------------------------------------

namespace sfx2 { 

class FileDialogHelper_Impl;

class FileDialogHelper
{
public:
	enum Context						// context where the FileDialogHelper is used
	{
		UNKNOWN_CONTEXT,				// unknown context
		SW_INSERT_GRAPHIC,				// insert graphic in writer
		SW_INSERT_SOUND,				// insert sound in writer
		SW_INSERT_VIDEO,				// insert video in writer
		SC_INSERT_GRAPHIC,				// insert graphic in calc
		SC_INSERT_SOUND,				// insert sound in calc
		SC_INSERT_VIDEO,				// insert video in calc
		SD_INSERT_GRAPHIC,				// insert graphic in draw
		SD_INSERT_SOUND,				// insert sound in draw
		SD_INSERT_VIDEO,				// insert video in draw
		SD_EXPORT,						// export in draw
		SI_EXPORT						// export in impress
	};

private:
    ::com::sun::star::uno::Reference < ::com::sun::star::ui::dialogs::XFilePickerListener > mxImp;
	FileDialogHelper_Impl	*mpImp;

#if _SOLAR__PRIVATE

    const short              getDialogType( sal_uInt32 nFlags ) const;

#endif

public:
							 FileDialogHelper( sal_uInt32 nFlags,
											   const SfxObjectFactory& rFactory,
											   SfxFilterFlags nMust = 0,
											   SfxFilterFlags nDont = 0 ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ;

							 FileDialogHelper( const short nDialogType,
                                               sal_uInt32 nFlags,
											   const SfxObjectFactory& rFactory,
											   SfxFilterFlags nMust = 0,
											   SfxFilterFlags nDont = 0 ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ;

							 FileDialogHelper( sal_uInt32 nFlags ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ;

#ifdef FS_PRIV_DEBUG
							 FileDialogHelper( const short nDialogType,
								 sal_uInt32 nFlags ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ;

							 FileDialogHelper( const short nDialogType,
                                               sal_uInt32 nFlags,
											   Window* _pPreferredParent
											   ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ;
#else
							 FileDialogHelper( const short nDialogType,
                                               sal_uInt32 nFlags,
											   Window* _pPreferredParent = NULL
											   ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ;
#endif

							 virtual                  ~FileDialogHelper(){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ;

	ErrCode					 Execute(){DBG_BF_ASSERT(0, "STRIP"); return 0;}//STRIP001 ErrCode					 Execute();
	void					 SetTitle( const String&  rNewTitle ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ;
	String					 GetPath()const{DBG_BF_ASSERT(0, "STRIP"); return String();} //STRIP001 String					 GetPath() const;

//STRIP001     ::com::sun::star::uno::Sequence< ::rtl::OUString > GetMPath() const;

//STRIP001     void                     AddFilter( const String& rFilterName, const String& rExtension );
//STRIP001     void                     SetCurrentFilter( const String& rFilter );
    void                     SetDisplayDirectory( const String& rPath );

//STRIP001     String                   GetCurrentFilter() const;
    String                   GetDisplayDirectory() const;
//STRIP001     ErrCode                  GetGraphic( Graphic& rGraphic ) const;

    ::com::sun::star::uno::Reference < ::com::sun::star::ui::dialogs::XFilePicker > GetFilePicker() const{DBG_BF_ASSERT(0, "STRIP");::com::sun::star::uno::Reference < ::com::sun::star::ui::dialogs::XFilePicker > x; return x;} //STRIP001 ;

    // XFilePickerListener methods
//STRIP001     virtual void SAL_CALL    FileSelectionChanged( const ::com::sun::star::ui::dialogs::FilePickerEvent& aEvent );
//STRIP001     virtual void SAL_CALL    DirectoryChanged( const ::com::sun::star::ui::dialogs::FilePickerEvent& aEvent );
//STRIP001     virtual void SAL_CALL    ControlStateChanged( const ::com::sun::star::ui::dialogs::FilePickerEvent& aEvent );
//STRIP001     virtual void SAL_CALL    DialogSizeChanged();
//STRIP001     virtual ::rtl::OUString SAL_CALL    HelpRequested( const ::com::sun::star::ui::dialogs::FilePickerEvent& aEvent );

	// retrieves the top-most file picker - i.e. the instance which is currently beeing executed
	static ::com::sun::star::uno::Reference< ::com::sun::star::ui::dialogs::XFilePicker >
							GetTopMostFilePicker( );

	/** sets help ids for the controls in the dialog
		@param _pControlId
			Pointer to a 0-terminated array of control ids. They must be recruited from the
			CommonFilePickerElementIds and ExtendedFilePickerElementIds values.
		@param _pHelpId
			Pointer to an array of help ids. For each element in _pControlId, there must be
			a corresponding element herein.
	*/
//STRIP001 	void					SetControlHelpIds( const sal_Int16* _pControlId, const sal_Int32* _pHelpId );
//STRIP001 	void					SetDialogHelpId( const sal_Int32 _nHelpId );
//STRIP001 	void					CreateMatcher( const SfxObjectFactory& rFactory );

	/** sets the context of the dialog and trigger necessary actions e.g. loading config, setting help id
		@param _eNewContext
			New context for the dialog.
	*/
	void					SetContext( Context _eNewContext );

#if _SOLAR__PRIVATE
	ErrCode					 Execute( const String&   rPath,
									  SvStringsDtor*& rpURLList,
									  SfxItemSet *&   rpSet,
									  String&         rFilter );
	ErrCode					 Execute( SfxItemSet *&   rpSet,
									  String&         rFilter );
#endif
};


#if _SOLAR__PRIVATE
ErrCode FileOpenDialog_Impl( sal_uInt32 nFlags,
							 const SfxObjectFactory& rFact,
							 SvStringsDtor *& rpURLList,
							 String& rFilter,
							 SfxItemSet *& rpSet,
							 String aPath,
							 ULONG nHelpId = 0 );
		// HelpId is only set, when != 0
#endif
}

//-----------------------------------------------------------------------------

}//end of namespace binfilter
#endif
