/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: appwin.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:09:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXAPPWIN_HXX
#define _SFXAPPWIN_HXX

#ifndef _WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
namespace binfilter {

class SfxWorkWindow;
//====================================================================
class SfxApplicationWindow
{
friend class SfxApplicationWindow_Impl;

    static SfxApplicationWindow*    pAppWin;

    Rectangle                       aClientArea;
    SfxApplicationWindow_Impl*      pImpData;
    SfxWorkWindow*                  pWorkWin;

							SfxApplicationWindow();
							SfxApplicationWindow( const SfxApplicationWindow& );
							~SfxApplicationWindow();

	void            		operator=( const SfxApplicationWindow& );

	void    				Activate();
	void    				Deactivate();
	void    				Resize();
	void    				Move();
	void    				Paint( const Rectangle& );
	void    				GetFocus();
	long					Notify( NotifyEvent& rEvt );
	BOOL    				Drop( const DropEvent& rEvt );
	BOOL    				QueryDrop( DropEvent& rEvt );
	void					KeyInput( const KeyEvent &rKeyEvent );
	XubString				GetText() const;

public:
	static
	SfxApplicationWindow*	Get();
	static
	void					Release();

	void					Appear( FASTBOOL bKeepMinimized = FALSE );
	BOOL    				Close();

	const Rectangle&		GetClientAreaPixel() const { return aClientArea; }

	void					SetPresentationMode ( BOOL, WorkWindow* );
	void					SetFullScreenView( BOOL bSet );
	BOOL					IsFullScreenView() const;
	void					InvalidateTitle();
	BOOL					IsInModalMode();
    BOOL                    IsInPresentationMode();

#if _SOLAR__PRIVATE
							// Compatibilit"ats-Hack, GetClientAreaPixel InLine ist
	void            		LockResize_Impl( BOOL bLock = TRUE );
	void 					SetClientAreaPixel_Impl( const Rectangle& rRect ) { aClientArea = rRect; }

	SfxWorkWindow*  		GetWorkWindow_Impl();
	void					DeleteControllers_Impl();
	void            		SetTitle_Impl(BOOL bIBM = FALSE);
	DECL_LINK( 				AliveHandler_Impl, void * );

	void					DoActivate_Impl() { Activate(); }

	void					LoadConfig_Impl();
	void					SwitchMode_Impl();
	void 					StorePosSize_Impl();

	String					GetTitle() const;

private:
	void					Construct_Impl();
	DECL_LINK( 				IdleHandler_Impl, void * );
#endif
};

//--------------------------------------------------------------------

#define SFX_APPWINDOW ( SfxApplicationWindow::Get() )

}//end of namespace binfilter
#endif // #ifndef _SFXAPPWIN_HXX


