/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_swblocks.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 10:13:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #ifndef _SFX_DOCFILT_HACK_HXX //autogen
// auto strip #include <bf_sfx2/docfilt.hxx>
// auto strip #endif
// auto strip #ifndef _SVSTOR_HXX //autogen
// auto strip #include <so3/svstor.hxx>
// auto strip #endif
// auto strip #ifndef _URLOBJ_HXX
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
// auto strip #ifndef SVTOOLS_FSTATHELPER_HXX
// auto strip #include <svtools/fstathelper.hxx>
// auto strip #endif
// auto strip #ifndef _SFXMACITEM_HXX
// auto strip #include <svtools/macitem.hxx>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_CHARCLASS_HXX
// auto strip #include <unotools/charclass.hxx>
// auto strip #endif

// auto strip #ifndef _FRMFMT_HXX //autogen
// auto strip #include <frmfmt.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _DOC_HXX
// auto strip #include <doc.hxx>
// auto strip #endif
// auto strip #ifndef _DOCARY_HXX
// auto strip #include <docary.hxx>
// auto strip #endif

#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif

// auto strip #ifndef _PAM_HXX
// auto strip #include <pam.hxx>
// auto strip #endif
#ifndef _SHELLIO_HXX
#include <shellio.hxx>
#endif
#ifndef _SWBLOCKS_HXX
#include <swblocks.hxx>
#endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
// auto strip #ifndef _MDIEXP_HXX
// auto strip #include <mdiexp.hxx>		// Progress
// auto strip #endif
// auto strip #ifndef _SW_XMLTEXTBLOCKS_HXX
// auto strip #include <SwXMLTextBlocks.hxx>
// auto strip #endif
// auto strip #ifndef _DOCSH_HXX
// auto strip #include <docsh.hxx>
// auto strip #endif
// auto strip #ifndef _SWUNOHELPER_HXX
// auto strip #include <swunohelper.hxx>
// auto strip #endif

#ifndef _STATSTR_HRC
#include <statstr.hrc>
#endif
#ifndef _SWSWERROR_H
#include <swerror.h>
#endif
namespace binfilter {

//STRIP001 SV_IMPL_OP_PTRARR_SORT( SwBlockNames, SwBlockName* );

//////////////////////////////////////////////////////////////////////////

// Hash-Code errechnen (muss nicht eindeutig sein)


//STRIP001 USHORT SwImpBlocks::Hash( const String& r )
//STRIP001 {
//STRIP001 	USHORT n = 0;
//STRIP001 	xub_StrLen nLen = r.Len();
//STRIP001 	if( nLen > 8 )
//STRIP001 		nLen = 8;
//STRIP001 	const sal_Unicode* p = r.GetBuffer();
//STRIP001 	while( nLen-- )
//STRIP001 		n = ( n << 1 ) + *p++;
//STRIP001 	return n;
//STRIP001 }


//STRIP001 SwBlockName::SwBlockName( const String& rShort, const String& rLong, long n )
//STRIP001 	: aShort( rShort ), aLong( rLong ), nPos( n ), aPackageName (rShort),
//STRIP001 	bIsOnlyTxtFlagInit( FALSE ), bIsOnlyTxt( FALSE )
//STRIP001 {
//STRIP001 	nHashS = SwImpBlocks::Hash( rShort );
//STRIP001 	nHashL = SwImpBlocks::Hash( rLong );
//STRIP001 }
//STRIP001 SwBlockName::SwBlockName( const String& rShort, const String& rLong, const String& rPackageName)
//STRIP001 	: aShort( rShort ), aLong( rLong ), nPos( 0 ), aPackageName (rPackageName),
//STRIP001 	bIsOnlyTxtFlagInit( FALSE ), bIsOnlyTxt( FALSE )
//STRIP001 {
//STRIP001 	nHashS = SwImpBlocks::Hash( rShort );
//STRIP001 	nHashL = SwImpBlocks::Hash( rLong );
//STRIP001 }


// Ist die angegebene Datei ein Storage oder gibt es sie nicht?

//STRIP001 short SwImpBlocks::GetFileType( const String& rFile )
//STRIP001 {
//STRIP001 	if( !FStatHelper::IsDocument( rFile ) )
//STRIP001 		return SWBLK_NO_FILE;
//STRIP001 	if( SwXMLTextBlocks::IsFileUCBStorage( rFile ) )
//STRIP001 		return SWBLK_XML;
//STRIP001 	if( SvStorage::IsStorageFile( rFile ) )
//STRIP001 		return SWBLK_SW3;
//STRIP001 	// Kein Storage: Ist es eine SWG-Datei?
//STRIP001 	const SfxFilter* pFltr = SwIoSystem::GetFileFilter( rFile, aEmptyStr );
//STRIP001 	return( pFltr && pFltr->GetUserData().EqualsAscii(FILTER_SWG) )
//STRIP001 							? SWBLK_SW2 : SWBLK_NONE;
//STRIP001 }


//STRIP001 SwImpBlocks::SwImpBlocks( const String& rFile, BOOL bMake )
//STRIP001 	: aFile( rFile ), bReadOnly( TRUE ), bInPutMuchBlocks( FALSE ),
//STRIP001 	nCur( (USHORT)-1 ), pDoc( 0 )
//STRIP001 {
//STRIP001 	FStatHelper::GetModifiedDateTimeOfFile( rFile,
//STRIP001 											&aDateModified, &aTimeModified );
//STRIP001 	INetURLObject aObj(rFile);
//STRIP001 	aObj.setExtension( aEmptyStr );
//STRIP001 	aName = aObj.GetBase();
//STRIP001 }


//STRIP001 SwImpBlocks::~SwImpBlocks()
//STRIP001 {
//STRIP001 	aNames.DeleteAndDestroy( 0, aNames.Count() );
//STRIP001 }

// Loeschen des Inhaltes des Dokuments
//STRIP001 void SwImpBlocks::ClearDoc()
//STRIP001 {
//STRIP001 	pDoc->ClearDoc();
//STRIP001 }

//STRIP001 ULONG SwImpBlocks::GetDocForConversion( USHORT n )
//STRIP001 {
//STRIP001 	return GetDoc( n );
//STRIP001 }

// Erzeugen eines PaMs, der das ganze Dokument umfasst
//STRIP001 SwPaM* SwImpBlocks::MakePaM()
//STRIP001 {
//STRIP001 	SwPaM* pPam = new SwPaM( pDoc->GetNodes().GetEndOfContent() );
//STRIP001 	pPam->Move( fnMoveBackward, fnGoDoc );
//STRIP001 	pPam->SetMark();
//STRIP001 	pPam->Move( fnMoveForward, fnGoDoc );
//STRIP001 	pPam->Exchange();
//STRIP001 	return pPam;
//STRIP001 }


//STRIP001 USHORT SwImpBlocks::GetCount() const
//STRIP001 {
//STRIP001 	return aNames.Count();
//STRIP001 }

// Case Insensitive
//STRIP001 USHORT SwImpBlocks::GetIndex( const String& rShort ) const
//STRIP001 {
//STRIP001 	String s( GetAppCharClass().upper( rShort ) );
//STRIP001 	USHORT nHash = Hash( s );
//STRIP001 	for( USHORT i = 0; i < aNames.Count(); i++ )
//STRIP001 	{
//STRIP001 		SwBlockName* pName = aNames[ i ];
//STRIP001 		if( pName->nHashS == nHash
//STRIP001 		 && pName->aShort == s )
//STRIP001 			return i;
//STRIP001 	}
//STRIP001 	return (USHORT) -1;
//STRIP001 }


//STRIP001 USHORT SwImpBlocks::GetLongIndex( const String& rLong ) const
//STRIP001 {
//STRIP001 	USHORT nHash = Hash( rLong );
//STRIP001 	for( USHORT i = 0; i < aNames.Count(); i++ )
//STRIP001 	{
//STRIP001 		SwBlockName* pName = aNames[ i ];
//STRIP001 		if( pName->nHashL == nHash
//STRIP001 		 && pName->aLong == rLong )
//STRIP001 			return i;
//STRIP001 	}
//STRIP001 	return (USHORT) -1;
//STRIP001 }


//STRIP001 const String& SwImpBlocks::GetShortName( USHORT n ) const
//STRIP001 {
//STRIP001 	if( n < aNames.Count() )
//STRIP001 		return aNames[ n ]->aShort;
//STRIP001 	return aEmptyStr;
//STRIP001 }


//STRIP001 const String& SwImpBlocks::GetLongName( USHORT n ) const
//STRIP001 {
//STRIP001 	if( n < aNames.Count() )
//STRIP001 		return aNames[ n ]->aLong;
//STRIP001 	return aEmptyStr;
//STRIP001 }

//STRIP001 const String& SwImpBlocks::GetPackageName( USHORT n ) const
//STRIP001 {
//STRIP001 	if( n < aNames.Count() )
//STRIP001 		return aNames[ n ]->aPackageName;
//STRIP001 	return aEmptyStr;
//STRIP001 }

//STRIP001 void SwImpBlocks::AddName( const String& rShort, const String& rLong,
//STRIP001 							BOOL bOnlyTxt )
//STRIP001 {
//STRIP001 	USHORT nIdx = GetIndex( rShort );
//STRIP001 	if( nIdx != (USHORT) -1 )
//STRIP001 		aNames.DeleteAndDestroy( nIdx );
//STRIP001 	SwBlockName* pNew = new SwBlockName( rShort, rLong, 0L );
//STRIP001 	pNew->bIsOnlyTxtFlagInit = TRUE;
//STRIP001 	pNew->bIsOnlyTxt = bOnlyTxt;
//STRIP001 	aNames.C40_PTR_INSERT( SwBlockName, pNew );
//STRIP001 }



//STRIP001 BOOL SwImpBlocks::IsFileChanged() const
//STRIP001 {
//STRIP001 	Date aTempDateModified( aDateModified );
//STRIP001 	Time aTempTimeModified( aTimeModified );
//STRIP001 	return FStatHelper::GetModifiedDateTimeOfFile( aFile,
//STRIP001 							&aTempDateModified, &aTempTimeModified ) &&
//STRIP001 		  ( aDateModified != aTempDateModified ||
//STRIP001 			aTimeModified != aTempTimeModified );
//STRIP001 }


//STRIP001 void SwImpBlocks::Touch()
//STRIP001 {
//STRIP001 	FStatHelper::GetModifiedDateTimeOfFile( aFile,
//STRIP001 											&aDateModified, &aTimeModified );
//STRIP001 }

//STRIP001 BOOL SwImpBlocks::IsOnlyTextBlock( const String& ) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 ULONG SwImpBlocks::GetMacroTable( USHORT, SvxMacroTableDtor&, sal_Bool )
//STRIP001 {
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 ULONG SwImpBlocks::SetMacroTable( USHORT nIdx,
//STRIP001 								const SvxMacroTableDtor& rMacroTbl, sal_Bool )
//STRIP001 {
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 BOOL SwImpBlocks::PutMuchEntries( BOOL bOn )
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }

////////////////////////////////////////////////////////////////////////////


/*N*/ SwTextBlocks::SwTextBlocks( const String& rFile )
/*N*/ 	: pImp( 0 ), nErr( 0 )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	INetURLObject aObj(rFile);
//STRIP001 	String sFileName = aObj.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001 	switch( SwImpBlocks::GetFileType( rFile ) )
//STRIP001 	{
//STRIP001 	case SWBLK_SW2:		pImp = new Sw2TextBlocks( sFileName ); 	break;
//STRIP001 	case SWBLK_SW3:		pImp = new Sw3TextBlocks( sFileName );	break;
//STRIP001 	case SWBLK_XML:		pImp = new SwXMLTextBlocks( sFileName ); break;
//STRIP001 	case SWBLK_NO_FILE:	pImp = new SwXMLTextBlocks( sFileName ); break;
//STRIP001 	}
//STRIP001 	if( !pImp )
//STRIP001 		nErr = ERR_SWG_FILE_FORMAT_ERROR;
/*N*/ }


/*N*/ SwTextBlocks::SwTextBlocks( SvStorage& rStg )
/*N*/ 	: nErr( 0 )
/*N*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pImp = new Sw3TextBlocks( rStg );
/*N*/ }


/*N*/ SwTextBlocks::~SwTextBlocks()
/*N*/ {
/*N*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 delete pImp;
/*N*/ }


/*N*/ const String& SwTextBlocks::GetName()
/*N*/ {
/*?*/	return pImp ? pImp->aName : aEmptyStr;
/*N*/ }


/*N*/ void SwTextBlocks::SetName( const String& r )
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( pImp )
//STRIP001 /*?*/ 		pImp->SetName( r );
/*N*/ }


/*N*/ BOOL SwTextBlocks::IsOld() const
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 	if (pImp)
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		short nType = pImp->GetFileType();
//STRIP001 /*?*/ 		if (SWBLK_SW3 == nType || SWBLK_SW2 == nType )
//STRIP001 /*?*/ 			return TRUE;
//STRIP001 /*?*/ 	}
/*N*/ 	return FALSE;
/*N*/ }


/*N*/ ULONG SwTextBlocks::ConvertToNew()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 /*N*/ 	// Wir nehmen die aktuelle Datei, benennen diese in .BAK um
//STRIP001 /*N*/ 	// und kreieren den neuen Storage
//STRIP001 /*?*/ 	if( IsOld() )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		// Erst mal muessen wir die Datei freigeben
//STRIP001 /*?*/ 		short nType = pImp->GetFileType();
//STRIP001 /*?*/ 		Sw2TextBlocks *pTwo = NULL;
//STRIP001 /*?*/ 		Sw3TextBlocks *pThree = NULL;
//STRIP001 /*?*/ 		SwImpBlocks *pOld = NULL;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		pImp->nCur = (USHORT) -1;
//STRIP001 /*?*/ 		String aName( pImp->aFile );
//STRIP001 /*?*/ 		delete pImp; pImp = NULL;
//STRIP001 /*?*/ 		// Jetzt wird umbenannt
//STRIP001 /*?*/ 		INetURLObject aOldFull( aName );
//STRIP001 /*?*/ 		INetURLObject aNewFull( aName );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		aOldFull.SetExtension( String::CreateFromAscii("bak") );
//STRIP001 /*?*/ 		String aOld( aOldFull.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 /*?*/ 		String aNew( aNewFull.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		BOOL bError = !SWUnoHelper::UCB_CopyFile( aNew, aOld, TRUE );
//STRIP001 /*?*/ 		if( bError )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (nType == SWBLK_SW2)
//STRIP001 /*?*/ 				pImp = new Sw2TextBlocks( aOld );
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				pImp = new Sw3TextBlocks( aOld );
//STRIP001 /*?*/ 			return nErr = ERR_SWG_CANNOT_WRITE;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// Die Datei ist erfolgreich umbenannt. Jetzt wird der Storage
//STRIP001 /*?*/ 		// aufgesetzt
//STRIP001 /*?*/ 		if (nType == SWBLK_SW2)
//STRIP001 /*?*/ 			pOld = pTwo = new Sw2TextBlocks( aOld );
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 			pOld = pThree = new Sw3TextBlocks( aOld );
//STRIP001 /*?*/ 		SwXMLTextBlocks* pNew = new SwXMLTextBlocks( aName );
//STRIP001 /*?*/ 		pNew->SetName ( pOld->GetName());
//STRIP001 /*?*/ 		// Wir kopieren den Doc-Ptr in das alte System
//STRIP001 /*?*/ 		// den alten SvPersist heben wir uns aber auf,
//STRIP001 /*?*/ 		// da dieser die ganze Zeit leben bleibt
//STRIP001 /*?*/ 		// und lesen die Dateivorlagen erneut ein
//STRIP001 /*?*/ 		SvPersist* pPersist2 = pOld->pDoc->GetPersist();
//STRIP001 /*?*/ 		if (SWBLK_SW2 == nType )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			delete pOld->pDoc;
//STRIP001 /*?*/ 			pOld->pDoc = pNew->pDoc;
//STRIP001 /*?*/ 			nErr = pTwo->LoadDoc();
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			nErr = pThree->OpenFile ( TRUE );
//STRIP001 /*?*/ 			// Within this call, Sw3IoImp::SetDoc calls RemoveLink
//STRIP001 /*?*/ 			// on the old document, and deletes it if the
//STRIP001 /*?*/ 			// ref count is now zero
//STRIP001 /*?*/ 			pThree->SetDoc ( pNew->pDoc );
//STRIP001 /*?*/ 			pOld->pDoc->AddLink();
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		if( !nErr && 0 == ( nErr = pNew->OpenFile( FALSE )) )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			nErr = pNew->SetConvertMode( TRUE );
//STRIP001 /*?*/ 			// jetzt werden die Bausteine einfach umkopiert!
//STRIP001 /*?*/ 			if( !nErr )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if (SWBLK_SW2 == nType)
//STRIP001 /*?*/ 					pTwo->StatLineStartPercent();
//STRIP001 /*?*/ 				USHORT nCount = pOld->GetCount();
//STRIP001 /*?*/ 				for( USHORT i = 0; i < nCount; i++ )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pNew->ClearDoc();
//STRIP001 /*?*/ 					String aShort( pOld->GetShortName( i ) );
//STRIP001 /*?*/ 					String aLong( pOld->GetLongName( i ) );
//STRIP001 /*?*/ 					pNew->AddName( aShort, aLong );
//STRIP001 /*?*/ 					if ( SWBLK_SW3 == nType && pThree->IsOnlyTextBlock(aShort) )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						String sText;
//STRIP001 /*?*/ 						pThree->GetText( aShort, sText );
//STRIP001 /*?*/ 						pNew->PutText( aShort, aLong, sText );
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						if (SWBLK_SW2 == nType )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							// I think this is how it should work (!!!!!!) mtg
//STRIP001 /*?*/ 							pNew->pDoc->SetPersist( pPersist2 );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						nErr = pOld->GetDocForConversion( i );
//STRIP001 /*?*/ 						if( nErr )
//STRIP001 /*?*/ 							break;
//STRIP001 /*?*/ 						nErr = pNew->BeginPutDoc( aShort, aLong );
//STRIP001 /*?*/ 						if( nErr )
//STRIP001 /*?*/ 							break;
//STRIP001 /*?*/ 						nErr = pNew->PutDoc();
//STRIP001 /*?*/ 						if( nErr )
//STRIP001 /*?*/ 							break;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					// convert macros, too
//STRIP001 /*?*/ 					SvxMacroTableDtor aMacroTable;
//STRIP001 /*?*/ 					pOld->GetMacroTable( i, aMacroTable, sal_True );
//STRIP001 /*?*/ 					pNew->SetMacroTable( i, aMacroTable, sal_True );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (SWBLK_SW2 == nType )
//STRIP001 /*?*/ 						pNew->pDoc->SetPersist( 0 );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				if (SWBLK_SW2 == nType )
//STRIP001 /*?*/ 					::EndProgress( pOld->pDoc->GetDocShell() );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			if( !nErr )
//STRIP001 /*?*/ 				nErr = pNew->SetConvertMode( FALSE );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		if ( SWBLK_SW3 == nType )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			pThree->CloseFile();
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// Haben wir es geschafft?
//STRIP001 /*?*/ 			pOld->pDoc = NULL;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		pNew->ClearDoc();
//STRIP001 /*?*/ 		if( !nErr )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			delete pOld;
//STRIP001 /*?*/ 			pImp = pNew;
//STRIP001 /*?*/ 			SWUnoHelper::UCB_DeleteFile( aOld );
//STRIP001 /*?*/ 			pNew->MakeBlockList();
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			delete pOld; delete pNew;
//STRIP001 /*?*/ 			SWUnoHelper::UCB_DeleteFile( aNew );
//STRIP001 /*?*/ 			SWUnoHelper::UCB_CopyFile( aOld, aNew, TRUE );
//STRIP001 /*?*/ 			if ( SWBLK_SW2 == nType )
//STRIP001 /*?*/ 				pImp = new Sw2TextBlocks( aOld );
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				pImp = new Sw3TextBlocks( aOld );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		pNew->CloseFile();
//STRIP001 /*?*/ 		FStatHelper::GetModifiedDateTimeOfFile( aNew,
//STRIP001 /*?*/ 							&pImp->aDateModified, &pImp->aTimeModified );
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	return nErr;
/*N*/ }


/*N*/ USHORT SwTextBlocks::GetCount() const
/*N*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 	return pImp ? pImp->GetCount() : 0;
/*N*/ }


/*N*/ USHORT SwTextBlocks::GetIndex( const String& r ) const
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 return pImp ? pImp->GetIndex( r ) : (USHORT) -1;
/*N*/ }


/*N*/ USHORT SwTextBlocks::GetLongIndex( const String& r ) const
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP");return 0; //STRIP001 return pImp ? (USHORT)(pImp->GetLongIndex( r )) : (USHORT) -1;
/*N*/ }


/*N*/ const String& SwTextBlocks::GetShortName( USHORT n ) const
/*N*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	if( pImp )
//STRIP001 /*?*/ 		return pImp->GetShortName( n );
/*?*/ 	return aEmptyStr;
/*N*/ }


/*N*/ const String& SwTextBlocks::GetLongName( USHORT n ) const
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( pImp )
//STRIP001 /*?*/ 		return pImp->GetLongName( n );
/*?*/ 	return aEmptyStr;
/*N*/ }


/*N*/ BOOL SwTextBlocks::Delete( USHORT n )
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( pImp && !pImp->bInPutMuchBlocks )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		if( pImp->IsFileChanged() )
//STRIP001 /*?*/ 			nErr = ERR_TXTBLOCK_NEWFILE_ERROR;
//STRIP001 /*?*/ 		else if( 0 == (nErr = pImp->OpenFile( FALSE ) ))
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			nErr = pImp->Delete( n );
//STRIP001 /*?*/ 			if( !nErr )
//STRIP001 /*?*/ 				pImp->aNames.DeleteAndDestroy( n );
//STRIP001 /*?*/ 			if( n == pImp->nCur )
//STRIP001 /*?*/ 				pImp->nCur = (USHORT) -1;
//STRIP001 /*?*/ 			if( !nErr )
//STRIP001 /*?*/ 				nErr = pImp->MakeBlockList();
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		pImp->CloseFile();
//STRIP001 /*?*/ 		pImp->Touch();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		return BOOL( nErr == 0 );
//STRIP001 /*?*/ 	}
/*?*/ 	return FALSE;
/*N*/ }


/*N*/ USHORT SwTextBlocks::Rename( USHORT n, const String* s, const String* l )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 /*?*/ 	USHORT nIdx = (USHORT)-1;
//STRIP001 /*?*/ 	if( pImp && !pImp->bInPutMuchBlocks )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		pImp->nCur = nIdx;
//STRIP001 /*?*/ 		String aNew, aLong;
//STRIP001 /*?*/ 		if( s )
//STRIP001 /*?*/ 			aNew = aLong = *s;
//STRIP001 /*?*/ 		if( l )
//STRIP001 /*?*/ 			aLong = *l;
//STRIP001 /*?*/ 		if( !aNew.Len() )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			ASSERT( !this, "Kein Kurzname in Rename angegeben" );
//STRIP001 /*?*/ 			nErr = ERR_SWG_INTERNAL_ERROR; return (USHORT) -1;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if( pImp->IsFileChanged() )
//STRIP001 /*?*/ 			nErr = ERR_TXTBLOCK_NEWFILE_ERROR;
//STRIP001 /*?*/ 		else if( 0 == (	nErr = pImp->OpenFile( FALSE )))
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// Vorher den neuen Eintrag in die Liste setzen!
//STRIP001 /*?*/ 			GetAppCharClass().toUpper( aNew );
//STRIP001 /*?*/  			nErr = pImp->Rename( n, aNew, aLong );
//STRIP001 /*?*/ 			if( !nErr )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				BOOL bOnlyTxt = pImp->aNames[ n ]->bIsOnlyTxt;
//STRIP001 /*?*/ 				pImp->aNames.DeleteAndDestroy( n );
//STRIP001 /*?*/ 				pImp->AddName( aNew, aLong, bOnlyTxt );
//STRIP001 /*?*/ 				nErr = pImp->MakeBlockList();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		pImp->CloseFile();
//STRIP001 /*?*/ 		pImp->Touch();
//STRIP001 /*?*/ 		if( !nErr )
//STRIP001 /*?*/ 			nIdx = pImp->GetIndex( aNew );
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	return nIdx;
/*N*/ }

//STRIP001 ULONG SwTextBlocks::CopyBlock( SwTextBlocks& rSource, String& rSrcShort,
//STRIP001 								const String& rLong )
//STRIP001 {
//STRIP001 	BOOL bIsOld = FALSE;
//STRIP001 	if (rSource.pImp)
//STRIP001 	{
//STRIP001 		short nType = rSource.pImp->GetFileType();
//STRIP001 		if (SWBLK_SW2 == nType || SWBLK_SW3 == nType )
//STRIP001 			bIsOld = TRUE;
//STRIP001 	}
//STRIP001 	if( bIsOld ) //rSource.IsOld() )
//STRIP001 		nErr = ERR_SWG_OLD_GLOSSARY;
//STRIP001 	else if( pImp->bInPutMuchBlocks )
//STRIP001 		nErr = ERR_SWG_INTERNAL_ERROR;
//STRIP001 	else
//STRIP001 		nErr = pImp->CopyBlock(*rSource.pImp, rSrcShort, rLong);
//STRIP001 	return nErr;
//STRIP001 }

//STRIP001 BOOL SwTextBlocks::BeginGetDoc( USHORT n )
//STRIP001 {
//STRIP001 	if( pImp && !pImp->bInPutMuchBlocks )
//STRIP001 	{
//STRIP001 // diese Optimierierung darf es nicht mehr geben. OLE-Objecte muessen auf
//STRIP001 // ihre SubStorages zugreifem koennen!
//STRIP001 //		if( n == pImp->nCur )
//STRIP001 //			return TRUE;
//STRIP001 
//STRIP001 		if( pImp->IsFileChanged() )
//STRIP001 			nErr = ERR_TXTBLOCK_NEWFILE_ERROR;
//STRIP001 		else if( 0 == (	nErr = pImp->OpenFile( TRUE )))
//STRIP001 		{
//STRIP001 			pImp->ClearDoc();
//STRIP001 			nErr = pImp->GetDoc( n );
//STRIP001 			if( nErr )
//STRIP001 				pImp->nCur = (USHORT)-1;
//STRIP001 			else
//STRIP001 				pImp->nCur = n;
//STRIP001 		}
//STRIP001 		return BOOL( nErr == 0 );
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }


//STRIP001 void SwTextBlocks::EndGetDoc()
//STRIP001 {
//STRIP001 	if( pImp && !pImp->bInPutMuchBlocks )
//STRIP001 		pImp->CloseFile();
//STRIP001 }


/*N*/ BOOL SwTextBlocks::BeginPutDoc( const String& s, const String& l )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 /*?*/ 	if( pImp )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		BOOL bOk = pImp->bInPutMuchBlocks;
//STRIP001 /*?*/ 		if( !bOk )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if( pImp->IsFileChanged() )
//STRIP001 /*?*/ 				nErr = ERR_TXTBLOCK_NEWFILE_ERROR;
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				nErr = pImp->OpenFile( FALSE );
//STRIP001 /*?*/ 			bOk = 0 == nErr;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		if( bOk )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			String aNew( s );
//STRIP001 /*?*/ 			GetAppCharClass().toUpper( aNew );
//STRIP001 /*?*/ 			nErr = pImp->BeginPutDoc( aNew, l );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		if( nErr )
//STRIP001 /*?*/ 			pImp->CloseFile();
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	return 0 == nErr;
/*N*/ }


/*N*/ USHORT SwTextBlocks::PutDoc()
/*N*/ {DBG_BF_ASSERT(0, "STRIP");return FALSE; //STRIP001 
//STRIP001 /*?*/ 	USHORT nIdx = (USHORT)-1;
//STRIP001 /*?*/ 	if( pImp )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		nErr = pImp->PutDoc();
//STRIP001 /*?*/ 		if( !nErr )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			pImp->nCur = GetIndex( pImp->aShort );
//STRIP001 /*?*/ 			if( pImp->nCur != (USHORT) -1 )
//STRIP001 /*?*/ 				pImp->aNames[ pImp->nCur ]->aLong = pImp->aLong;
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pImp->AddName( pImp->aShort, pImp->aLong );
//STRIP001 /*?*/ 				pImp->nCur = pImp->GetIndex( pImp->aShort );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			if( !pImp->bInPutMuchBlocks )
//STRIP001 /*?*/ 				nErr = pImp->MakeBlockList();
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		if( !pImp->bInPutMuchBlocks )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			pImp->CloseFile();
//STRIP001 /*?*/ 			pImp->Touch();
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		nIdx = pImp->nCur;
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	return nIdx;
/*N*/ }


//STRIP001 const String& SwTextBlocks::GetText( USHORT n )
//STRIP001 {
//STRIP001 	if( pImp && !pImp->bInPutMuchBlocks )
//STRIP001 	{
//STRIP001 		if( pImp->IsFileChanged() )
//STRIP001 			nErr = ERR_TXTBLOCK_NEWFILE_ERROR;
//STRIP001 		else if( 0 == (	nErr = pImp->OpenFile( TRUE )))
//STRIP001 		{
//STRIP001 			nErr = pImp->GetText( n, pImp->aCur );
//STRIP001 			pImp->CloseFile();
//STRIP001 			if( !nErr )
//STRIP001 				return pImp->aCur;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aEmptyStr;
//STRIP001 }


/*N*/ USHORT SwTextBlocks::PutText( const String& rShort, const String& rName,
/*N*/ 							  const String& rTxt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 /*?*/ 	USHORT nIdx = (USHORT) -1;
//STRIP001 /*?*/ 	if( pImp )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		BOOL bOk = pImp->bInPutMuchBlocks;
//STRIP001 /*?*/ 		if( !bOk )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if( pImp->IsFileChanged() )
//STRIP001 /*?*/ 				nErr = ERR_TXTBLOCK_NEWFILE_ERROR;
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				nErr = pImp->OpenFile( FALSE );
//STRIP001 /*?*/ 			bOk = 0 == nErr;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		if( bOk )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			String aNew( rShort );
//STRIP001 /*?*/ 			GetAppCharClass().toUpper( aNew );
//STRIP001 /*?*/ 			nErr = pImp->PutText( aNew, rName, rTxt );
//STRIP001 /*?*/ 			pImp->nCur = (USHORT) -1;
//STRIP001 /*?*/ 			if( !nErr )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				nIdx = GetIndex( pImp->aShort );
//STRIP001 /*?*/ 				if( nIdx != (USHORT) -1 )
//STRIP001 /*?*/ 					pImp->aNames[ nIdx ]->aLong = rName;
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pImp->AddName( pImp->aShort, rName, TRUE );
//STRIP001 /*?*/ 					nIdx = pImp->GetIndex( pImp->aShort );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				if( !pImp->bInPutMuchBlocks )
//STRIP001 /*?*/ 					nErr = pImp->MakeBlockList();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		if( !pImp->bInPutMuchBlocks )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			pImp->CloseFile();
//STRIP001 /*?*/ 			pImp->Touch();
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	return nIdx;
/*N*/ }


/*N*/ SwDoc* SwTextBlocks::GetDoc()
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 if( pImp )
//STRIP001 /*?*/ 		return pImp->pDoc;
//STRIP001 /*?*/ 	return 0;
/*N*/ }


/*N*/ void SwTextBlocks::ClearDoc()
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( pImp )
//STRIP001 /*?*/ 		pImp->ClearDoc();
//STRIP001 /*?*/ 	pImp->nCur = (USHORT) -1;
/*N*/ }


/*N*/ const String& SwTextBlocks::GetFileName() const
/*N*/ {
/*?*/ 	 return pImp->GetFileName();
/*N*/ }


//STRIP001 BOOL SwTextBlocks::IsReadOnly() const
//STRIP001 {
//STRIP001 	return pImp->bReadOnly;
//STRIP001 }

//STRIP001 BOOL SwTextBlocks::IsOnlyTextBlock( USHORT nIdx ) const
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	if( pImp && !pImp->bInPutMuchBlocks )
//STRIP001 	{
//STRIP001 		SwBlockName* pBlkNm = pImp->aNames[ nIdx ];
//STRIP001 		if( !pBlkNm->bIsOnlyTxtFlagInit &&
//STRIP001 			!pImp->IsFileChanged() && !pImp->OpenFile( TRUE ) )
//STRIP001 		{
//STRIP001 			pBlkNm->bIsOnlyTxt = pImp->IsOnlyTextBlock( pBlkNm->aShort );
//STRIP001 			pBlkNm->bIsOnlyTxtFlagInit = TRUE;
//STRIP001 			pImp->CloseFile();
//STRIP001 		}
//STRIP001 		bRet = pBlkNm->bIsOnlyTxt;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 BOOL SwTextBlocks::IsOnlyTextBlock( const String& rShort ) const
//STRIP001 {
//STRIP001 	USHORT nIdx = pImp->GetIndex( rShort );
//STRIP001 	if( USHRT_MAX != nIdx )
//STRIP001 	{
//STRIP001 		if( pImp->aNames[ nIdx ]->bIsOnlyTxtFlagInit )
//STRIP001 			return pImp->aNames[ nIdx ]->bIsOnlyTxt;
//STRIP001 		return IsOnlyTextBlock( nIdx );
//STRIP001 	}
//STRIP001 
//STRIP001 	ASSERT( !this, "ungueltiger Name" );
//STRIP001 	return FALSE;
//STRIP001 }

/*N*/ BOOL SwTextBlocks::GetMacroTable( USHORT nIdx, SvxMacroTableDtor& rMacroTbl )
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP");return FALSE; //STRIP001 return ( pImp && !pImp->bInPutMuchBlocks )
//STRIP001 /*?*/ 				? 0 == pImp->GetMacroTable( nIdx, rMacroTbl )
//STRIP001 /*?*/ 				: TRUE;
/*N*/ }

/*N*/ BOOL SwTextBlocks::SetMacroTable( USHORT nIdx,
/*N*/ 								const SvxMacroTableDtor& rMacroTbl )
/*N*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 	return ( pImp && !pImp->bInPutMuchBlocks )
//STRIP001 /*?*/ 				? 0 == pImp->SetMacroTable( nIdx, rMacroTbl )
//STRIP001 /*?*/ 				: TRUE;
/*N*/ }
/*N*/ 

//STRIP001 String SwTextBlocks::GetValidShortCut( const String& rLong,
//STRIP001 							 			BOOL bCheckInBlock ) const
//STRIP001 {
//STRIP001 	String sRet;
//STRIP001 	xub_StrLen nLen = rLong.Len();
//STRIP001 	if( nLen )
//STRIP001 	{
//STRIP001 		xub_StrLen nStart = 0;
//STRIP001 		while( ' ' == rLong.GetChar( nStart ) )
//STRIP001 			if( ++nStart < nLen )
//STRIP001 				break;
//STRIP001 
//STRIP001 		if( nStart < nLen )
//STRIP001 		{
//STRIP001 			sal_Unicode cCurr, cPrev = rLong.GetChar( nStart );
//STRIP001 			sRet = cPrev;
//STRIP001 			for( ++nStart; nStart < nLen; ++nStart, cPrev = cCurr )
//STRIP001 				if( ' ' == cPrev &&
//STRIP001 					' ' != ( cCurr = rLong.GetChar( nStart )) )
//STRIP001 					sRet += cCurr;
//STRIP001 		}
//STRIP001 		if( bCheckInBlock )
//STRIP001 		{
//STRIP001 			USHORT nCurPos = GetIndex( sRet );
//STRIP001 			nStart = 0;
//STRIP001 			nLen = sRet.Len();
//STRIP001 			while( (USHORT)-1 != nCurPos )
//STRIP001 			{
//STRIP001 				sRet.Erase( nLen ) +=
//STRIP001 					String::CreateFromInt32( ++nStart );// add an Number to it
//STRIP001 				nCurPos = GetIndex( sRet );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return sRet;
//STRIP001 }

//STRIP001 BOOL SwTextBlocks::StartPutMuchBlockEntries()
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	if( !IsOld() && pImp )
//STRIP001 		bRet = pImp->PutMuchEntries( TRUE );
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 void SwTextBlocks::EndPutMuchBlockEntries()
//STRIP001 {
//STRIP001 	if( pImp )
//STRIP001 		pImp->PutMuchEntries( FALSE );
//STRIP001 }



}
